/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.AbstractArgumentValueProxy;
import com.arm.mgd.core.scripting.NamedArgumentValuesProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.python.PyDocs;
import com.arm.mgd.core.scripting.python.PyImmutableDict;
import com.arm.mgd.core.scripting.python.PythonArgumentVisitor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;

@PyDocs.PyExpose
public class PyNamedArguments
extends PyImmutableDict {
    private static final long serialVersionUID = 7867271189983243333L;
    private final @NonNull NamedArgumentValuesProxy proxy;
    private static final @NonNull AbstractArgumentValueProxy.IArgumentValueProxyVisitor<@NonNull PyObject> PYTHON_ARGUMENT_VISITOR = new PythonArgumentVisitor();

    PyNamedArguments(@NonNull NamedArgumentValuesProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    protected @NonNull ProxyObject getProxyObject() {
        return this.proxy;
    }

    @Override
    protected @NonNull List<@NonNull PyObject> getKeys() {
        List<@NonNull String> names = this.proxy.getNames();
        ArrayList<@NonNull PyObject> keys = new ArrayList<PyObject>(names.size());
        for (String name : names) {
            keys.add((PyObject)new PyString(name));
        }
        return keys;
    }

    @Override
    protected int size() {
        return this.proxy.size();
    }

    @Override
    protected @Nullable PyObject getValue(@Nullable PyObject object) {
        AbstractArgumentValueProxy<?> parameterValue;
        String obj = null;
        try {
            obj = (String)Py.tojava((PyObject)object, String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (obj != null && (parameterValue = this.proxy.getArgumentValue(obj)) != null) {
            return parameterValue.accept(PYTHON_ARGUMENT_VISITOR);
        }
        return Py.None;
    }

    @Override
    protected @NonNull List<@NonNull PyObject> getValues() {
        @NonNull List<@NonNull AbstractArgumentValueProxy<?>> parameterValues = this.proxy.getArgumentValues();
        @NonNull ArrayList<@NonNull PyObject> values = new ArrayList<PyObject>(parameterValues.size());
        for (AbstractArgumentValueProxy<?> parameterValue : parameterValues) {
            values.add(parameterValue.accept(PYTHON_ARGUMENT_VISITOR));
        }
        return values;
    }
}

