/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.python.PyDocs;
import com.arm.mgd.core.scripting.python.PyProxyObject;
import com.arm.mgd.core.scripting.python.PyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

@PyDocs.PyExpose
public abstract class PyImmutableDict
extends PyProxyObject {
    private static final long serialVersionUID = -3770929116465740922L;

    protected abstract @NonNull List<@NonNull PyObject> getKeys();

    protected abstract int size();

    protected abstract @Nullable PyObject getValue(@Nullable PyObject var1);

    protected abstract @NonNull List<@NonNull PyObject> getValues();

    public PyObject __finditem__(PyObject key) {
        return this.getValue(key);
    }

    @PyDocs.PyExpose
    public PyObject __getitem__(PyObject key) {
        return super.__getitem__(key);
    }

    @PyDocs.PyExpose
    public boolean __contains__(PyObject o) {
        return super.__contains__(o);
    }

    @PyDocs.PyExpose
    public PyObject __iter__() {
        return this.iterkeys();
    }

    @PyDocs.PyExpose
    public int __len__() {
        return this.size();
    }

    @PyDocs.PyExpose
    public boolean __nonzero__() {
        return this.__len__() != 0;
    }

    public PyString __repr__() {
        @NonNull List<@NonNull PyObject> keys = this.getKeys();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        while (i < keys.size()) {
            @NonNull PyObject key = keys.get(i);
            PyObject value = this.getValue(key);
            assert (value != null);
            sb.append((CharSequence)key.__repr__());
            sb.append(": ").append((CharSequence)value.__str__());
            if (i != keys.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("}");
        return new PyString(sb.toString());
    }

    public PyString __str__() {
        return this.__repr__();
    }

    @PyDocs.PyExpose
    public @NonNull PyDictionary copy() {
        @NonNull List<@NonNull PyObject> keys = this.getKeys();
        @NonNull List<@NonNull PyObject> values = this.getValues();
        HashMap<PyObject, PyObject> copy = new HashMap<PyObject, PyObject>(keys.size());
        int i = 0;
        while (i < keys.size()) {
            copy.put(keys.get(i), values.get(i));
            ++i;
        }
        return new PyDictionary(copy);
    }

    @PyDocs.PyExpose
    public @Nullable PyObject get(PyObject key, PyObject defaultValue) {
        PyObject value = this.getValue(key);
        return value != null ? value : defaultValue;
    }

    @PyDocs.PyExpose
    public @NonNull PyObject get(PyObject key) {
        PyObject value = this.getValue(key);
        return value != null ? value : PyUtils.PyNone;
    }

    @PyDocs.PyExpose
    public @NonNull PyBoolean has_key(PyObject key) {
        return PyUtils.toPyBool(this.getValue(key) != null);
    }

    @PyDocs.PyExpose
    public @NonNull PyList items() {
        return new PyList(this.getItems());
    }

    @PyDocs.PyExpose
    public @NonNull PyObject iteritems() {
        return new PyImmutableDictIterator(this.getItems());
    }

    @PyDocs.PyExpose
    public @NonNull PyObject iterkeys() {
        return new PyImmutableDictIterator(this.getKeys());
    }

    @PyDocs.PyExpose
    public @NonNull PyObject itervalues() {
        return new PyImmutableDictIterator(this.getValues());
    }

    @PyDocs.PyExpose
    public @NonNull PyList keys() {
        return new PyList(this.getKeys());
    }

    @PyDocs.PyExpose
    public @NonNull PyList values() {
        return new PyList(this.getValues());
    }

    private @NonNull List<@NonNull PyTuple> getItems() {
        @NonNull List<@NonNull PyObject> keys = this.getKeys();
        @NonNull List<@NonNull PyObject> values = this.getValues();
        @NonNull ArrayList<@NonNull PyTuple> items = new ArrayList<PyTuple>(keys.size());
        int i = 0;
        while (i < keys.size()) {
            items.add(new PyTuple(new PyObject[]{keys.get(i), values.get(i)}));
            ++i;
        }
        return items;
    }

    private static class PyImmutableDictIterator
    extends PyIterator {
        private static final long serialVersionUID = -7983696501979586767L;
        private final @NonNull List<@NonNull ? extends PyObject> list;
        private int currentIndex = 0;

        private PyImmutableDictIterator(@NonNull List<@NonNull ? extends PyObject> list) {
            this.list = list;
        }

        public PyObject __iternext__() {
            int index = this.currentIndex++;
            return this.list.size() > index ? this.list.get(index) : null;
        }
    }
}

