/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.python.PyDocs;
import com.arm.mgd.core.scripting.python.PyTrace;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.python.core.Py;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PyString;
import org.python.core.PySystemState;

@PyDocs.PyExpose
public class PyHelp
extends PyObject {
    private static final long serialVersionUID = 4570113840167725402L;
    private static final @NonNull String helpPrompt = "Type help() for information about the " + VersionProperties.FULL_PRODUCT_NAME + " scripting console, or help(object) for help about object.";
    private static final @NonNull String @NonNull [] interactiveHelpPromptIntro = new String[]{"Welcome to the " + VersionProperties.FULL_PRODUCT_NAME + " scripting console.", "", "Type help(object) for help about object", "e.g. help(trace) will show you help for the implicitly loaded trace object that represents the current " + VersionProperties.FULL_PRODUCT_NAME + " trace.", "Alternatively, help(" + PyTrace.class.getSimpleName() + ") will show you the same information."};
    private static final @NonNull String @NonNull [] interactiveHelpPromptEnd = new String[]{"Some Python built-in functions are unavailable.", "Look in the samples directory for some examples of how to use the scripting interface, or refer to the " + VersionProperties.FULL_PRODUCT_NAME + " user guide."};
    private static final @NonNull String HELP_NEW_LINE = String.valueOf(System.lineSeparator()) + " |  ";
    private static final @NonNull String HELP_NEW_LINE_INDENT = String.valueOf(System.lineSeparator()) + " |    ";
    private final @NonNull PyDocs pyDocs = new PyDocs();
    private final @NonNull Writer outputWriter;
    private final @NonNull PyObject builtInHelp;

    static void replaceBuiltInHelp(@NonNull Writer outputWriter, @NonNull PySystemState sysState) {
        PyObject builtInHelp = sysState.getBuiltins().__getitem__((PyObject)new PyString("help"));
        if (builtInHelp == null) {
            throw new AssertionError((Object)"System state doesn't have help builtin available.");
        }
        PyHelp help = new PyHelp(outputWriter, builtInHelp);
        sysState.getBuiltins().__setitem__("help", (PyObject)help);
        for (Class<?> type : help.pyDocs.getDocumentedTypes()) {
            sysState.getBuiltins().__setitem__(type.getSimpleName(), Py.java2py(type));
        }
    }

    private PyHelp(@NonNull Writer outputWriter, @NonNull PyObject builtInHelp) {
        this.outputWriter = outputWriter;
        this.builtInHelp = builtInHelp;
    }

    @PyDocs.PyExpose
    public PyObject __call__() {
        String s;
        this.println();
        Object object = interactiveHelpPromptIntro;
        int n = interactiveHelpPromptIntro.length;
        int n2 = 0;
        while (n2 < n) {
            s = object[n2];
            this.println(s);
            ++n2;
        }
        this.println();
        this.println("The following " + VersionProperties.FULL_PRODUCT_NAME + " types are available:");
        for (Class<?> type : this.pyDocs.getDocumentedTypes()) {
            this.print(HELP_NEW_LINE);
            this.print(type.getSimpleName());
            for (String s2 : ((PyDocs.PyTypeDocs)NullUtils.neverNull((Object)this.pyDocs.getTypeDocs(type))).getDocs()) {
                this.print(HELP_NEW_LINE_INDENT);
                this.print(s2);
            }
            this.print(HELP_NEW_LINE);
        }
        this.println();
        this.println();
        object = interactiveHelpPromptEnd;
        n = interactiveHelpPromptEnd.length;
        int n3 = 0;
        while (n3 < n) {
            s = object[n3];
            this.println(s);
            ++n3;
        }
        return Py.None;
    }

    @PyDocs.PyExpose
    public PyObject __call__(PyObject object) {
        Object asJavaClass;
        PyDocs.PyTypeDocs typeDocs = null;
        PyMethod method = null;
        if (object instanceof PyMethod) {
            method = (PyMethod)object;
            typeDocs = this.pyDocs.getTypeDocs((Class)NullUtils.neverNull(method.__self__.getClass()));
        }
        if (typeDocs == null && object != null) {
            typeDocs = this.pyDocs.getTypeDocs((Class)NullUtils.neverNull(object.getClass()));
        }
        if (typeDocs == null && (asJavaClass = object.__tojava__(Class.class)) instanceof Class) {
            typeDocs = this.pyDocs.getTypeDocs((Class)asJavaClass);
        }
        if (typeDocs != null) {
            if (method != null) {
                this.outputMethodHelp(method, typeDocs);
            } else {
                this.outputTypeHelp(typeDocs);
            }
            return Py.None;
        }
        return this.builtInHelp.__call__(object);
    }

    private void outputMethodHelp(@NonNull PyMethod pyMethod, @NonNull PyDocs.PyTypeDocs typeDocs) {
        PyReflectedFunction func = (PyReflectedFunction)pyMethod.__func__;
        StringBuilder sb = new StringBuilder();
        sb.append("Help on method ").append(func.__name__).append(" of ").append(typeDocs.getClass().getSimpleName()).append(" object:");
        for (PyDocs.PyMethodDocs methodDoc : typeDocs.getMethodDocs()) {
            if (!methodDoc.getName().equals(func.__name__)) continue;
            PyHelp.appendMethodDocs(sb, methodDoc);
        }
        sb.append(System.lineSeparator()).append(System.lineSeparator());
        this.print(sb.toString());
    }

    private void outputTypeHelp(@NonNull PyDocs.PyTypeDocs typeDocs) {
        StringBuilder sb = new StringBuilder();
        sb.append("Help on ").append(typeDocs.getName()).append(" object:");
        sb.append(HELP_NEW_LINE);
        for (String doc : typeDocs.getDocs()) {
            sb.append(HELP_NEW_LINE);
            sb.append(doc);
        }
        for (PyDocs.PyMethodDocs methodDocs : typeDocs.getMethodDocs()) {
            PyHelp.appendMethodDocs(sb, methodDocs);
        }
        sb.append(System.lineSeparator()).append(System.lineSeparator());
        this.print(sb.toString());
    }

    private static void appendMethodDocs(@NonNull StringBuilder sb, @NonNull PyDocs.PyMethodDocs methodDocs) {
        sb.append(HELP_NEW_LINE).append(HELP_NEW_LINE);
        PyHelp.appendMethodName(sb, methodDocs);
        sb.append(HELP_NEW_LINE_INDENT).append(methodDocs.getExample()).append(HELP_NEW_LINE_INDENT);
        for (String doc : methodDocs.getDocs()) {
            sb.append(HELP_NEW_LINE_INDENT);
            sb.append(doc);
        }
    }

    private static void appendMethodName(@NonNull StringBuilder sb, @NonNull PyDocs.PyMethodDocs methodDocs) {
        sb.append(methodDocs.getName()).append("(");
        int parameterCount = methodDocs.getParameterCount();
        int j = 0;
        while (j < parameterCount) {
            sb.append("arg").append(j);
            if (j != parameterCount - 1) {
                sb.append(",");
            }
            ++j;
        }
        sb.append(")");
    }

    public PyString __str__() {
        return new PyString(helpPrompt);
    }

    public PyString __repr__() {
        return new PyString(helpPrompt);
    }

    private void print(@Nullable String string) {
        if (string != null) {
            try {
                this.outputWriter.write(string);
            }
            catch (IOException e) {
                CoreLogging.warning(null, e, "Could not print to scripting output writer");
            }
        }
    }

    private void println() {
        this.print((String)NullUtils.neverNull((Object)System.lineSeparator()));
    }

    private void println(@Nullable String string) {
        this.print(string);
        this.println();
    }
}

