/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.AbstractNonIndexedStateValueProxy;
import com.arm.mgd.core.scripting.AssetStateValueProxy;
import com.arm.mgd.core.scripting.BooleanStateValueProxy;
import com.arm.mgd.core.scripting.ConstantAssetStateValueProxy;
import com.arm.mgd.core.scripting.ConstantStateValueProxy;
import com.arm.mgd.core.scripting.FloatStateValueProxy;
import com.arm.mgd.core.scripting.FunctionCallStatesProxy;
import com.arm.mgd.core.scripting.IStateValueProxy;
import com.arm.mgd.core.scripting.IndexedStateValuesProxy;
import com.arm.mgd.core.scripting.IntegerStateValueProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.RGBAStateValueProxy;
import com.arm.mgd.core.scripting.StringStateValueProxy;
import com.arm.mgd.core.scripting.python.PyImmutableDict;
import com.arm.mgd.core.scripting.python.PyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class PyFunctionCallStates
extends PyImmutableDict {
    private static final long serialVersionUID = 961736631262765065L;
    private static final @NonNull IStateValueProxy.IStateValueProxyVisitor<@NonNull PyObject> PYTHON_STATE_ITEM_VISITOR = new IStateValueProxy.IStateValueProxyVisitor<PyObject>(){

        @Override
        public @NonNull PyObject visit(@NonNull BooleanStateValueProxy proxy) {
            return this.accept(proxy, value -> PyUtils.create(value));
        }

        @Override
        public @NonNull PyObject visit(@NonNull AssetStateValueProxy proxy) {
            return this.accept(proxy, value -> PyUtils.create(value));
        }

        @Override
        public @NonNull PyObject visit(@NonNull ConstantAssetStateValueProxy proxy) {
            return this.accept(proxy, value -> PyUtils.create(value));
        }

        @Override
        public @NonNull PyObject visit(@NonNull ConstantStateValueProxy proxy) {
            return this.accept(proxy, value -> PyUtils.create(value));
        }

        @Override
        public @NonNull PyObject visit(@NonNull FloatStateValueProxy proxy) {
            return this.accept(proxy, value -> PyUtils.create(value));
        }

        @Override
        public @NonNull PyObject visit(@NonNull IntegerStateValueProxy proxy) {
            return this.accept(proxy, value -> PyUtils.create(value));
        }

        @Override
        public @NonNull PyObject visit(@NonNull StringStateValueProxy proxy) {
            return this.accept(proxy, value -> PyUtils.create(value));
        }

        @Override
        public @NonNull PyObject visit(@NonNull RGBAStateValueProxy proxy) {
            return this.accept(proxy, value -> PyUtils.create(value));
        }

        @Override
        public @NonNull PyObject visit(IndexedStateValuesProxy indexedStateValuesProxy) {
            PyList list = new PyList();
            for (IStateValueProxy stateItem : indexedStateValuesProxy.getItems()) {
                list.add((Object)stateItem.accept(this));
            }
            return list;
        }

        private <PROXY_TYPE extends AbstractNonIndexedStateValueProxy<?, VALUE_TYPE>, VALUE_TYPE> @NonNull PyObject accept(@NonNull PROXY_TYPE proxy, Function<VALUE_TYPE, @NonNull PyObject> creator) {
            if (proxy.isList()) {
                List<@Nullable VALUE_TYPE> values = proxy.getValues();
                PyList pythonList = new PyList();
                for (VALUE_TYPE value : values) {
                    pythonList.add((Object)creator.apply(value));
                }
                return pythonList;
            }
            return creator.apply(proxy.getValue());
        }
    };
    private @NonNull FunctionCallStatesProxy proxy;

    PyFunctionCallStates(@NonNull FunctionCallStatesProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    protected @NonNull List<@NonNull PyObject> getKeys() {
        List<@NonNull String> names = this.proxy.getStateNames();
        ArrayList<@NonNull PyObject> keys = new ArrayList<PyObject>(names.size());
        for (String name : names) {
            keys.add((PyObject)new PyString(name));
        }
        return keys;
    }

    @Override
    protected int size() {
        return this.proxy.size();
    }

    @Override
    protected @Nullable PyObject getValue(@Nullable PyObject object) {
        IStateValueProxy stateValue;
        String obj = null;
        try {
            obj = (String)Py.tojava((PyObject)object, String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (obj != null && (stateValue = this.proxy.getStateValue(obj)) != null) {
            return stateValue.accept(PYTHON_STATE_ITEM_VISITOR);
        }
        return Py.None;
    }

    @Override
    protected @NonNull List<@NonNull PyObject> getValues() {
        @NonNull List<@NonNull IStateValueProxy> stateValues = this.proxy.getStateValues();
        @NonNull ArrayList<@NonNull PyObject> values = new ArrayList<PyObject>(stateValues.size());
        for (IStateValueProxy stateValue : stateValues) {
            values.add(stateValue.accept(PYTHON_STATE_ITEM_VISITOR));
        }
        return values;
    }

    @Override
    protected @NonNull ProxyObject getProxyObject() {
        return this.proxy;
    }
}

