/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.AbstractArgumentValueProxy;
import com.arm.mgd.core.scripting.FunctionCallProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.python.PyDocs;
import com.arm.mgd.core.scripting.python.PyFunctionCallAssets;
import com.arm.mgd.core.scripting.python.PyFunctionCallStates;
import com.arm.mgd.core.scripting.python.PyProxyObject;
import com.arm.mgd.core.scripting.python.PyUtils;
import com.arm.mgd.core.scripting.python.PythonArgumentVisitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.python.core.PyBoolean;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;

@PyDocs.PyExpose
public class PyFunctionCall
extends PyProxyObject {
    private static final long serialVersionUID = -4046752598946940096L;
    private final @NonNull FunctionCallProxy proxy;

    PyFunctionCall(@NonNull FunctionCallProxy proxy) {
        this.proxy = proxy;
    }

    @PyDocs.PyExpose
    public @NonNull PyString name() {
        return new PyString(this.proxy.getName());
    }

    @PyDocs.PyExpose
    public @NonNull PyInteger index() {
        return new PyInteger(this.proxy.getIndex());
    }

    @PyDocs.PyExpose
    public @NonNull PyFunctionCallAssets assets() {
        return new PyFunctionCallAssets(this.proxy.getAssets());
    }

    @PyDocs.PyExpose
    public @NonNull PyFunctionCallStates states() {
        return new PyFunctionCallStates(this.proxy.getStates());
    }

    @PyDocs.PyExpose
    public @NonNull PyObject parameters() {
        PythonArgumentVisitor pythonArgumentVisitor = new PythonArgumentVisitor();
        return this.proxy.getParameters().accept(pythonArgumentVisitor);
    }

    @PyDocs.PyExpose
    public @NonNull PyObject return_value() {
        PythonArgumentVisitor pythonArgumentVisitor = new PythonArgumentVisitor();
        @Nullable AbstractArgumentValueProxy<?> returnValue = this.proxy.getReturnValue();
        if (returnValue == null) {
            return PyUtils.PyNone;
        }
        return returnValue.accept(pythonArgumentVisitor);
    }

    @PyDocs.PyExpose
    public @NonNull PyLong start_time() {
        return new PyLong(this.proxy.getTimestampStart());
    }

    @PyDocs.PyExpose
    public @NonNull PyLong stop_time() {
        return new PyLong(this.proxy.getTimestampStop());
    }

    @PyDocs.PyExpose
    public @NonNull PyBoolean is_draw_call() {
        return PyUtils.toPyBool(this.proxy.isDrawCall());
    }

    @PyDocs.PyExpose
    public @NonNull PyBoolean is_draw_command() {
        return PyUtils.toPyBool(this.proxy.isDrawCommand());
    }

    @PyDocs.PyExpose
    public @NonNull PyBoolean is_egl_call() {
        return PyUtils.toPyBool(this.proxy.isEGLCall());
    }

    @PyDocs.PyExpose
    public @NonNull PyBoolean is_gles_call() {
        return PyUtils.toPyBool(this.proxy.isGLESCall());
    }

    @PyDocs.PyExpose
    public @NonNull PyBoolean is_cl_call() {
        return PyUtils.toPyBool(this.proxy.isCLCall());
    }

    @PyDocs.PyExpose
    public @NonNull PyBoolean is_vulkan_call() {
        return PyUtils.toPyBool(this.proxy.isVulkanCall());
    }

    @PyDocs.PyExpose
    public PyBoolean has_error() {
        return PyUtils.toPyBool(this.proxy.hasError());
    }

    @PyDocs.PyExpose
    public @Nullable PyString get_note() {
        String note = this.proxy.getNote();
        return note != null ? new PyString(note) : null;
    }

    @PyDocs.PyExpose
    public void set_note(PyString note_string) {
        this.proxy.setNote(note_string != null ? note_string.getString() : null);
    }

    public PyString __repr__() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.proxy.getName()).append(" ").append(this.proxy.getIndex());
        return new PyString(sb.toString());
    }

    @Override
    protected @NonNull ProxyObject getProxyObject() {
        return this.proxy;
    }
}

