/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.python.PyDocs;
import com.arm.mgd.utils.NullUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class PyDocsBuilder {
    private final @NonNull Map<@NonNull Class<?>, PyTypeDocsBuilder> typeBuilders = new HashMap();

    PyDocsBuilder() {
    }

    @NonNull PyTypeDocsBuilder addType(@NonNull Class<?> type, String ... docs) {
        if (!type.isAnnotationPresent(PyDocs.PyExpose.class)) {
            throw new AssertionError((Object)(type + " is not annotated with " + PyDocs.PyExpose.class));
        }
        PyTypeDocsBuilder typeBuilder = new PyTypeDocsBuilder(type, docs);
        this.typeBuilders.put(type, typeBuilder);
        return typeBuilder;
    }

    private static @NonNull List<Class<?>> getAllInheritedClassesSorted(@NonNull Class<?> clazz) {
        @NonNull HashMap<Class<?>, Integer> classMap = new HashMap();
        PyDocsBuilder.getAllInheritedClassesRecursive(classMap, clazz, 0);
        ArrayList classes = new ArrayList(classMap.keySet());
        classes.sort((c1, c2) -> {
            int result = Objects.compare((Integer)NullUtils.neverNull((Object)((Integer)classMap.get(c1))), (Integer)NullUtils.neverNull((Object)((Integer)classMap.get(c2))), Integer::compareTo);
            if (result == 0) {
                int d1 = c1.isInterface() ? 1 : 0;
                int d2 = c2.isInterface() ? 1 : 0;
                result = Integer.compare(d1, d2);
            }
            if (result == 0) {
                result = c1.getName().compareTo(c2.getName());
            }
            return result;
        });
        return classes;
    }

    private static void getAllInheritedClassesRecursive(@NonNull HashMap<Class<?>, Integer> classMap, @Nullable Class<?> clazz, int depth) {
        Integer classDepth;
        if (clazz != null && ((classDepth = classMap.get(clazz)) == null || depth < classDepth)) {
            classMap.put(clazz, depth);
            PyDocsBuilder.getAllInheritedClassesRecursive(classMap, clazz.getSuperclass(), depth + 1);
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceClass = classArray[n2];
                PyDocsBuilder.getAllInheritedClassesRecursive(classMap, interfaceClass, depth + 1);
                ++n2;
            }
        }
    }

    @NonNull Map<@NonNull Class<?>, PyDocs.PyTypeDocs> resolve() {
        HashMap<@NonNull Class<?>, PyDocs.PyTypeDocs> resolvedDocs = new HashMap();
        Comparator<PyDocs.PyMethodDocs> methodSorter = new Comparator<PyDocs.PyMethodDocs>(){

            @Override
            public int compare(PyDocs.PyMethodDocs o1, PyDocs.PyMethodDocs o2) {
                int result = o1.getName().compareTo(o2.getName());
                if (result == 0) {
                    result = Integer.compare(o1.getParameterCount(), o2.getParameterCount());
                }
                return result;
            }
        };
        for (Map.Entry<Class<?>, PyTypeDocsBuilder> entry : this.typeBuilders.entrySet()) {
            Class<?> type = entry.getKey();
            if (Modifier.isAbstract(type.getModifiers()) || type.isInterface()) continue;
            HashMap<@NonNull PyMethod,  @NonNull PyDocs.PyMethodDocs> methodDocsMap = new HashMap<PyMethod, PyDocs.PyMethodDocs>();
            List<Class<?>> inheritedClasses = PyDocsBuilder.getAllInheritedClassesSorted(type);
            for (Class<?> clazz : inheritedClasses) {
                PyTypeDocsBuilder classType = this.typeBuilders.get(clazz);
                if (classType == null) continue;
                for (PyDocs.PyMethodDocs methodDocs : classType.methods) {
                    PyMethod pyMethod = new PyMethod(methodDocs.getName(), methodDocs.getParameterCount());
                    if (methodDocsMap.containsKey(pyMethod)) continue;
                    methodDocsMap.put(pyMethod, methodDocs);
                }
            }
            ArrayList<@NonNull V> methodDocs = new ArrayList(methodDocsMap.values());
            methodDocs.sort(methodSorter);
            resolvedDocs.put(type, new PyDocs.PyTypeDocs(type, NullUtils.unmodifiableList((List)NullUtils.asList((Object[])entry.getValue().docs)), NullUtils.unmodifiableList(methodDocs)));
        }
        return resolvedDocs;
    }

    private static class PyMethod {
        private final @NonNull String name;
        private final int parameterCount;

        private PyMethod(@NonNull String name, int parameterCount) {
            this.name = name;
            this.parameterCount = parameterCount;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PyMethod) {
                PyMethod o2 = (PyMethod)obj;
                return this.name.equals(o2.name) && this.parameterCount == o2.parameterCount;
            }
            return false;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 37 + this.name.hashCode();
            hash = hash * 37 + this.parameterCount;
            return hash;
        }
    }

    static class PyTypeDocsBuilder {
        private final @NonNull Class<?> type;
        private final @NonNull String[] docs;
        private final Method[] typeMethods;
        private final @NonNull List< @NonNull PyDocs.PyMethodDocs> methods = new ArrayList<PyDocs.PyMethodDocs>();

        private PyTypeDocsBuilder(@NonNull Class<?> type, String ... docs) {
            this.type = type;
            this.docs = docs;
            this.typeMethods = type.getMethods();
        }

        @NonNull PyTypeDocsBuilder addMethod(@NonNull String methodName, int numParameters, @NonNull String example, String ... methodDocs) {
            Method foundMethod = null;
            Method[] methodArray = this.typeMethods;
            int n = this.typeMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(methodName) && method.getParameterCount() == numParameters && method.isAnnotationPresent(PyDocs.PyExpose.class)) {
                    if (foundMethod != null) {
                        throw new AssertionError((Object)("Found too many methods matching method " + methodName + "(" + numParameters + ") of " + this.type));
                    }
                    foundMethod = method;
                }
                ++n2;
            }
            if (foundMethod == null) {
                throw new AssertionError((Object)("Unable to find method " + methodName + "(" + numParameters + ") of " + this.type + ". Did you forget to @" + PyDocs.PyExpose.class.getSimpleName() + " it?"));
            }
            if (!Modifier.isPublic(foundMethod.getModifiers())) {
                throw new AssertionError((Object)(foundMethod + " is not public"));
            }
            this.methods.add(new PyDocs.PyMethodDocs(foundMethod, example, NullUtils.unmodifiableList((List)NullUtils.asList((Object[])methodDocs))));
            return this;
        }
    }
}

