/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.python.PyAsset;
import com.arm.mgd.core.scripting.python.PyAssetProperty;
import com.arm.mgd.core.scripting.python.PyAssetPropertyData;
import com.arm.mgd.core.scripting.python.PyAssetPropertyProvider;
import com.arm.mgd.core.scripting.python.PyAssetTable;
import com.arm.mgd.core.scripting.python.PyDocsBuilder;
import com.arm.mgd.core.scripting.python.PyFrame;
import com.arm.mgd.core.scripting.python.PyFunctionCall;
import com.arm.mgd.core.scripting.python.PyFunctionCallAssets;
import com.arm.mgd.core.scripting.python.PyFunctionCallStates;
import com.arm.mgd.core.scripting.python.PyHelp;
import com.arm.mgd.core.scripting.python.PyImmutableDict;
import com.arm.mgd.core.scripting.python.PyMonitor;
import com.arm.mgd.core.scripting.python.PyNamedArguments;
import com.arm.mgd.core.scripting.python.PyProcess;
import com.arm.mgd.core.scripting.python.PyProxyObject;
import com.arm.mgd.core.scripting.python.PyRenderPass;
import com.arm.mgd.core.scripting.python.PyTrace;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PyDocs {
    private final @NonNull Map<@NonNull Class<?>, PyTypeDocs> typeDocs;
    private final @NonNull List<@NonNull Class<?>> typesSorted;

    public PyDocs() {
        PyDocsBuilder db = new PyDocsBuilder();
        db.addType(PyHelp.class, "Help for the " + VersionProperties.FULL_PRODUCT_NAME + " scripting console.").addMethod("__call__", 0, "help.__call__() <==> help()", "Display information about the " + VersionProperties.FULL_PRODUCT_NAME + " scripting system.").addMethod("__call__", 1, "help.__call__(object) <==> help(object)", "Display help about object.");
        db.addType(PyProxyObject.class, "").addMethod("__eq__", 1, "x.__eq__(y) <==> x==y", "x==y if x and y represent the same data and were obtained from parent objects which are also equal, e.g. equal processes, function calls, assets, etc.", "If x==y, any method called on x will return an equal value to if the method were called on y.");
        db.addType(PyImmutableDict.class, "").addMethod("__getitem__", 1, "d.__getitem__(key) <==> d[key]", "Return the item of d with key y. Raises a KeyError if key is not in the map.").addMethod("__contains__", 1, "d.__contains__(key) <==> key in d", "Return true if key in d, else false.").addMethod("__iter__", 0, "d.__iter__() <==> iter(d)", "Return an iterator over the keys of the dictionary.", "Ordering is guaranteed to be consistent across subsequent calls, and be consistent with all other iterators and methods which traverse d's elements.").addMethod("__len__", 0, "d.__len__() <==> len(d)", "Return the number of key-value pairs in the dictionary.").addMethod("__nonzero__", 0, "d.__nonzero__() <==> bool(d)", "Return true if len(d) is nonzero. False otherwise.").addMethod("copy", 0, "d.copy() -> dict", "Return a new mutable dictionary with all the key-value pairs shallow-copied from d.", "The ordering of the key-value pairs in the returned dictionary is not guaranteed to be consistent with the ordering of d.").addMethod("get", 2, "d.get(key, default) -> d[key] if key in d, else default.", new String[0]).addMethod("get", 1, "d.get(key) -> d[key] if key in d, else None.", new String[0]).addMethod("has_key", 1, "d.has_key(key) -> bool", "Return true if key in d, else false.").addMethod("items", 0, "d.items() -> list of d's (key, value) pairs, as 2-tuples", "Ordering is guaranteed to be consistent across subsequent calls, and be consistent with all other iterators and methods which traverse d's elements.").addMethod("iteritems", 0, "d.iteritems() -> iterator over the key value pairs of d", "Ordering is guaranteed to be consistent across subsequent calls, and be consistent with all other iterators and methods which traverse d's elements.").addMethod("iterkeys", 0, "d.iterkeys() -> iterator over the keys of d", "Ordering is guaranteed to be consistent across subsequent calls, and be consistent with all other iterators and methods which traverse d's elements.").addMethod("itervalues", 0, "d.itervalues() -> iterator over the values of d", "Ordering is guaranteed to be consistent across subsequent calls, and be consistent with all other iterators and methods which traverse d's elements.").addMethod("keys", 0, "d.keys() -> list of d's keys", "Ordering is guaranteed to be consistent across subsequent calls, and be consistent with all other iterators and methods which traverse d's elements.").addMethod("values", 0, "d.values() -> list of d's values", "Ordering is guaranteed to be consistent across subsequent calls, and be consistent with all other iterators and methods which traverse d's elements.");
        db.addType(PyTrace.class, String.valueOf(VersionProperties.FULL_PRODUCT_NAME) + " Trace object.").addMethod("processes", 0, "t.processes() -> list of " + PyDocs.getClassName(PyProcess.class), "Return a copy of the list of processes in the trace.").addMethod("name", 0, "t.name() -> string", "Return the name of the trace.");
        db.addType(PyProcess.class, "Process in a trace.").addMethod("function_calls", 0, "p.function_calls() -> list of " + PyDocs.getClassName(PyFunctionCall.class), "Return a copy of the list of function calls in p.").addMethod("egl_and_gles_function_calls", 0, "p.egl_and_gles_function_calls() -> list of " + PyDocs.getClassName(PyFunctionCall.class), "Return a copy of the list of EGL and GLES function calls in p.").addMethod("cl_function_calls", 0, "p.cl_function_calls() -> list of " + PyDocs.getClassName(PyFunctionCall.class), "Return a copy of the list of CL function calls in p.").addMethod("vulkan_function_calls", 0, "p.vulkan_function_calls() -> list of " + PyDocs.getClassName(PyFunctionCall.class), "Return a copy of the list of Vulkan function calls in p.").addMethod("name", 0, "p.name() -> string", "Return the name of the process.").addMethod("frames", 0, "p.frames() -> list of " + PyDocs.getClassName(PyFrame.class), "Return a copy of the list of frames in p.");
        db.addType(PyFrame.class, "Frame in a process.").addMethod("function_calls", 0, "f.function_calls() -> list of " + PyDocs.getClassName(PyFunctionCall.class), "Return a copy of the list of function calls in f.").addMethod("render_passes", 0, "f.render_passes() -> list of " + PyDocs.getClassName(PyRenderPass.class), "Return a copy of the list of render passes in f.").addMethod("was_modified", 0, "f.was_modified() -> bool", "Return True if any features (e.g. Frame Capture, Overdraw, etc.) were enabled for this frame. False otherwise.").addMethod("index", 0, "f.index() -> integer", "Return the index of the Frame in the process.");
        db.addType(PyRenderPass.class, "Render Pass in a frame.").addMethod("function_calls", 0, "rp.function_calls() -> list of " + PyDocs.getClassName(PyFunctionCall.class), "Return a copy of the list of function calls in rp.");
        db.addType(PyFunctionCall.class, "Function Call.").addMethod("name", 0, "fc.name() -> string", "Return the name of the function call.").addMethod("index", 0, "fc.index() -> integer", "Return the index of the function call in the process.").addMethod("assets", 0, "fc.assets() -> " + PyDocs.getClassName(PyFunctionCallAssets.class), "Return a " + PyDocs.getClassName(PyFunctionCallAssets.class) + " object, containing all the assets alive at the function call.").addMethod("states", 0, "fc.states() -> " + PyDocs.getClassName(PyFunctionCallStates.class), "Return a " + PyDocs.getClassName(PyFunctionCallStates.class) + " object, containing the per-context state at the function call.").addMethod("parameters", 0, "fc.parameters() -> Dictionary mapping from parameter name to parameter value", "Return a dictionary mapping from the name of the function call parameter to an object representing the parameter value.", "The object representing the value depends on the type of the parameter.").addMethod("start_time", 0, "fc.start_time() -> long", "Return the number of microseconds after the epoch when the function call was started.").addMethod("stop_time", 0, "fc.stop_time() -> long", "Return the number of microseconds after the epoch when the function call completed.").addMethod("return_value", 0, "fc.return_value() -> object", "Return an object representing the return value of the function call.", "The object representing the return value depends on the type of the parameter.").addMethod("is_draw_call", 0, "fc.is_draw_call() -> bool", "Return True if fc is an OpenGL ES draw call. False otherwise.").addMethod("is_draw_command", 0, "fc.is_draw_command() -> bool", "Return True if fc is a Vulkan draw command. False otherwise.").addMethod("is_egl_call", 0, "fc.is_egl_call() -> bool", "Return True if fc is an EGL function call. False otherwise.").addMethod("is_gles_call", 0, "fc.is_gles_call() -> bool", "Return True if fc is a GLES function call. False otherwise.").addMethod("is_cl_call", 0, "fc.is_cl_call() -> bool", "Return True if fc is a CL function call. False otherwise.").addMethod("is_vulkan_call", 0, "fc.is_vulkan_call() -> bool", "Return True if fc is a Vulkan function call. False otherwise.").addMethod("has_error", 0, "fc.has_error() -> bool", "Return True if fc caused an API error. False otherwise.").addMethod("get_note", 0, "fc.get_note() -> string or None", "Return the note attached to fc it there is one, else None.").addMethod("set_note", 1, "fc.set_note(note_string)", "If note_string is None, removes the note from fc. Otherwise, sets fc's note to note_string.");
        db.addType(PyFunctionCallAssets.class, "Immutable dictionary mapping from asset type names to the " + PyDocs.getClassName(PyAssetTable.class) + " object containing all the assets of a certain type at a specific function call.");
        db.addType(PyFunctionCallStates.class, "Immutable dictionary mapping from per-context state names to the state value.");
        db.addType(PyNamedArguments.class, "Immutable dictionary mapping from parameter names to the parameter arguments.");
        db.addType(PyAssetTable.class, "Immutable dictionary mapping from asset handles to the " + PyDocs.getClassName(PyAsset.class) + " object representing the state of an asset at a specific function call.");
        db.addType(PyAssetPropertyData.class, "").addMethod("has_buffer_data", 0, "p.has_buffer_data() -> bool", "Return True if p has buffer data. False otherwise.", "Equivalent to, but faster than, calling buffer_data() != None.").addMethod("buffer_data", 0, "p.buffer_data() -> bytearray or None", "Return a copy of the buffer data that p has if it has any, else None.").addMethod("has_text_data", 0, "p.has_text_data() -> bool", "Return True if p has text data. False otherwise.", "Equivalent to, but faster than, calling text_data() != None.").addMethod("text_data", 0, "p.text_data() -> string or None", "Return the text data that p has if it has any, else None.");
        db.addType(PyAssetProperty.class, "The value of an asset property.", "Can have buffer or text data.").addMethod("__nonzero__", 0, "p.__nonzero__() <==> bool(d)", "Return False if p represents some kind of negative value, such as \"NULL\", \"None\", \"False\", or \"Zero\". True otherwise.");
        db.addType(PyAssetPropertyProvider.class, "Immutable dictionary mapping from asset property names to either a " + PyDocs.getClassName(PyAssetProperty.class) + ", a " + PyDocs.getClassName(PyAssetPropertyProvider.class) + ", or a " + PyDocs.getClassName(PyAsset.class) + ".", "Can have buffer or text data.");
        db.addType(PyAsset.class, "Immutable dictionary mapping from asset property names to either a " + PyDocs.getClassName(PyAssetProperty.class) + ", a " + PyDocs.getClassName(PyAssetPropertyProvider.class) + ", or a " + PyDocs.getClassName(PyAsset.class) + ".", "Can have buffer or text data.");
        db.addType(PyMonitor.class, "Monitor connected to the progress bar in the GUI.").addMethod("finish", 0, "m.finish()", "Notify the monitor that a task is finished.").addMethod("set_task", 2, "m.set_task(task_name, total_work)", "Setup a task with task_name with total_work amount of work.", "To create a task with an unknown amount of work set total_work < 0.").addMethod("increment_progress", 1, "m.increment_progress(progress_amount)", "Increment the progress of the current task by progress_amount.");
        this.typeDocs = db.resolve();
        ArrayList<@NonNull Class<?>> names = new ArrayList(this.typeDocs.keySet());
        names.sort((c1, c2) -> PyDocs.getClassName(c1).compareTo(PyDocs.getClassName(c2)));
        this.typesSorted = NullUtils.unmodifiableList(names);
    }

    public @Nullable PyTypeDocs getTypeDocs(@NonNull Class<?> type) {
        return this.typeDocs.get(type);
    }

    public @NonNull List<@NonNull Class<?>> getDocumentedTypes() {
        return this.typesSorted;
    }

    private static @NonNull String getClassName(@NonNull Class<?> clazz) {
        if (!clazz.isAnnotationPresent(PyExpose.class)) {
            throw new AssertionError((Object)(clazz + " has not been annotated with PyDoc"));
        }
        return (String)NullUtils.neverNull((Object)clazz.getSimpleName());
    }

    @Inherited
    @Documented
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PyExpose {
    }

    public static class PyMethodDocs {
        private final @NonNull Method method;
        private final @NonNull String example;
        private final @NonNull List<@NonNull String> docs;

        PyMethodDocs(@NonNull Method method, @NonNull String example, @NonNull List<@NonNull String> docs) {
            this.method = method;
            this.example = example;
            this.docs = docs;
        }

        public @NonNull String getName() {
            return (String)NullUtils.neverNull((Object)this.method.getName());
        }

        public int getParameterCount() {
            return this.method.getParameterCount();
        }

        public @NonNull String getExample() {
            return this.example;
        }

        public @NonNull List<@NonNull String> getDocs() {
            return this.docs;
        }
    }

    public static class PyTypeDocs {
        private final @NonNull Class<?> type;
        private final @NonNull List<@NonNull String> docs;
        private final @NonNull List<@NonNull PyMethodDocs> methodDocs;

        PyTypeDocs(@NonNull Class<?> type, @NonNull List<@NonNull String> docs, @NonNull List<@NonNull PyMethodDocs> methodDocs) {
            this.type = type;
            this.docs = docs;
            this.methodDocs = methodDocs;
        }

        public @NonNull String getName() {
            return (String)NullUtils.neverNull((Object)this.type.getSimpleName());
        }

        public @NonNull List<@NonNull String> getDocs() {
            return this.docs;
        }

        public @NonNull List<@NonNull PyMethodDocs> getMethodDocs() {
            return this.methodDocs;
        }
    }
}

