/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.AssetProxy;
import com.arm.mgd.core.scripting.AssetTableProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.python.PyAsset;
import com.arm.mgd.core.scripting.python.PyDocs;
import com.arm.mgd.core.scripting.python.PyImmutableDict;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.python.core.Py;
import org.python.core.PyLong;
import org.python.core.PyObject;

@PyDocs.PyExpose
public class PyAssetTable
extends PyImmutableDict {
    private static final long serialVersionUID = -1492795234623866337L;
    private final @NonNull AssetTableProxy proxy;

    PyAssetTable(@NonNull AssetTableProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    protected @Nullable PyObject getValue(@Nullable PyObject object) {
        AssetProxy asset;
        Long obj = null;
        try {
            obj = (Long)Py.tojava((PyObject)object, Long.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (obj != null && (asset = this.proxy.getAsset(obj)) != null) {
            return new PyAsset(asset);
        }
        return null;
    }

    @Override
    protected @NonNull List<@NonNull PyObject> getKeys() {
        List<@NonNull Long> handles = this.proxy.getAssetHandles();
        ArrayList<@NonNull PyObject> keys = new ArrayList<PyObject>(handles.size());
        for (Long handle : handles) {
            keys.add((PyObject)new PyLong(handle.longValue()));
        }
        return keys;
    }

    @Override
    protected int size() {
        return this.proxy.size();
    }

    @Override
    protected @NonNull List<@NonNull PyObject> getValues() {
        @NonNull List<@NonNull AssetProxy> assets = this.proxy.getAssets();
        @NonNull ArrayList<@NonNull PyObject> values = new ArrayList<PyObject>(assets.size());
        for (AssetProxy asset : assets) {
            values.add(new PyAsset(asset));
        }
        return values;
    }

    @Override
    protected @NonNull ProxyObject getProxyObject() {
        return this.proxy;
    }
}

