/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.AbstractAssetPropertyProviderProxy;
import com.arm.mgd.core.scripting.AbstractAssetPropertyProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.python.PyAssetProperty;
import com.arm.mgd.core.scripting.python.PyAssetPropertyData;
import com.arm.mgd.core.scripting.python.PyDocs;
import com.arm.mgd.core.scripting.python.PyImmutableDict;
import com.arm.mgd.core.scripting.python.PyUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyByteArray;
import org.python.core.PyObject;
import org.python.core.PyString;

@PyDocs.PyExpose
public class PyAssetPropertyProvider
extends PyImmutableDict
implements PyAssetPropertyData {
    private static final long serialVersionUID = 5195949020189909812L;
    private final @NonNull AbstractAssetPropertyProviderProxy proxy;

    PyAssetPropertyProvider(@NonNull AbstractAssetPropertyProviderProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    protected @Nullable PyObject getValue(@Nullable PyObject object) {
        AbstractAssetPropertyProxy property;
        String obj = null;
        try {
            obj = (String)Py.tojava((PyObject)object, String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (obj != null && (property = this.proxy.getProperty(obj)) != null) {
            return PyAssetProperty.create(property);
        }
        return null;
    }

    @Override
    protected @NonNull List<@NonNull PyObject> getKeys() {
        List<@NonNull String> names = this.proxy.getPropertyNames();
        ArrayList<@NonNull PyObject> keys = new ArrayList<PyObject>(names.size());
        for (String name : names) {
            keys.add((PyObject)new PyString(name));
        }
        return keys;
    }

    @Override
    protected int size() {
        return this.proxy.size();
    }

    @Override
    protected @NonNull List<@NonNull PyObject> getValues() {
        @NonNull List<@NonNull AbstractAssetPropertyProxy> properties = this.proxy.getProperties();
        @NonNull ArrayList<@NonNull PyObject> values = new ArrayList<PyObject>(properties.size());
        for (AbstractAssetPropertyProxy property : properties) {
            values.add(PyAssetProperty.create(property));
        }
        return values;
    }

    @Override
    public @NonNull PyBoolean has_buffer_data() {
        return PyUtils.toPyBool(this.proxy.hasBufferData());
    }

    @Override
    public @Nullable PyByteArray buffer_data() {
        byte @Nullable [] bufferData = this.proxy.getBufferData();
        return bufferData != null ? new PyByteArray(bufferData) : null;
    }

    @Override
    public @NonNull PyBoolean has_text_data() {
        return PyUtils.toPyBool(this.proxy.hasTextData());
    }

    @Override
    public @Nullable PyString text_data() {
        @Nullable String textData = this.proxy.getTextData();
        return textData != null ? new PyString(textData) : null;
    }

    @Override
    public PyString __str__() {
        return new PyString(this.proxy.getValue());
    }

    @Override
    protected @NonNull ProxyObject getProxyObject() {
        return this.proxy;
    }
}

