/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.TraceProxy;
import com.arm.mgd.core.scripting.python.PyHelp;
import com.arm.mgd.core.scripting.python.PyMonitor;
import com.arm.mgd.core.scripting.python.PyRawInputFunction;
import com.arm.mgd.core.scripting.python.PyTrace;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.utils.NullUtils;
import java.io.Writer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.ThreadState;
import org.python.modules.thread.thread;
import org.python.util.InteractiveInterpreter;

public class InterpreterDaemon
implements Runnable {
    private final @NonNull Lock lock = new ReentrantLock();
    private final @NonNull Condition sourceAvailable = (Condition)NullUtils.neverNull((Object)this.lock.newCondition());
    private @Nullable String source = null;
    private boolean interpreterThreadEnd = false;
    private @NonNull CompletableFuture<@NonNull Boolean> moreFuture = new CompletableFuture();
    private @NonNull CompletableFuture<Boolean> stopFuture = new CompletableFuture();
    private ThreadState threadState;
    private final @NonNull InteractiveInterpreter interpreter;
    private final @NonNull PyStringMap namespaceBackup;
    private final @NonNull PyStringMap namespace;

    public InterpreterDaemon(@NonNull Writer outputWriter, @NonNull Writer errorWriter, @NonNull ICoreProgressMonitor monitor, @Nullable UserInputFunction inputFunction) {
        PySystemState sysState = new PySystemState();
        sysState.path.add((Object)new PyString("__pyclasspath__/Lib/"));
        this.namespace = (PyStringMap)NullUtils.neverNull((Object)Py.newStringMap());
        this.interpreter = new InteractiveInterpreter((PyObject)this.namespace, sysState);
        PyStringMap builtins = (PyStringMap)sysState.getBuiltins();
        PyStringMap builtinsCopy = builtins.copy();
        sysState.setBuiltins((PyObject)builtinsCopy);
        PyBuiltinFunction rawInputReplacement = inputFunction != null ? new PyRawInputFunction(inputFunction) : new NotSupportedBuiltinFunction("raw_input", 0, 1, "Not supported.");
        builtinsCopy.__setitem__("raw_input", (PyObject)rawInputReplacement);
        builtinsCopy.__setitem__("input", (PyObject)new NotSupportedBuiltinFunction("input", 0, 1, "Not supported."));
        this.interpreter.setOut(outputWriter);
        this.interpreter.setErr(errorWriter);
        PyHelp.replaceBuiltInHelp(outputWriter, sysState);
        this.interpreter.set("monitor", (PyObject)new PyMonitor(monitor));
        this.namespaceBackup = (PyStringMap)NullUtils.neverNull((Object)this.namespace.copy());
    }

    @Override
    public void run() {
        this.threadState = Py.getThreadState();
        while (true) {
            this.lock.lock();
            while (this.source == null && !this.interpreterThreadEnd) {
                this.sourceAvailable.await();
            }
            if (this.interpreterThreadEnd) {
                this.interpreter.close();
                this.namespace.clear();
                this.moreFuture.completeExceptionally(new Throwable("Interpreter stopped."));
                this.stopFuture.complete(true);
                return;
            }
            try {
                boolean moreInputRequired = this.interpreter.runsource(this.source);
                this.moreFuture.complete(NullUtils.booleanValueOf((boolean)moreInputRequired));
            }
            catch (Error error) {
                this.moreFuture.completeExceptionally(error);
                if (this.threadState == null || this.threadState.frame == null) continue;
                this.threadState.frame.tracefunc = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.moreFuture.completeExceptionally(e);
            }
            catch (Exception e) {
                this.moreFuture.completeExceptionally(e);
            }
            continue;
            break;
        }
        finally {
            this.source = null;
            this.lock.unlock();
        }
    }

    public void setTarget(@NonNull AbstractTarget target) {
        @NonNull PyTrace pyTrace = new PyTrace(new TraceProxy(target));
        this.interpreter.set("trace", (PyObject)pyTrace);
        this.namespaceBackup.__setitem__("trace", (PyObject)pyTrace);
    }

    public @NonNull CompletableFuture<@NonNull Boolean> runSource(@NonNull String newSource) {
        this.lock.lock();
        try {
            this.moreFuture = new CompletableFuture();
            this.source = newSource;
            this.sourceAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        return this.moreFuture;
    }

    public CompletableFuture<Boolean> stop() {
        this.lock.lock();
        try {
            this.interpreterThreadEnd = true;
            this.sourceAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        return this.stopFuture;
    }

    public void interrupt() {
        if (this.threadState != null) {
            this.interpreter.interrupt(this.threadState);
            thread.interruptAllThreads();
        }
    }

    public void reset() {
        if (this.threadState != null) {
            this.interpreter.setLocals((PyObject)this.namespaceBackup.copy());
        }
    }

    private static class NotSupportedBuiltinFunction
    extends PyBuiltinFunction {
        private static final long serialVersionUID = -5830474212902025085L;

        public NotSupportedBuiltinFunction(@NonNull String name, int minargs, int maxargs, String doc) {
            super(name, minargs, maxargs, doc);
        }

        public PyObject __call__() {
            return Py.newString((String)(String.valueOf(this.info.getName()) + " not supported."));
        }

        public PyObject __call__(PyObject prompt) {
            return Py.newString((String)(String.valueOf(this.info.getName()) + " not supported."));
        }
    }

    public static class UserInputFunction {
        private final @NonNull String docs;
        private final @NonNull Function<@Nullable String, @NonNull String> inputGetter;

        public UserInputFunction(@NonNull String docs, @NonNull Function<@Nullable String, @NonNull String> inputGetter) {
            this.docs = docs;
            this.inputGetter = inputGetter;
        }

        @NonNull String getDocs() {
            return this.docs;
        }

        @NonNull Function<@Nullable String, @NonNull String> getFunction() {
            return this.inputGetter;
        }
    }
}

