/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.scripting.AbstractArgumentValueProxy;
import com.arm.mgd.core.scripting.ArgumentHierarchyProxyUtils;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.FunctionCall;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

class UnknownValueVisitor
implements ArgumentHierarchyNode.IArgumentHierarchyVisitor {
    private final int depthToRecord;
    private final @NonNull FunctionCall functionCall;
    private List<@NonNull AbstractArgumentValueProxy<?>> values = new ArrayList();
    int currentBranchDepth = 0;

    UnknownValueVisitor(@NonNull FunctionCall functionCall, int depthToRecord) {
        this.depthToRecord = depthToRecord;
        this.functionCall = functionCall;
    }

    @Override
    public void visit(@NonNull ArgumentHierarchyLeaf leaf) {
        if (this.currentBranchDepth == this.depthToRecord) {
            this.values.add(ArgumentHierarchyProxyUtils.createLeafNodeProxy(leaf));
        }
    }

    @Override
    public void visitBranch(@NonNull ArgumentHierarchyBranch branch) {
        if (this.currentBranchDepth == this.depthToRecord) {
            this.values.add(ArgumentHierarchyProxyUtils.createBranchNodeProxy(this.functionCall, branch));
        }
        ++this.currentBranchDepth;
    }

    @Override
    public void leaveBranch(@NonNull ArgumentHierarchyBranch branch) {
        --this.currentBranchDepth;
    }

    @Override
    public void betweenBranchChildren(@NonNull ArgumentHierarchyBranch branch) {
    }

    public @NonNull List<@NonNull AbstractArgumentValueProxy<?>> getValues() {
        return new ArrayList(this.values);
    }

    public void reset() {
        this.values.clear();
    }
}

