/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

final class ScriptingSnapshotManager {
    private static final Map<@NonNull AbstractTarget, List<TraceStateSnapshot>> targetSnapshotMap = new HashMap<AbstractTarget, List<TraceStateSnapshot>>();
    private static final @NonNull ThreadLocal<@NonNull SnapshotStorage> threadLocalSnapshotStorage = new ThreadLocal<SnapshotStorage>(){

        @Override
        protected @NonNull SnapshotStorage initialValue() {
            return new SnapshotStorage();
        }
    };

    static {
        CoreInstance.getNavigationManager().addTargetRemovedListener(target -> ScriptingSnapshotManager.removeTargetSnapshotsFromGlobalCache(target));
    }

    ScriptingSnapshotManager() {
    }

    static @NonNull TraceStateSnapshot getTraceStateSnapshotAt(@NonNull FunctionCall functionCall) {
        SynchronousTraceStateSnapshot snapshot;
        @NonNull SnapshotStorage snapshotStorage = threadLocalSnapshotStorage.get();
        @NonNull TraceDataModel model = functionCall.getModel();
        @Nullable SynchronousTraceStateSnapshot lastUsedSnapshot = (SynchronousTraceStateSnapshot)snapshotStorage.lastUsedSnapshot.get();
        if (lastUsedSnapshot != null && lastUsedSnapshot.getModel().equals(model)) {
            lastUsedSnapshot.setSelectedFunction(functionCall.getIndex());
            return lastUsedSnapshot;
        }
        @Nullable WeakReference<@Nullable SynchronousTraceStateSnapshot> weakSnapshot = snapshotStorage.modelSnapshotMap.get(model);
        SynchronousTraceStateSnapshot synchronousTraceStateSnapshot = snapshot = weakSnapshot != null ? (SynchronousTraceStateSnapshot)weakSnapshot.get() : null;
        if (snapshot == null) {
            snapshot = new SynchronousTraceStateSnapshot(model);
            snapshotStorage.modelSnapshotMap.put(model, new WeakReference<SynchronousTraceStateSnapshot>(snapshot));
            ScriptingSnapshotManager.addSnapshotToGlobalCache(snapshot);
        }
        snapshotStorage.lastUsedSnapshot = new WeakReference<SynchronousTraceStateSnapshot>(snapshot);
        snapshot.setSelectedFunction(functionCall.getIndex());
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSnapshotToGlobalCache(@NonNull TraceStateSnapshot snapshot) {
        Map<AbstractTarget, List<TraceStateSnapshot>> map = targetSnapshotMap;
        synchronized (map) {
            @NonNull AbstractTarget target = snapshot.getModel().getParentProcessTarget().getParentTarget();
            List<TraceStateSnapshot> targetSnapshotsList = targetSnapshotMap.get(target);
            if (targetSnapshotsList == null) {
                targetSnapshotsList = new ArrayList<TraceStateSnapshot>();
                targetSnapshotMap.put(target, targetSnapshotsList);
            }
            targetSnapshotsList.add(snapshot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTargetSnapshotsFromGlobalCache(@NonNull AbstractTarget target) {
        Map<AbstractTarget, List<TraceStateSnapshot>> map = targetSnapshotMap;
        synchronized (map) {
            targetSnapshotMap.remove(target);
        }
    }

    private static class SnapshotStorage {
        private @NonNull WeakReference<@Nullable SynchronousTraceStateSnapshot> lastUsedSnapshot = NullUtils.emptyWeakReference();
        private final @NonNull WeakHashMap<@NonNull TraceDataModel, WeakReference<@Nullable SynchronousTraceStateSnapshot>> modelSnapshotMap = new WeakHashMap();

        private SnapshotStorage() {
        }
    }
}

