/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.scripting.AbstractNonIndexedStateValueProxy;
import com.arm.mgd.core.scripting.IStateValueProxy;
import com.arm.mgd.lightweight.state.value.RGBAStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RGBAStateValueProxy
extends AbstractNonIndexedStateValueProxy<RGBAStateItemValue, List<Float>> {
    public RGBAStateValueProxy(@NonNull RGBAStateItemValue stateItem) {
        super(stateItem);
    }

    public <T> @NonNull T accept(@NonNull IStateValueProxy.IStateValueProxyVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public @Nullable List<@NonNull Float> getValue() {
        return RGBAStateValueProxy.create((RGBAStateItemValue.RGBA)((RGBAStateItemValue)this.stateItem).getValue());
    }

    @Override
    public @NonNull List<@Nullable List<@NonNull Float>> getValues() {
        List<@Nullable T> values = ((RGBAStateItemValue)this.stateItem).getValues();
        if (values.isEmpty()) {
            return NullUtils.EMPTY_LIST;
        }
        ArrayList<@Nullable List<@NonNull Float>> rgbas = new ArrayList<List<Float>>(values.size());
        for (RGBAStateItemValue.RGBA rgba : values) {
            rgbas.add(RGBAStateValueProxy.create(rgba));
        }
        return rgbas;
    }

    private static @Nullable List<@NonNull Float> create(@Nullable RGBAStateItemValue.RGBA value) {
        if (value == null) {
            return null;
        }
        ArrayList<@NonNull Float> colourValues = new ArrayList<Float>(4);
        colourValues.add(NullUtils.floatValueOf((float)value.r));
        colourValues.add(NullUtils.floatValueOf((float)value.g));
        colourValues.add(NullUtils.floatValueOf((float)value.b));
        colourValues.add(NullUtils.floatValueOf((float)value.a));
        return colourValues;
    }
}

