/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.scripting.FrameProxy;
import com.arm.mgd.core.scripting.FunctionCallProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.io.ProcessTarget;
import com.arm.mgd.core.util.LazyObjectGenerator;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessProxy
implements ProxyObject {
    private final @NonNull LazyObjectGenerator<List<@NonNull FrameProxy>> frames;
    private final @NonNull LazyObjectGenerator<List<@NonNull FunctionCallProxy>> functionCalls;
    private final @NonNull ProcessTarget process;

    public ProcessProxy(final @NonNull ProcessTarget process) {
        this.process = process;
        this.frames = new LazyObjectGenerator<List<FrameProxy>>(){

            @Override
            protected @NonNull List<@NonNull FrameProxy> generateObject() {
                if (process.getModel().containsOnlyCL()) {
                    return NullUtils.EMPTY_LIST;
                }
                List<@NonNull Frame> retrievedFrames = process.getModel().getFrames().getFrames();
                ArrayList<@NonNull FrameProxy> frameProxies = new ArrayList<FrameProxy>(retrievedFrames.size());
                for (Frame frame : retrievedFrames) {
                    frameProxies.add(new FrameProxy(frame, ProcessProxy.this));
                }
                return NullUtils.unmodifiableList(frameProxies);
            }
        };
        this.functionCalls = new LazyObjectGenerator<List<FunctionCallProxy>>(){

            @Override
            protected @NonNull List<@NonNull FunctionCallProxy> generateObject() {
                ArrayList<@NonNull FunctionCallProxy> functionCallProxies = new ArrayList<FunctionCallProxy>(process.getFunctionCallCount());
                int i = 0;
                while (i < process.getFunctionCallCount()) {
                    functionCallProxies.add(new FunctionCallProxy(process.getCallItem(i)));
                    ++i;
                }
                return NullUtils.unmodifiableList(functionCallProxies);
            }
        };
    }

    public @NonNull String getName() {
        return this.process.getModel().getProcessName();
    }

    public @NonNull List<@NonNull FrameProxy> getFrames() {
        return this.frames.get();
    }

    public @NonNull List<@NonNull FunctionCallProxy> getFunctionCalls() {
        return this.functionCalls.get();
    }

    @Override
    public boolean proxyEquals(@Nullable ProxyObject other) {
        if (other instanceof ProcessProxy) {
            return this.process.equals(((ProcessProxy)other).process);
        }
        return false;
    }
}

