/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.scripting.AbstractArgumentValueProxy;
import com.arm.mgd.core.scripting.ArgumentHierarchyProxyUtils;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.FunctionCall;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NamedArgumentValuesProxy
extends AbstractArgumentValueProxy<ArgumentHierarchyBranch>
implements ProxyObject {
    private final @NonNull FunctionCall functionCall;
    private final @NonNull NameValueVisitor namedArgumentValueProxyVisitor = new NameValueVisitor();

    NamedArgumentValuesProxy(@NonNull FunctionCall functionCall, @NonNull ArgumentHierarchyBranch argumentHierarchy) {
        super(argumentHierarchy);
        this.functionCall = functionCall;
    }

    @Override
    public boolean proxyEquals(@Nullable ProxyObject other) {
        if (other instanceof NamedArgumentValuesProxy) {
            return this.functionCall.equals(((NamedArgumentValuesProxy)other).functionCall);
        }
        return false;
    }

    public @NonNull List<@NonNull String> getNames() {
        @NonNull List<@NonNull ArgumentHierarchyNode> argumentHierarchyChildren = ((ArgumentHierarchyBranch)this.argumentHierarchy).getChildren();
        @NonNull ArrayList<@NonNull String> parameterNames = new ArrayList<String>();
        for (ArgumentHierarchyNode argument : argumentHierarchyChildren) {
            @Nullable String name = argument.getName();
            assert (name != null) : "Supposedly named argument has no name.";
            parameterNames.add(name);
        }
        return parameterNames;
    }

    public int size() {
        return ((ArgumentHierarchyBranch)this.argumentHierarchy).getChildren().size();
    }

    public @Nullable AbstractArgumentValueProxy<?> getArgumentValue(String name) {
        this.namedArgumentValueProxyVisitor.reset();
        ((ArgumentHierarchyBranch)this.argumentHierarchy).accept(this.namedArgumentValueProxyVisitor);
        return this.namedArgumentValueProxyVisitor.getValue(name);
    }

    public @NonNull List<@NonNull AbstractArgumentValueProxy<?>> getArgumentValues() {
        this.namedArgumentValueProxyVisitor.reset();
        ((ArgumentHierarchyBranch)this.argumentHierarchy).accept(this.namedArgumentValueProxyVisitor);
        return this.namedArgumentValueProxyVisitor.getValues();
    }

    @Override
    public <T> @NonNull T accept(@NonNull AbstractArgumentValueProxy.IArgumentValueProxyVisitor<T> visitor) {
        return visitor.visit(this);
    }

    private final class NameValueVisitor
    implements ArgumentHierarchyNode.IArgumentHierarchyVisitor {
        private Map<@NonNull String, @NonNull AbstractArgumentValueProxy<?>> namedValues = new HashMap();
        int currentBranchDepth = 0;

        private NameValueVisitor() {
        }

        @Override
        public void visit(@NonNull ArgumentHierarchyLeaf leaf) {
            if (this.currentBranchDepth == 1) {
                @Nullable String name = leaf.getName();
                assert (name != null) : "Supposedly named argument has no name.";
                this.namedValues.put(name, ArgumentHierarchyProxyUtils.createLeafNodeProxy(leaf));
            }
        }

        @Override
        public void visitBranch(@NonNull ArgumentHierarchyBranch branch) {
            if (this.currentBranchDepth == 1) {
                @Nullable String name = branch.getName();
                assert (name != null) : "Supposedly named argument has no name.";
                this.namedValues.put(name, ArgumentHierarchyProxyUtils.createBranchNodeProxy(NamedArgumentValuesProxy.this.functionCall, branch));
            }
            ++this.currentBranchDepth;
        }

        @Override
        public void leaveBranch(@NonNull ArgumentHierarchyBranch branch) {
            --this.currentBranchDepth;
        }

        @Override
        public void betweenBranchChildren(@NonNull ArgumentHierarchyBranch branch) {
        }

        public @Nullable AbstractArgumentValueProxy<?> getValue(String name) {
            return this.namedValues.get(name);
        }

        public @NonNull List<@NonNull AbstractArgumentValueProxy<?>> getValues() {
            return new ArrayList(this.namedValues.values());
        }

        public void reset() {
            this.namedValues.clear();
        }
    }
}

