/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.scripting.AssetStateValueProxy;
import com.arm.mgd.core.scripting.BooleanStateValueProxy;
import com.arm.mgd.core.scripting.ConstantAssetStateValueProxy;
import com.arm.mgd.core.scripting.ConstantStateValueProxy;
import com.arm.mgd.core.scripting.FloatStateValueProxy;
import com.arm.mgd.core.scripting.IStateValueProxy;
import com.arm.mgd.core.scripting.IndexedStateValuesProxy;
import com.arm.mgd.core.scripting.IntegerStateValueProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.RGBAStateValueProxy;
import com.arm.mgd.core.scripting.StringStateValueProxy;
import com.arm.mgd.core.target.data.CompletableProgressFuture;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.Api;
import com.arm.mgd.lightweight.model.IApiModelWithState;
import com.arm.mgd.lightweight.state.IIndexedStateItem;
import com.arm.mgd.lightweight.state.IIndexedStateItemChild;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemBase;
import com.arm.mgd.lightweight.state.IStateItemContainer;
import com.arm.mgd.lightweight.state.IStateItemValue;
import com.arm.mgd.lightweight.state.value.AssetStateItemValue;
import com.arm.mgd.lightweight.state.value.BooleanStateItemValue;
import com.arm.mgd.lightweight.state.value.EnumAssetStateItemValue;
import com.arm.mgd.lightweight.state.value.EnumStateItemValue;
import com.arm.mgd.lightweight.state.value.FloatStateItemValue;
import com.arm.mgd.lightweight.state.value.IntegerStateItemValue;
import com.arm.mgd.lightweight.state.value.RGBAStateItemValue;
import com.arm.mgd.lightweight.state.value.StringStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCallStatesProxy
implements ProxyObject {
    private static final @NonNull ExecutorService EXECUTOR = NamedExecutors.cachedFiniteThreadPool(1, 60L, TimeUnit.SECONDS, new NamedThreadFactory("StateValueProxy calculator"));
    private static final @NonNull ArrayList<@NonNull String> GL_EGL_STATE_NAMES = new ArrayList();
    private static final @NonNull Map<@NonNull String, StateSpec> GL_EGL_STATE_SPEC_MAP = new HashMap<String, StateSpec>();
    private final @NonNull FunctionCall functionCall;
    private final @NonNull List<@NonNull String> stateNames;
    private final @NonNull Map<@NonNull String, StateSpec> stateSpecMap;

    static {
        FunctionCallStatesProxy.initStateSpecs(KapiSpec.GLES.getApi(), GL_EGL_STATE_NAMES, GL_EGL_STATE_SPEC_MAP);
        FunctionCallStatesProxy.initStateSpecs(KapiSpec.EGL.getApi(), GL_EGL_STATE_NAMES, GL_EGL_STATE_SPEC_MAP);
    }

    FunctionCallStatesProxy(@NonNull FunctionCall functionCall) {
        this.functionCall = functionCall;
        KapiSpec api = functionCall.getFunctionSpec().getKapiSpec();
        if (KapiSpec.EGL.equals(api) || KapiSpec.GLES.equals(api)) {
            this.stateNames = GL_EGL_STATE_NAMES;
            this.stateSpecMap = GL_EGL_STATE_SPEC_MAP;
        } else {
            this.stateNames = NullUtils.EMPTY_LIST;
            this.stateSpecMap = NullUtils.EMPTY_MAP;
        }
    }

    private static void initStateSpecs(@NonNull Api api, @NonNull ArrayList<@NonNull String> stateNames, @NonNull Map<@NonNull String, StateSpec> stateSpecMap) {
        List<StateSpec> specs = api.getStates().getState();
        stateNames.ensureCapacity(specs.size());
        for (StateSpec spec : specs) {
            @NonNull String name = (String)NullUtils.neverNull((Object)spec.getName());
            StateSpec existingSpec = stateSpecMap.get(name);
            if (existingSpec == null) {
                stateNames.add(name);
                stateSpecMap.put(name, spec);
                continue;
            }
            if (existingSpec.isIndexed()) continue;
            assert (spec.isIndexed()) : "Replacing a non-indexed state with another non-indexed state.";
            stateSpecMap.put(name, spec);
        }
    }

    @Override
    public boolean proxyEquals(@Nullable ProxyObject other) {
        if (other instanceof FunctionCallStatesProxy) {
            return this.functionCall.equals(((FunctionCallStatesProxy)other).functionCall);
        }
        return false;
    }

    public @NonNull List<@NonNull String> getStateNames() {
        return this.stateNames;
    }

    public int size() {
        return this.stateNames.size();
    }

    public @Nullable IStateValueProxy getStateValue(String stateName) {
        @Nullable StateSpec spec = this.stateSpecMap.get(stateName);
        if (spec == null) {
            return null;
        }
        @NonNull List<@NonNull IApiModelWithState> apisWithState = this.functionCall.getModel().getParentProcessTarget().getLightweightProcess().getAllApiModelsWithState();
        for (IApiModelWithState apiWithState : apisWithState) {
            IStateItemBase stateItem;
            IStateItemContainer stateItems = apiWithState.waitForStateForFunction(ICoreProgressMonitor.NULL_MONITOR, this.functionCall);
            if (stateItems == null || !(spec.isIndexed() ? (stateItem = stateItems.lookupIndexedStateItem(spec)) != null : (stateItem = stateItems.lookupStateItem(spec)) != null)) continue;
            return FunctionCallStatesProxy.createStateValueProxy(this.functionCall, stateItem);
        }
        return null;
    }

    private static @Nullable IStateValueProxy createStateValueProxy(@NonNull FunctionCall functionCall, @NonNull IIndexedStateItem<?> stateItem) {
        ArrayList<@NonNull IStateValueProxy> values = new ArrayList<IStateValueProxy>();
        int size = stateItem.getIndexCount();
        int index = 0;
        while (index < size) {
            IStateValueProxy proxy;
            @Nullable IIndexedStateItemChild<?> indexedItem = stateItem.getItemForIndex(index);
            if (indexedItem != null && (proxy = FunctionCallStatesProxy.createStateValueProxy(functionCall, indexedItem)) != null) {
                values.add(proxy);
            }
            ++index;
        }
        return new IndexedStateValuesProxy(values);
    }

    private static @Nullable IStateValueProxy createStateValueProxy(@NonNull FunctionCall functionCall, @NonNull IStateItem<?> stateItem) {
        IStateItemValue<?> stateItemValue = FunctionCallStatesProxy.getStateItemValue(functionCall, stateItem);
        if (stateItemValue == null) {
            return null;
        }
        return stateItemValue.accept(new NonIndexedStateVisitor());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable IStateItemValue<?> getStateItemValue(@NonNull FunctionCall functionCall, @NonNull IStateItem<?> stateItem) {
        @NonNull CompletableProgressFuture<@NonNull ?> future = stateItem.getValue(EXECUTOR, functionCall.getID());
        IStateItemValue stateItemValue = null;
        try {
            stateItemValue = (IStateItemValue)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            CoreLogging.severe(null, e, "Failed to calculate state for user scripting.");
        }
        return stateItemValue;
    }

    public @NonNull List<@NonNull IStateValueProxy> getStateValues() {
        @NonNull ArrayList<@NonNull IStateValueProxy> states = new ArrayList<IStateValueProxy>(this.stateSpecMap.size());
        @NonNull List<@NonNull IApiModelWithState> apisWithState = this.functionCall.getModel().getParentProcessTarget().getLightweightProcess().getAllApiModelsWithState();
        for (IApiModelWithState apiWithState : apisWithState) {
            IStateValueProxy stateValueProxy;
            IStateItemContainer stateItems = apiWithState.waitForStateForFunction(ICoreProgressMonitor.NULL_MONITOR, this.functionCall);
            if (stateItems == null) {
                return NullUtils.EMPTY_LIST;
            }
            for (IStateItem<?> iStateItem : stateItems.getAllStateItems()) {
                stateValueProxy = FunctionCallStatesProxy.createStateValueProxy(this.functionCall, iStateItem);
                if (stateValueProxy == null) continue;
                states.add(stateValueProxy);
            }
            for (IIndexedStateItem iIndexedStateItem : stateItems.getAllIndexedStateItems()) {
                stateValueProxy = FunctionCallStatesProxy.createStateValueProxy(this.functionCall, iIndexedStateItem);
                if (stateValueProxy == null) continue;
                states.add(stateValueProxy);
            }
        }
        return states;
    }

    private static final class NonIndexedStateVisitor
    implements IStateItemValue.IStateItemValueVisitor<IStateValueProxy> {
        private NonIndexedStateVisitor() {
        }

        @Override
        public IStateValueProxy visit(BooleanStateItemValue booleanStateItemValue) {
            return new BooleanStateValueProxy(booleanStateItemValue);
        }

        @Override
        public IStateValueProxy visit(AssetStateItemValue<?> assetStateItemValue) {
            return new AssetStateValueProxy(assetStateItemValue);
        }

        @Override
        public IStateValueProxy visit(EnumAssetStateItemValue<?> enumAssetStateItemValue) {
            return new ConstantAssetStateValueProxy(enumAssetStateItemValue);
        }

        @Override
        public IStateValueProxy visit(EnumStateItemValue enumStateItemValue) {
            return new ConstantStateValueProxy(enumStateItemValue);
        }

        @Override
        public IStateValueProxy visit(FloatStateItemValue floatStateItemValue) {
            return new FloatStateValueProxy(floatStateItemValue);
        }

        @Override
        public IStateValueProxy visit(IntegerStateItemValue integerStateItemValue) {
            return new IntegerStateValueProxy(integerStateItemValue);
        }

        @Override
        public IStateValueProxy visit(StringStateItemValue stringStateItemValue) {
            return new StringStateValueProxy(stringStateItemValue);
        }

        @Override
        public IStateValueProxy visit(RGBAStateItemValue rgbaStateItemValue) {
            return new RGBAStateValueProxy(rgbaStateItemValue);
        }
    }
}

