/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.scripting.AbstractArgumentValueProxy;
import com.arm.mgd.core.scripting.FunctionCallAssetsProxy;
import com.arm.mgd.core.scripting.FunctionCallStatesProxy;
import com.arm.mgd.core.scripting.NamedArgumentValuesProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.ReturnValuesProxy;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.BookmarkModel;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCallProxy
implements ProxyObject {
    private final @NonNull FunctionCall functionCall;

    public FunctionCallProxy(@NonNull FunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    public @NonNull FunctionCallAssetsProxy getAssets() {
        return new FunctionCallAssetsProxy(this.functionCall);
    }

    public @NonNull FunctionCallStatesProxy getStates() {
        return new FunctionCallStatesProxy(this.functionCall);
    }

    public @NonNull NamedArgumentValuesProxy getParameters() {
        return new NamedArgumentValuesProxy(this.functionCall, this.functionCall.getArgumentHierarchy());
    }

    public @Nullable AbstractArgumentValueProxy<?> getReturnValue() {
        @Nullable ArgumentHierarchyNode returnHierachy = this.functionCall.getReturnHierachy();
        if (returnHierachy == null) {
            return null;
        }
        return new ReturnValuesProxy(this.functionCall, returnHierachy);
    }

    @Override
    public boolean proxyEquals(@Nullable ProxyObject other) {
        if (other instanceof FunctionCallProxy) {
            return this.functionCall.equals(((FunctionCallProxy)other).functionCall);
        }
        return false;
    }

    public @NonNull String getName() {
        return (String)NullUtils.neverNull((Object)this.functionCall.getFunctionSpec().getName());
    }

    public int getIndex() {
        return this.functionCall.getIndex();
    }

    public long getTimestampStart() {
        return this.functionCall.getTimestampStart();
    }

    public long getTimestampStop() {
        return this.functionCall.getTimestampStop();
    }

    public boolean isDrawCall() {
        return this.functionCall.getFunctionSpec().isDrawCall();
    }

    public boolean isDrawCommand() {
        return this.functionCall.getFunctionSpec().isVulkanDrawCommand();
    }

    public boolean isEGLCall() {
        return this.functionCall.getFunctionSpec().getKapiSpec() == KapiSpec.EGL;
    }

    public boolean isGLESCall() {
        return this.functionCall.getFunctionSpec().getKapiSpec() == KapiSpec.GLES;
    }

    public boolean isCLCall() {
        return this.functionCall.getFunctionSpec().getKapiSpec() == KapiSpec.CL;
    }

    public boolean isVulkanCall() {
        return this.functionCall.getFunctionSpec().getKapiSpec() == KapiSpec.VULKAN;
    }

    public boolean hasError() {
        return this.functionCall.hasError();
    }

    public @Nullable String getNote() {
        BookmarkModel.Bookmark b = this.functionCall.getModel().getBookmarkModel().getBookmark(this.functionCall);
        return b != null ? b.getNote() : null;
    }

    public void setNote(@Nullable String note) {
        if (note == null) {
            this.functionCall.getModel().getBookmarkModel().removeBookmark(this.functionCall);
        } else {
            this.functionCall.getModel().getBookmarkModel().addBookmark(this.functionCall, note);
        }
    }
}

