/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.scripting.AssetTableProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.kapi.gen.Api;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCallAssetsProxy
implements ProxyObject {
    private static final @NonNull ArrayList<@NonNull String> CL_ASSET_TYPES = new ArrayList();
    private static final @NonNull Map<@NonNull String, AssetTableSpec> CL_ASSET_SPEC_MAP = new LinkedHashMap<String, AssetTableSpec>();
    private static final @NonNull ArrayList<@NonNull String> GL_EGL_ASSET_TYPES = new ArrayList();
    private static final @NonNull Map<@NonNull String, AssetTableSpec> GL_EGL_ASSET_SPEC_MAP = new LinkedHashMap<String, AssetTableSpec>();
    private static final @NonNull ArrayList<@NonNull String> VULKAN_ASSET_TYPES = new ArrayList();
    private static final @NonNull Map<@NonNull String, AssetTableSpec> VULKAN_ASSET_SPEC_MAP = new LinkedHashMap<String, AssetTableSpec>();
    private final @NonNull FunctionCall functionCall;
    private final @NonNull List<@NonNull String> assetTypes;
    private final @NonNull Map<@NonNull String, AssetTableSpec> assetSpecMap;

    static {
        FunctionCallAssetsProxy.initAssetSpecs(KapiSpec.CL.getApi(), CL_ASSET_TYPES, CL_ASSET_SPEC_MAP);
        FunctionCallAssetsProxy.initAssetSpecs(KapiSpec.GLES.getApi(), GL_EGL_ASSET_TYPES, GL_EGL_ASSET_SPEC_MAP);
        FunctionCallAssetsProxy.initAssetSpecs(KapiSpec.EGL.getApi(), GL_EGL_ASSET_TYPES, GL_EGL_ASSET_SPEC_MAP);
        FunctionCallAssetsProxy.initAssetSpecs(KapiSpec.VULKAN.getApi(), VULKAN_ASSET_TYPES, VULKAN_ASSET_SPEC_MAP);
    }

    FunctionCallAssetsProxy(@NonNull FunctionCall functionCall) {
        this.functionCall = functionCall;
        KapiSpec api = functionCall.getFunctionSpec().getKapiSpec();
        if (KapiSpec.CL.equals(api)) {
            this.assetTypes = CL_ASSET_TYPES;
            this.assetSpecMap = CL_ASSET_SPEC_MAP;
        } else if (KapiSpec.EGL.equals(api) || KapiSpec.GLES.equals(api)) {
            this.assetTypes = GL_EGL_ASSET_TYPES;
            this.assetSpecMap = GL_EGL_ASSET_SPEC_MAP;
        } else if (KapiSpec.VULKAN.equals(api)) {
            this.assetTypes = VULKAN_ASSET_TYPES;
            this.assetSpecMap = VULKAN_ASSET_SPEC_MAP;
        } else {
            throw new AssertionError((Object)("Unhandled API " + api));
        }
    }

    public @NonNull List<@NonNull String> getAssetTypes() {
        return this.assetTypes;
    }

    public @Nullable AssetTableProxy getAssetTable(@NonNull String assetName) {
        @Nullable AssetTableSpec spec = this.assetSpecMap.get(assetName);
        return spec != null ? new AssetTableProxy(this.functionCall, spec) : null;
    }

    public @NonNull List<@NonNull AssetTableProxy> getAssetTables() {
        @NonNull ArrayList<@NonNull AssetTableProxy> tables = new ArrayList<AssetTableProxy>(this.assetSpecMap.size());
        for (AssetTableSpec spec : this.assetSpecMap.values()) {
            tables.add(new AssetTableProxy(this.functionCall, (AssetTableSpec)NullUtils.neverNull((Object)spec)));
        }
        return tables;
    }

    private static void initAssetSpecs(@NonNull Api api, @NonNull ArrayList<@NonNull String> assetTypes, @NonNull Map<@NonNull String, AssetTableSpec> assetSpecMap) {
        ArrayList<AssetTableSpec> specs = new ArrayList<AssetTableSpec>(api.getAssetTables().getAssetTable());
        specs.sort((s1, s2) -> s1.getPluralName().compareTo(s2.getPluralName()));
        assetTypes.ensureCapacity(assetTypes.size() + specs.size());
        for (AssetTableSpec spec : specs) {
            if (!spec.isUserVisible()) continue;
            @NonNull String name = (String)NullUtils.neverNull((Object)spec.getPluralName());
            assetTypes.add(name);
            assetSpecMap.put(name, spec);
        }
    }

    @Override
    public boolean proxyEquals(@Nullable ProxyObject other) {
        if (other instanceof FunctionCallAssetsProxy) {
            return this.functionCall.equals(((FunctionCallAssetsProxy)other).functionCall);
        }
        return false;
    }

    public int size() {
        return this.assetTypes.size();
    }
}

