/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.scripting.ProcessProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.RenderPassProxy;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.LazyObjectGenerator;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FrameProxy
implements ProxyObject {
    private final @NonNull ProcessProxy process;
    private final @NonNull Frame frame;
    private final @NonNull LazyObjectGenerator<@NonNull List<@NonNull RenderPassProxy>> renderpasses;

    public FrameProxy(final @NonNull Frame frame, @NonNull ProcessProxy process) {
        this.frame = frame;
        this.process = process;
        this.renderpasses = new LazyObjectGenerator<List<RenderPassProxy>>(){

            @Override
            protected @NonNull List<@NonNull RenderPassProxy> generateObject() {
                TraceDataModel model = frame.getParentModel();
                if (!model.containsEGL() && !model.containsGLES()) {
                    return NullUtils.EMPTY_LIST;
                }
                @NonNull List<@NonNull FrameRenderPass> renderPassList = frame.getRenderPassList();
                @NonNull ArrayList<@NonNull RenderPassProxy> retVal = new ArrayList<RenderPassProxy>(renderPassList.size());
                for (FrameRenderPass renderPass : renderPassList) {
                    retVal.add(new RenderPassProxy(renderPass));
                }
                return NullUtils.unmodifiableList(retVal);
            }
        };
    }

    public int getIndex() {
        return this.frame.getLabelIndex();
    }

    public int getFirstFunctionIndex() {
        return this.frame.getFirstFunctionIndex();
    }

    public int getLastFunctionIndex() {
        return this.frame.getLastFunctionIndex();
    }

    public @NonNull List<@NonNull RenderPassProxy> getRenderPasses() {
        return this.renderpasses.get();
    }

    public int getFunctionCallCount() {
        return this.frame.getApiCallCount();
    }

    public boolean featuresEnabled() {
        return this.frame.featuresEnabled();
    }

    @Override
    public boolean proxyEquals(@Nullable ProxyObject other) {
        if (other instanceof FrameProxy) {
            FrameProxy fp = (FrameProxy)other;
            return this.frame.equals(fp.frame) && this.process.equals(fp.process);
        }
        return false;
    }
}

