/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.scripting.AssetProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.ScriptingSnapshotManager;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AssetTableProxy
implements ProxyObject {
    private final @NonNull FunctionCall functionCall;
    private final @NonNull AssetTableSpec assetTableSpec;

    AssetTableProxy(@NonNull FunctionCall functionCall, @NonNull AssetTableSpec assetTableSpec) {
        this.functionCall = functionCall;
        this.assetTableSpec = assetTableSpec;
    }

    public @NonNull List<@NonNull Long> getAssetHandles() {
        AssetTable table = ScriptingSnapshotManager.getTraceStateSnapshotAt(this.functionCall).getAssetTableBySpec(this.assetTableSpec);
        @NonNull ArrayList<@NonNull Long> assets = new ArrayList<Long>(table.size());
        for (IAssetItem item : table) {
            assets.add((Long)NullUtils.neverNull((Object)item.getId()));
        }
        return assets;
    }

    public @Nullable AssetProxy getAsset(@NonNull Long handle) {
        @Nullable IAssetItem asset = this.getAssetTable().get(handle);
        return asset != null ? new AssetProxy(this.functionCall, asset) : null;
    }

    public @NonNull List<@NonNull AssetProxy> getAssets() {
        AssetTable table = this.getAssetTable();
        @NonNull ArrayList<@NonNull AssetProxy> assets = new ArrayList<AssetProxy>(table.size());
        for (IAssetItem item : table) {
            assets.add(new AssetProxy(this.functionCall, (IAssetItem)NullUtils.neverNull((Object)item)));
        }
        return assets;
    }

    private @NonNull AssetTable getAssetTable() {
        return (AssetTable)NullUtils.neverNull((Object)ScriptingSnapshotManager.getTraceStateSnapshotAt(this.functionCall).getAssetTableBySpec(this.assetTableSpec));
    }

    public int size() {
        AssetTable table = ScriptingSnapshotManager.getTraceStateSnapshotAt(this.functionCall).getAssetTableBySpec(this.assetTableSpec);
        return table.size();
    }

    @Override
    public boolean proxyEquals(@Nullable ProxyObject other) {
        if (other instanceof AssetTableProxy) {
            AssetTableProxy otherProxy = (AssetTableProxy)other;
            return this.functionCall.equals(otherProxy.functionCall) && this.assetTableSpec.equals(otherProxy.assetTableSpec);
        }
        return false;
    }
}

