/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.scripting.AbstractNonIndexedStateValueProxy;
import com.arm.mgd.core.scripting.IStateValueProxy;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.state.value.AssetStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AssetStateValueProxy
extends AbstractNonIndexedStateValueProxy<AssetStateItemValue<?>, Long> {
    public AssetStateValueProxy(@NonNull AssetStateItemValue<?> assetStateItemValue) {
        super(assetStateItemValue);
    }

    public <T> @NonNull T accept(@NonNull IStateValueProxy.IStateValueProxyVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public @Nullable Long getValue() {
        @Nullable AssetItemID value = (AssetItemID)((AssetStateItemValue)this.stateItem).getValue();
        return AssetStateValueProxy.createFromAssetItemID(value);
    }

    @Override
    public @NonNull List<@Nullable Long> getValues() {
        @NonNull List<@Nullable T> values = ((AssetStateItemValue)this.stateItem).getValues();
        @NonNull ArrayList<@Nullable Long> valuesAsLongs = new ArrayList<Long>(values.size());
        for (AssetItemID value : values) {
            valuesAsLongs.add(AssetStateValueProxy.createFromAssetItemID(value));
        }
        return valuesAsLongs;
    }

    private static @Nullable Long createFromAssetItemID(@Nullable AssetItemID value) {
        if (value == null) {
            return null;
        }
        return NullUtils.longValueOf((long)value.asLong());
    }
}

