/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.scripting.AbstractAssetPropertyProviderProxy;
import com.arm.mgd.core.scripting.AbstractAssetPropertyProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.ScriptingSnapshotManager;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AssetProxy
extends AbstractAssetPropertyProviderProxy {
    private final @NonNull AssetTableSpec assetTable;
    private final @NonNull Long assetId;

    AssetProxy(@NonNull FunctionCall functionCall, @NonNull IAssetItem assetItem) {
        super(functionCall, assetItem.getSimpleValue());
        this.assetTable = (AssetTableSpec)NullUtils.neverNull((Object)assetItem.getAssetSpec());
        this.assetId = (Long)NullUtils.neverNull((Object)assetItem.getId());
    }

    @Override
    protected @NonNull IAssetItem getProperty() {
        return (IAssetItem)NullUtils.neverNull((Object)ScriptingSnapshotManager.getTraceStateSnapshotAt(this.functionCall).getAssetTableBySpec(this.assetTable).get(this.assetId));
    }

    @Override
    public boolean proxyEquals(@Nullable ProxyObject other) {
        if (other instanceof AssetProxy) {
            AssetProxy otherProxy = (AssetProxy)other;
            return this.functionCall.equals(otherProxy.functionCall) && this.assetTable.equals(otherProxy.assetTable) && this.assetId.equals(otherProxy.assetId);
        }
        return false;
    }

    @Override
    public <T> T accept(@NonNull AbstractAssetPropertyProxy.IAssetPropertyProxyVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

