/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.IAssetPropertyProvider;
import com.arm.mgd.core.scripting.AbstractAssetPropertyProviderProxy;
import com.arm.mgd.core.scripting.AssetPropertyProviderProxy;
import com.arm.mgd.core.scripting.AssetPropertyProxy;
import com.arm.mgd.core.scripting.AssetProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractAssetPropertyProxy
implements ProxyObject {
    private final @NonNull String value;
    private @NonNull AssetDataStatus bufferDataStatus = AssetDataStatus.UNKNOWN;
    private @Nullable WeakReference<byte @Nullable []> bufferCache = null;
    private @NonNull AssetDataStatus textDataStatus = AssetDataStatus.UNKNOWN;
    private @Nullable WeakReference<@Nullable String> textCache = null;

    protected AbstractAssetPropertyProxy(@NonNull String value) {
        this.value = value;
    }

    public abstract <T> T accept(@NonNull IAssetPropertyProxyVisitor<T> var1);

    static @NonNull AbstractAssetPropertyProxy create(@NonNull FunctionCall functionCall, @NonNull AbstractAssetPropertyProviderProxy parentProvider, @NonNull String propertyName, @NonNull IAssetProperty assetProperty) {
        if (assetProperty instanceof IAssetItem && ((IAssetItem)assetProperty).getAssetSpec().isUserVisible()) {
            return new AssetProxy(functionCall, (IAssetItem)assetProperty);
        }
        if (assetProperty instanceof IAssetPropertyProvider) {
            return new AssetPropertyProviderProxy(functionCall, assetProperty.getSimpleValue(), parentProvider, propertyName);
        }
        return new AssetPropertyProxy(assetProperty.getSimpleValue(), parentProvider, propertyName);
    }

    public @NonNull String getValue() {
        return this.value;
    }

    protected abstract @NonNull IAssetProperty getProperty();

    public boolean hasBufferData() {
        if (this.bufferDataStatus == AssetDataStatus.UNKNOWN) {
            this.loadBufferData();
        }
        assert (this.bufferDataStatus != AssetDataStatus.UNKNOWN);
        return this.bufferDataStatus == AssetDataStatus.EXISTS;
    }

    public byte @Nullable [] getBufferData() {
        byte @Nullable [] data = this.loadBufferData();
        return data != null ? Arrays.copyOf(data, data.length) : null;
    }

    public boolean hasTextData() {
        if (this.textDataStatus == AssetDataStatus.UNKNOWN) {
            this.loadTextData();
        }
        assert (this.textDataStatus != AssetDataStatus.UNKNOWN);
        return this.textDataStatus == AssetDataStatus.EXISTS;
    }

    public @Nullable String getTextData() {
        return this.loadTextData();
    }

    private byte @Nullable [] loadBufferData() {
        byte[] buffer;
        byte[] cachedBuffer;
        if (this.bufferDataStatus == AssetDataStatus.DOESNT_EXIST) {
            return null;
        }
        if (this.bufferDataStatus == AssetDataStatus.EXISTS && (cachedBuffer = (byte[])((WeakReference)NullUtils.neverNull(this.bufferCache)).get()) != null) {
            return cachedBuffer;
        }
        @Nullable IBufferItem bufferItem = this.getProperty().getBufferForm();
        byte[] byArray = buffer = bufferItem != null ? bufferItem.getDataForBuffer() : null;
        if (buffer == null) {
            assert (this.bufferDataStatus == AssetDataStatus.UNKNOWN);
            this.bufferDataStatus = AssetDataStatus.DOESNT_EXIST;
            return null;
        }
        byte @NonNull [] bufferCopy = NullUtils.neverNull((byte[])Arrays.copyOf(buffer, buffer.length));
        this.bufferCache = new WeakReference<byte[]>(bufferCopy);
        this.bufferDataStatus = AssetDataStatus.EXISTS;
        return bufferCopy;
    }

    private @Nullable String loadTextData() {
        String cachedText;
        if (this.textDataStatus == AssetDataStatus.DOESNT_EXIST) {
            return null;
        }
        if (this.textDataStatus == AssetDataStatus.EXISTS && (cachedText = (String)((WeakReference)NullUtils.neverNull(this.textCache)).get()) != null) {
            return cachedText;
        }
        @Nullable String text = this.getProperty().getTextForm();
        if (text == null) {
            assert (this.textDataStatus == AssetDataStatus.UNKNOWN);
            this.textDataStatus = AssetDataStatus.DOESNT_EXIST;
            return null;
        }
        this.textCache = new WeakReference<String>(text);
        this.textDataStatus = AssetDataStatus.EXISTS;
        return text;
    }

    private static enum AssetDataStatus {
        UNKNOWN,
        EXISTS,
        DOESNT_EXIST;

    }

    public static interface IAssetPropertyProxyVisitor<T> {
        public T visit(@NonNull AssetProxy var1);

        public T visit(@NonNull AssetPropertyProviderProxy var1);

        public T visit(@NonNull AssetPropertyProxy var1);
    }
}

