/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting;

import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.IAssetPropertyProvider;
import com.arm.mgd.core.scripting.AbstractAssetPropertyProxy;
import com.arm.mgd.core.target.data.FunctionCall;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractAssetPropertyProviderProxy
extends AbstractAssetPropertyProxy {
    protected final @NonNull FunctionCall functionCall;

    protected AbstractAssetPropertyProviderProxy(@NonNull FunctionCall functionCall, @NonNull String value) {
        super(value);
        this.functionCall = functionCall;
    }

    @Override
    protected abstract @NonNull IAssetPropertyProvider getProperty();

    public @NonNull List<@NonNull String> getPropertyNames() {
        return new ArrayList<String>(this.getProperty().getProperties().keySet());
    }

    public int size() {
        return this.getProperty().getProperties().size();
    }

    public @Nullable AbstractAssetPropertyProxy getProperty(@NonNull String name) {
        @NonNull IAssetPropertyProvider provider = this.getProperty();
        @Nullable IAssetProperty property = provider.getProperties().get(name);
        return property != null ? AbstractAssetPropertyProxy.create(this.functionCall, this, name, property) : null;
    }

    public @NonNull List<@NonNull AbstractAssetPropertyProxy> getProperties() {
        @NonNull IAssetPropertyProvider provider = this.getProperty();
        Set<Map.Entry<@NonNull String, @NonNull IAssetProperty>> entries = provider.getProperties().entrySet();
        @NonNull ArrayList<@NonNull AbstractAssetPropertyProxy> properties = new ArrayList<AbstractAssetPropertyProxy>(entries.size());
        for (Map.Entry<String, IAssetProperty> entry : entries) {
            properties.add(AbstractAssetPropertyProxy.create(this.functionCall, this, entry.getKey(), entry.getValue()));
        }
        return properties;
    }
}

