/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.replay.texture;

import com.arm.mgd.core.asset.AssetProcessor;
import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureUnitAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.replay.FunctionBuilder;
import com.arm.mgd.core.replay.OverriddenFrameData;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.AbstractOverrideAttachment;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TextureArgAttachment;
import com.arm.mgd.core.target.data.TextureOverrideAttachment;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TextureOverride
extends AbstractFrameOverride {
    public static final String ANALYTICS_ID = "textureoverride";
    private @NonNull AbstractConstantOrAliasSpecExtended originalTextureUnitBoundTo;
    private final @Nullable IByteDataProvider overrideTexture;
    private boolean textureCurrentlyBound;
    private boolean textureOverrideActive;
    private @NonNull Long textureToReplace;
    private Long originalTextureId;

    private static int getTextureLevel(FunctionCall fc) {
        if (KapiSpec.GLES.functions.GLTEXIMAGE2D.equals(fc.getFunctionSpec())) {
            return GLES.GlTexImage2DDecorator.getArgumentLevel(fc);
        }
        if (KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE2D.equals(fc.getFunctionSpec())) {
            return GLES.GlCompressedTexImage2DDecorator.getArgumentLevel(fc);
        }
        CoreLogging.severe(null, "getTextureLevel function called without a glTexImage2D or a glCompressedTexImage2D call");
        return 0;
    }

    public TextureOverride(@Nullable IByteDataProvider overrideTexture, long textureToReplace) {
        this.originalTextureUnitBoundTo = KapiSpec.GLES.constants.GL_TEXTURE0;
        this.textureCurrentlyBound = false;
        this.textureOverrideActive = false;
        this.overrideTexture = overrideTexture;
        this.textureToReplace = NullUtils.longValueOf((long)textureToReplace);
        this.textureOverrideActive = true;
    }

    @Override
    public AppliedTextureOverride addOverride(OverriddenFrameData overridenFrameData) {
        Frame originalFrame = overridenFrameData.getOriginalFrame();
        List<FunctionCall> rebuiltFrame = overridenFrameData.getReplayFunctions();
        if (this.textureOverrideActive) {
            TraceDataModel traceDataModel = originalFrame.getParentModel();
            int originalFrameFirstFunctionId = originalFrame.getFirstFunctionIndex();
            this.textureCurrentlyBound = false;
            this.checkIfOverrideTextureIsBound(originalFrame);
            this.addAppropriateBindAndActiveTextureFunctions(rebuiltFrame, originalFrame);
            FunctionCall texImageCall = FunctionBuilder.createFunction(traceDataModel, KapiSpec.GLES.functions.GLTEXIMAGE2D, FunctionBuilder.args(new Serializable[]{KapiSpec.GLES.constants.GL_TEXTURE_2D.getValue(), "0", KapiSpec.GLES.constants.GL_RGB.getValue(), "256", "256", "0", KapiSpec.GLES.constants.GL_RGB.getValue(), KapiSpec.GLES.constants.GL_UNSIGNED_BYTE.getValue(), "0xFF"}), null);
            FunctionCall generateMipmapsCall = FunctionBuilder.createFunction(traceDataModel, KapiSpec.GLES.functions.GLGENERATEMIPMAP, FunctionBuilder.args(new Serializable[]{KapiSpec.GLES.constants.GL_TEXTURE_2D.getValue()}), null);
            try {
                texImageCall.addArgAttachment(8, new TextureArgAttachment(this.overrideTexture));
            }
            catch (TraceParseException e) {
                e.printStackTrace();
                assert (false);
                return null;
            }
            rebuiltFrame.add(texImageCall);
            rebuiltFrame.add(generateMipmapsCall);
            SynchronousTraceStateSnapshot currentState = new SynchronousTraceStateSnapshot(traceDataModel);
            currentState.setSelectedFunction(originalFrameFirstFunctionId);
            this.resetTextureBoundandActiveMethods(rebuiltFrame, currentState);
        }
        return new AppliedTextureOverride(true);
    }

    @Override
    public boolean canApplyOverride(Frame originalFrame) {
        if (!this.textureOverrideActive) {
            return false;
        }
        SynchronousTraceStateSnapshot currentState = new SynchronousTraceStateSnapshot(originalFrame.getParentModel());
        StateItem boundTextureState = null;
        for (FunctionCall currentFunction : originalFrame.getParentModel().getCallItems(originalFrame.getFirstFunctionIndex(), originalFrame.getLastFunctionIndex() - originalFrame.getFirstFunctionIndex())) {
            if (!currentFunction.getFunctionSpec().isTextureCall() && !currentFunction.getFunctionSpec().isCompressedTextureCall()) continue;
            currentState.setSelectedFunction(currentFunction.getIndex());
            AbstractConstantOrAliasSpecExtended target = currentFunction.getTextureTarget();
            assert (target != null);
            boundTextureState = AssetProcessor.getTextureCurrentBoundState(currentState, target);
            if (boundTextureState == null) {
                TraceAnalysisLogger.error(currentState, currentFunction, "No texture is bound to " + target.getName() + ".");
                continue;
            }
            FunctionCall boundCall = (FunctionCall)NullUtils.neverNull((Object)boundTextureState.getLastAffectedByFunction());
            if (!GLES.GlBindTextureDecorator.getArgumentTexture(boundCall).equals(this.textureToReplace)) continue;
            CoreLogging.info(null, "Can't replace Texture " + this.textureToReplace + " as this texture is edited in this frame.");
            this.textureOverrideActive = false;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextureOverride)) {
            return false;
        }
        TextureOverride to = (TextureOverride)o;
        return to.getOverrideName().equals(this.getOverrideName()) && to.getModifiedAsset().equals(this.getModifiedAsset());
    }

    @Override
    public String getModifiedAsset() {
        return "Texture " + this.textureToReplace;
    }

    @Override
    public String getOverrideName() {
        return "Texture Override";
    }

    @Override
    public FrameOverrides.OverrideType getOverrideType() {
        return FrameOverrides.OverrideType.TEXTURE_OVERRIDE;
    }

    public @Nullable IByteDataProvider getTextureData() {
        return this.overrideTexture;
    }

    public @NonNull Long getTextureToReplace() {
        return this.textureToReplace;
    }

    public int hashCode() {
        return this.getOverrideName().hashCode() ^ this.getModifiedAsset().hashCode();
    }

    public void setTextureToReplace(@NonNull Long newTexture) {
        this.textureToReplace = newTexture;
    }

    private void addAppropriateBindAndActiveTextureFunctions(List<FunctionCall> rebuiltFrame, Frame originalFrame) {
        TraceDataModel traceDataModel = originalFrame.getParentModel();
        FunctionCall activeFunction = FunctionBuilder.createFunction(traceDataModel, KapiSpec.GLES.functions.GLACTIVETEXTURE, FunctionBuilder.args(new Serializable[]{this.originalTextureUnitBoundTo.getValue()}), null);
        rebuiltFrame.add(activeFunction);
        FunctionCall boundFunction = FunctionBuilder.createFunction(traceDataModel, KapiSpec.GLES.functions.GLBINDTEXTURE, FunctionBuilder.args(new Serializable[]{KapiSpec.GLES.constants.GL_TEXTURE_2D.getValue(), String.valueOf(this.textureToReplace)}), null);
        rebuiltFrame.add(boundFunction);
    }

    private void checkIfOverrideTextureIsBound(Frame originalFrame) {
        IAssetItem[] elements;
        TraceDataModel traceDataModel = originalFrame.getParentModel();
        SynchronousTraceStateSnapshot currentState = new SynchronousTraceStateSnapshot(traceDataModel);
        currentState.setSelectedFunction(originalFrame.getFirstFunctionIndex());
        IAssetItem[] iAssetItemArray = elements = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS.SPEC).toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAssetItem textureUnitElement = iAssetItemArray[n2];
            GlTextureUnitAsset textureUnitAsset = (GlTextureUnitAsset)textureUnitElement;
            for (GlTextureAsset textureAsset : textureUnitAsset.getAllBoundTextures()) {
                if (!this.textureToReplace.equals(textureAsset.getId())) continue;
                this.textureCurrentlyBound = true;
                this.originalTextureId = this.textureToReplace;
                this.originalTextureUnitBoundTo = GlTextureUnitAsset.convertTextureUnitIdToTextureUnitEnum(textureUnitAsset.getId());
            }
            ++n2;
        }
        if (!this.textureCurrentlyBound) {
            this.originalTextureUnitBoundTo = KapiSpec.GLES.constants.GL_TEXTURE0;
        }
    }

    private boolean removeOverride(List<FunctionCall> rebuiltFrame, Frame originalFrame) {
        if (this.textureOverrideActive) {
            TraceDataModel traceDataModel = originalFrame.getParentModel();
            SynchronousTraceStateSnapshot currentState = new SynchronousTraceStateSnapshot(traceDataModel);
            this.addAppropriateBindAndActiveTextureFunctions(rebuiltFrame, originalFrame);
            currentState.setSelectedFunction(originalFrame.getFirstFunctionIndex());
            AssetTable texturesTable = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC);
            GlTextureAsset assetItem = (GlTextureAsset)texturesTable.get(this.textureToReplace);
            assert (assetItem != null);
            ArrayDeque<FunctionCall> functionsToBeAdded = new ArrayDeque<FunctionCall>();
            boolean firstFound = false;
            while (assetItem != null) {
                FunctionCall textureFunctionCall = assetItem.getPreviousModificationFunction();
                if (textureFunctionCall == null || textureFunctionCall.equals(assetItem.getCreatedByFunction())) break;
                if ((KapiSpec.GLES.functions.GLTEXIMAGE2D.equals(textureFunctionCall.getFunctionSpec()) || KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE2D.equals(textureFunctionCall.getFunctionSpec())) && TextureOverride.getTextureLevel(textureFunctionCall) == 0) {
                    if (firstFound) break;
                    firstFound = true;
                }
                functionsToBeAdded.addFirst(textureFunctionCall);
                currentState.setSelectedFunction(textureFunctionCall.getIndex() - 1);
                texturesTable = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC);
                assetItem = (GlTextureAsset)texturesTable.get(this.textureToReplace);
            }
            rebuiltFrame.addAll(functionsToBeAdded);
            currentState.setSelectedFunction(originalFrame.getLastFunctionIndex());
            this.resetTextureBoundandActiveMethods(rebuiltFrame, currentState);
        }
        return true;
    }

    private void resetTextureBoundandActiveMethods(List<FunctionCall> rebuiltFrame, @NonNull SynchronousTraceStateSnapshot currentState) {
        StateItem boundTextureState = AssetProcessor.getTextureCurrentBoundState(currentState, KapiSpec.GLES.constants.GL_TEXTURE_2D);
        StateItem activeTextureState = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_ACTIVE_TEXTURE);
        FunctionCall boundFunctionCall = boundTextureState.getLastAffectedByFunction();
        FunctionCall activeTextureCall = activeTextureState.getLastAffectedByFunction();
        if (!this.textureCurrentlyBound) {
            AssetTable table = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS.SPEC);
            Long id = GlTextureUnitAsset.convertTextureUnitEnumToTextureUnitId(this.originalTextureUnitBoundTo);
            IAssetItem item = table.get(id);
            FunctionCall recentFunc = item.getPreviousModificationFunction();
            while (recentFunc != null) {
                if (recentFunc.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDTEXTURE)) {
                    rebuiltFrame.add(recentFunc);
                    break;
                }
                currentState.setSelectedFunction(recentFunc.getIndex());
                table = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS.SPEC);
                item = table.get(id);
                recentFunc = item.getPreviousModificationFunction();
            }
        }
        if (activeTextureCall != null) {
            rebuiltFrame.add(activeTextureCall);
        }
        if (boundFunctionCall != null) {
            rebuiltFrame.add(boundFunctionCall);
        }
    }

    @Override
    public boolean affectsSameAsset(AbstractFrameOverride override) {
        if (override instanceof TextureOverride) {
            return ((TextureOverride)override).textureToReplace.longValue() == this.textureToReplace.longValue();
        }
        return false;
    }

    @Override
    public @NonNull AbstractOverrideAttachment asMarshallerObject() {
        return new TextureOverrideAttachment(this.textureToReplace, this.overrideTexture);
    }

    public class AppliedTextureOverride
    extends AbstractFrameOverride.AbstractAppliedOverride {
        public AppliedTextureOverride(boolean undoResult) {
        }

        @Override
        public boolean removeOverride(OverriddenFrameData overridenFrameData) {
            return TextureOverride.this.removeOverride(overridenFrameData.getReplayFunctions(), overridenFrameData.getOriginalFrame());
        }
    }
}

