/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.replay.shader;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramHelper;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlVertexAttributeAsset;
import com.arm.mgd.core.asset.SourceProvider;
import com.arm.mgd.core.asset.programvariable.ShaderAttribute;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.replay.FreeAssetAllocator;
import com.arm.mgd.core.replay.FunctionBuilder;
import com.arm.mgd.core.replay.OverriddenFrameData;
import com.arm.mgd.core.target.data.AbstractOverrideAttachment;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ProgramOverrideAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.util.ComparatorUtils;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class ProgramOverride
extends AbstractFrameOverride {
    private static final Pointer DUMMY_POINTER_VALUE = Pointer.valueOf(1L);
    public static final String ANALYTICS_ID = "editshader";
    private @NonNull SourceProvider newFragmentShader;
    private @NonNull SourceProvider newVertexShader;
    protected @NonNull GlProgramAsset originalProgram;
    private Long overrideProgramID;
    private Long overrideFragmentShaderID;
    private Long overrideVertexShaderID;
    private Long overrideProgramMappingID;
    private Long overrideFragmentMappingID;
    private Long overrideVertexMappingID;

    public ProgramOverride(@NonNull GlProgramAsset program) {
        this.originalProgram = program;
        GlShaderAsset vertexShader = program.getLinkedShader(KapiSpec.GLES.constants.GL_VERTEX_SHADER);
        GlShaderAsset fragmentShader = program.getLinkedShader(KapiSpec.GLES.constants.GL_FRAGMENT_SHADER);
        assert (fragmentShader != null);
        assert (vertexShader != null);
        this.newVertexShader = new SourceProvider(vertexShader);
        this.newFragmentShader = new SourceProvider(fragmentShader);
    }

    public ProgramOverride(long programId, @NonNull TraceStateSnapshot currentSnapshot, @NonNull String vertexShaderSource, @NonNull String fragmentShaderSource) {
        this(programId, currentSnapshot);
        this.newVertexShader.setSource(vertexShaderSource);
        this.newVertexShader.setSource(fragmentShaderSource);
    }

    public ProgramOverride(long programId, @NonNull TraceStateSnapshot currentSnapshot) {
        AssetTable programTable = currentSnapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC);
        GlProgramAsset programAsset = (GlProgramAsset)programTable.get((Long)programId);
        assert (programAsset != null);
        this.originalProgram = programAsset;
        GlShaderAsset vertexShader = programAsset.getLinkedShader(KapiSpec.GLES.constants.GL_VERTEX_SHADER);
        GlShaderAsset fragmentShader = programAsset.getLinkedShader(KapiSpec.GLES.constants.GL_FRAGMENT_SHADER);
        assert (fragmentShader != null);
        assert (vertexShader != null);
        this.newVertexShader = new SourceProvider(vertexShader);
        this.newFragmentShader = new SourceProvider(fragmentShader);
    }

    public Long getOverrideProgram() {
        return this.overrideProgramID;
    }

    public Long getOverrideFragmentShaderID() {
        return this.overrideFragmentShaderID;
    }

    public Long getOverrideVertexShaderID() {
        return this.overrideVertexShaderID;
    }

    private static boolean isAttributeNonArraySetter(@NonNull IFunctionOrAliasSpecExtended spec) {
        return KapiSpec.GLES.functions.GLVERTEXATTRIB1F.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIB1FV.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIB2F.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIB2FV.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIB3F.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIB3FV.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIB4F.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIB4FV.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIBI4I.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIBI4IV.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIBI4UI.equals(spec) || KapiSpec.GLES.functions.GLVERTEXATTRIBI4UIV.equals(spec);
    }

    @Override
    public AppliedProgramOverride addOverride(OverriddenFrameData overridenFrameData) {
        FunctionCall lmf;
        ArrayList uniforms;
        Frame originalFrame = overridenFrameData.getOriginalFrame();
        List<FunctionCall> rebuiltFrame = overridenFrameData.getReplayFunctions();
        FreeAssetAllocator freeAssetAllocator = overridenFrameData.getFreeAssetAllocator();
        SynchronousTraceStateSnapshot snapshot = new SynchronousTraceStateSnapshot(originalFrame.getParentModel());
        Long programInUseAtStartOfFrame = ProgramOverride.getProgramInUse(snapshot, originalFrame.getFirstFunctionIndex());
        Long programInUseAtEndOfFrame = ProgramOverride.getProgramInUse(snapshot, originalFrame.getLastFunctionIndex());
        List<@NonNull Long> programIDs = freeAssetAllocator.find(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC, 1);
        if (programIDs.isEmpty()) {
            return null;
        }
        List<@NonNull Long> shaderIDs = freeAssetAllocator.find(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC, 2);
        if (shaderIDs.isEmpty()) {
            return null;
        }
        this.overrideProgramID = programIDs.get(0);
        this.overrideFragmentShaderID = shaderIDs.get(0);
        this.overrideVertexShaderID = shaderIDs.get(1);
        ArrayList<FunctionCall> functionsToAdd = new ArrayList<FunctionCall>();
        FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLCREATEPROGRAM, this.overrideProgramID);
        FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLCREATESHADER, FunctionBuilder.args(new Serializable[]{KapiSpec.GLES.constants.GL_FRAGMENT_SHADER.getValue()}), this.overrideFragmentShaderID);
        FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLCREATESHADER, FunctionBuilder.args(new Serializable[]{KapiSpec.GLES.constants.GL_VERTEX_SHADER.getValue()}), this.overrideVertexShaderID);
        try {
            ProgramOverride.addGlShaderSource(functionsToAdd, originalFrame.getParentModel(), (Long)NullUtils.neverNull((Object)this.overrideFragmentShaderID), (String)NullUtils.neverNull((Object)this.newFragmentShader.getSource()));
            ProgramOverride.addGlShaderSource(functionsToAdd, originalFrame.getParentModel(), (Long)NullUtils.neverNull((Object)this.overrideVertexShaderID), (String)NullUtils.neverNull((Object)this.newVertexShader.getSource()));
        }
        catch (TraceParseException e) {
            CoreLogging.severe(e);
        }
        FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLCOMPILESHADER, FunctionBuilder.args(this.overrideFragmentShaderID), null);
        FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLCOMPILESHADER, FunctionBuilder.args(this.overrideVertexShaderID), null);
        FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLATTACHSHADER, FunctionBuilder.args(this.overrideProgramID, this.overrideFragmentShaderID), null);
        FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLATTACHSHADER, FunctionBuilder.args(this.overrideProgramID, this.overrideVertexShaderID), null);
        snapshot.setSelectedFunction(originalFrame.getFirstFunctionIndex());
        GlProgramAsset programSnapshot = (GlProgramAsset)snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC).get(this.originalProgram.getId());
        List<ShaderAttribute> attributes = programSnapshot != null ? programSnapshot.getAttributes() : null;
        ArrayList arrayList = uniforms = programSnapshot != null ? new ArrayList(programSnapshot.getUniformsContainer().getAllVariables()) : null;
        if (attributes != null) {
            for (ShaderAttribute attribute : attributes) {
                if (attribute == null) continue;
                StringsArgAttachment nameString = new StringsArgAttachment(attribute.name);
                FunctionCall fc = FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLBINDATTRIBLOCATION, FunctionBuilder.args(this.overrideProgramID, attribute.getId(), DUMMY_POINTER_VALUE), null);
                try {
                    fc.addArgAttachment(2, nameString);
                }
                catch (TraceParseException e) {
                    CoreLogging.severe(null, e, null);
                }
            }
        }
        FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLLINKPROGRAM, FunctionBuilder.args(this.overrideProgramID), null);
        FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLUSEPROGRAM, FunctionBuilder.args(this.overrideProgramID), null);
        if (attributes != null) {
            for (ShaderAttribute attribute : attributes) {
                if (attribute == null) continue;
                lmf = attribute.getPreviousModificationFunction();
                GlVertexAttributeAsset vaa = attribute.getVertexAttributeAsset(snapshot);
                if (lmf == null || vaa == null) continue;
                if (ProgramOverride.isAttributeNonArraySetter(lmf.getFunctionSpec())) {
                    functionsToAdd.add(lmf);
                    continue;
                }
                if (!KapiSpec.GLES.functions.GLVERTEXATTRIBPOINTER.equals(lmf.getFunctionSpec()) || !vaa.isArrayEnabled()) continue;
                functionsToAdd.add(lmf);
                FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLENABLEVERTEXATTRIBARRAY, FunctionBuilder.args(attribute.getId()), null);
            }
        }
        if (uniforms != null) {
            for (ShaderUniform uniform : uniforms) {
                if (uniform == null || (lmf = uniform.getPreviousModificationFunction()) == null) continue;
                functionsToAdd.add(lmf);
            }
        }
        if (!this.originalProgram.getId().equals(programInUseAtStartOfFrame)) {
            FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLUSEPROGRAM, FunctionBuilder.args(programInUseAtStartOfFrame != null ? programInUseAtStartOfFrame : Long.valueOf(0L)), null);
        }
        rebuiltFrame.addAll(functionsToAdd);
        return new AppliedProgramOverride(rebuiltFrame.size(), this.overrideProgramID, this.overrideFragmentShaderID, this.overrideVertexShaderID, this.originalProgram.getId().equals(programInUseAtEndOfFrame));
    }

    @Override
    public boolean canApplyOverride(Frame originalFrame) {
        SynchronousTraceStateSnapshot snapshot = new SynchronousTraceStateSnapshot(originalFrame.getParentModel());
        int firstFunctionIndex = originalFrame.getFirstFunctionIndex();
        int lastFunctionIndex = originalFrame.getLastFunctionIndex();
        int index = firstFunctionIndex;
        while (index < lastFunctionIndex) {
            GlProgramAsset programSnapshot;
            snapshot.setSelectedFunction(index);
            FunctionCall functionCall = originalFrame.getParentModel().getCallItem(index);
            if (functionCall instanceof DrawFunctionCall && !functionCall.hasError() && (programSnapshot = (GlProgramAsset)snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC).get(this.originalProgram.getId())) != null && programSnapshot.isAssetActive()) {
                return true;
            }
            ++index;
        }
        return false;
    }

    @Override
    public String getModifiedAsset() {
        return "Program # " + this.getProgram().getId();
    }

    public SourceProvider getNewFragmentShader() {
        return this.newFragmentShader;
    }

    public SourceProvider getNewVertexShader() {
        return this.newVertexShader;
    }

    @Override
    public String getOverrideName() {
        return "Shader source replacement";
    }

    public GlProgramAsset getProgram() {
        return this.originalProgram;
    }

    private static void addGlShaderSource(@NonNull List<FunctionCall> functionsToAdd, @NonNull TraceDataModel traceDataModel, @NonNull Long shaderID, @NonNull String shaderSource) throws TraceParseException {
        StringsArgAttachment sourceArg = new StringsArgAttachment(shaderSource);
        FunctionCall glShaderSource = FunctionBuilder.addFunction(functionsToAdd, traceDataModel, KapiSpec.GLES.functions.GLSHADERSOURCE, FunctionBuilder.args(new Serializable[]{shaderID, Integer.valueOf(1), DUMMY_POINTER_VALUE, "0x0"}), null);
        glShaderSource.addArgAttachment(2, sourceArg);
    }

    private static Long getProgramInUse(@NonNull SynchronousTraceStateSnapshot snapshot, int index) {
        snapshot.setSelectedFunction(index);
        GlProgramAsset currentProgram = GlProgramHelper.getCurrentNormalProgramAsset(snapshot);
        if (currentProgram == null) {
            return null;
        }
        return currentProgram.getId();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ProgramOverride.class) {
            return false;
        }
        ProgramOverride that = (ProgramOverride)obj;
        if (that.getOverrideName().equals(this.getOverrideName()) && that.getModifiedAsset().equals(this.getModifiedAsset())) {
            return ComparatorUtils.equalNullables(this.getNewFragmentShader(), that.getNewFragmentShader()) && ComparatorUtils.equalNullables(this.getNewVertexShader(), that.getNewVertexShader());
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.newVertexShader.isDirty() || this.newFragmentShader.isDirty();
    }

    public void setProgram(@NonNull GlProgramAsset newProgram) {
        this.originalProgram = newProgram;
        this.newVertexShader = new SourceProvider(this.originalProgram.getLinkedShader(KapiSpec.GLES.constants.GL_VERTEX_SHADER));
        this.newFragmentShader = new SourceProvider(this.originalProgram.getLinkedShader(KapiSpec.GLES.constants.GL_FRAGMENT_SHADER));
    }

    @Override
    public FrameOverrides.OverrideType getOverrideType() {
        return FrameOverrides.OverrideType.PROGRAM_OVERRIDE;
    }

    public void setProgramMappingId(Long mappingId) {
        this.overrideProgramMappingID = mappingId;
    }

    public void setVertexMappingId(Long mappingId) {
        this.overrideVertexMappingID = mappingId;
    }

    public void setFragmentMappingId(Long mappingId) {
        this.overrideFragmentMappingID = mappingId;
    }

    public Long getProgramMappingId() {
        return this.overrideProgramMappingID;
    }

    public Long getVertexMappingId() {
        return this.overrideVertexMappingID;
    }

    public Long getFragmentMappingId() {
        return this.overrideFragmentMappingID;
    }

    public int hashCode() {
        return this.getOverrideName().hashCode() ^ this.getModifiedAsset().hashCode();
    }

    @Override
    public boolean affectsSameAsset(AbstractFrameOverride override) {
        if (override instanceof ProgramOverride) {
            return ((ProgramOverride)override).getProgram().equals(this.getProgram());
        }
        return false;
    }

    @Override
    public @NonNull AbstractOverrideAttachment asMarshallerObject() {
        return new ProgramOverrideAttachment(this.originalProgram.getId(), (String)NullUtils.neverNull((Object)this.newVertexShader.getSource()), (String)NullUtils.neverNull((Object)this.newFragmentShader.getSource()));
    }

    public class AppliedProgramOverride
    extends AbstractFrameOverride.AbstractAppliedOverride {
        private final long fragmentShaderID;
        private final long programID;
        private final boolean restoreOriginalProgramUse;
        private final long vertexShaderID;
        private final int overrideFrom;

        private AppliedProgramOverride(int overrideFrom, long programID, long fragmentShaderID, long vertexShaderID, boolean restoreOriginalProgramUse) {
            super(ProgramOverride.this);
            this.overrideFrom = overrideFrom;
            this.programID = programID;
            this.fragmentShaderID = fragmentShaderID;
            this.vertexShaderID = vertexShaderID;
            this.restoreOriginalProgramUse = restoreOriginalProgramUse;
        }

        @Override
        public boolean removeOverride(OverriddenFrameData overridenFrameData) {
            Frame originalFrame = overridenFrameData.getOriginalFrame();
            List<FunctionCall> rebuiltFrame = overridenFrameData.getReplayFunctions();
            int size = rebuiltFrame.size();
            int i = this.overrideFrom;
            while (i < size) {
                FunctionCall fc = rebuiltFrame.get(i);
                if (KapiSpec.GLES.functions.GLUSEPROGRAM.equals(fc.getFunctionSpec()) && ProgramOverride.this.originalProgram.getId().equals(GLES.GlUseProgramDecorator.getArgumentProgram(fc))) {
                    rebuiltFrame.set(i, FunctionBuilder.createFunction(originalFrame.getParentModel(), KapiSpec.GLES.functions.GLUSEPROGRAM, FunctionBuilder.args(Long.valueOf(this.programID)), null));
                }
                ++i;
            }
            ArrayList<FunctionCall> functionsToAdd = new ArrayList<FunctionCall>();
            FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLDELETESHADER, FunctionBuilder.args(Long.valueOf(this.fragmentShaderID)), null);
            FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLDELETESHADER, FunctionBuilder.args(Long.valueOf(this.vertexShaderID)), null);
            FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLDELETEPROGRAM, FunctionBuilder.args(Long.valueOf(this.programID)), null);
            if (this.restoreOriginalProgramUse) {
                FunctionBuilder.addFunction(functionsToAdd, originalFrame.getParentModel(), KapiSpec.GLES.functions.GLUSEPROGRAM, FunctionBuilder.args(ProgramOverride.this.originalProgram.getId()), null);
            }
            rebuiltFrame.addAll(functionsToAdd);
            return true;
        }
    }
}

