/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.replay.shader;

import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class PrecisionModeModifier {
    private static final @NonNull Map<@NonNull ESSLVersion, @NonNull String @NonNull []> DEFAULT_PRECISION_QUALIFIERS = Map.of(ESSLVersion.V100, new String[]{"float", "int", "sampler2D", "samplerCube"}, ESSLVersion.V300, new String[]{"float", "int", "sampler2D", "samplerCube", "sampler3D", "samplerCubeShadow", "sampler2DShadow", "sampler2DArray", "sampler2DArrayShadow", "isampler2D", "isampler3D", "isamplerCube", "isampler2DArray", "usampler2D", "usampler3D", "usamplerCube", "usampler2DArray"}, ESSLVersion.V310, new String[]{"float", "int", "sampler2D", "samplerCube", "atomic_uint", "sampler3D", "samplerCubeShadow", "sampler2DShadow", "sampler2DArray", "sampler2DArrayShadow", "sampler2DMS", "isampler2D", "isampler3D", "isamplerCube", "isampler2DArray", "isampler2DMS", "usampler2D", "usampler3D", "usamplerCube", "usampler2DArray", "usampler2DMS", "image2D", "image3D", "imageCube", "image2DArray", "iimage2D", "iimage3D", "iimageCube", "iimage2DArray", "uimage2D", "uimage3D", "uimageCube", "uimage2DArray"});
    private @NonNull PrecisionModes precisionMode;
    private @NonNull String shaderSource;

    public PrecisionModeModifier(@NonNull String shaderSource, @NonNull PrecisionModes precisionMode) {
        this.shaderSource = shaderSource;
        this.precisionMode = precisionMode;
    }

    public @NonNull String process() {
        this.stripWhiteSpace();
        this.mergeEscapedLines();
        this.stripComments();
        this.removeDefaultQualifiers();
        this.insertDefaultQualifiers();
        this.replaceAllQualifiers();
        this.stripWhiteSpace();
        return (String)NullUtils.neverNull((Object)this.shaderSource.replaceAll(" +\\n", "\n"));
    }

    private String[] findFirstLineAfterVersion() {
        int result = this.shaderSource.indexOf("#version");
        if (result < 0) {
            return new String[]{"", this.shaderSource};
        }
        if ((result = this.shaderSource.indexOf(10, result)) < 0) {
            return new String[]{String.valueOf(this.shaderSource) + "\n", ""};
        }
        return new String[]{this.shaderSource.substring(0, result + 1), this.shaderSource.substring(result + 1)};
    }

    private void insertDefaultQualifiers() {
        ESSLVersion version = this.detectESSLVersion();
        String[] insertionPoint = this.findFirstLineAfterVersion();
        String insertText = this.createPrecisionSpecifiers(version);
        StringBuilder builder = new StringBuilder();
        builder.append(insertionPoint[0]).append(insertText).append(insertionPoint[1]);
        this.shaderSource = (String)NullUtils.neverNull((Object)builder.toString());
    }

    private String createPrecisionSpecifiers(@NonNull ESSLVersion version) {
        @NonNull String @NonNull [] types = (String[])NullUtils.neverNull((Object[])DEFAULT_PRECISION_QUALIFIERS.get((Object)version));
        return Arrays.stream(types).map(type -> String.format("precision %s %s;\n", this.precisionMode.modeString, type)).collect(Collectors.joining());
    }

    private @NonNull ESSLVersion detectESSLVersion() {
        Pattern pattern = Pattern.compile("#version ([0-9]+)");
        Matcher matcher = pattern.matcher(this.shaderSource);
        if (matcher.find()) {
            @NonNull String number = (String)NullUtils.neverNull((Object)matcher.group(1));
            if (number.equals("300")) {
                return ESSLVersion.V300;
            }
            if (number.equals("310")) {
                return ESSLVersion.V310;
            }
        }
        return ESSLVersion.V100;
    }

    private void mergeEscapedLines() {
        String[] lines;
        StringBuilder builder = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        String[] stringArray = lines = this.shaderSource.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.matches("^(.*[^\\\\])?\\\\$")) {
                lineBuilder.append(line.substring(0, line.length() - 1));
            } else {
                lineBuilder.append(line);
                builder.append(lineBuilder.toString().trim()).append("\n");
                lineBuilder = new StringBuilder();
            }
            ++n2;
        }
        if (lineBuilder.length() > 0) {
            builder.append(lineBuilder.toString().trim()).append("\n");
        }
        this.shaderSource = (String)NullUtils.neverNull((Object)builder.toString().replaceAll("\\n+", "\n"));
    }

    private void removeDefaultQualifiers() {
        this.shaderSource = (String)NullUtils.neverNull((Object)this.shaderSource.replaceAll("precision[ \\n]+([0-9A-Za-z_]+)[ \\n]+([0-9A-Za-z_]+)[ \\n]*;", ""));
    }

    private void replaceAllQualifiers() {
        PrecisionModes[] precisionModesArray = PrecisionModes.values();
        int n = precisionModesArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrecisionModes pm = precisionModesArray[n2];
            if (pm != this.precisionMode) {
                this.shaderSource = (String)NullUtils.neverNull((Object)this.shaderSource.replaceAll("([^0-9A-Za-z_])(" + pm.modeString + ")([^0-9A-Za-z_])", "$1" + this.precisionMode.modeString + "$3"));
            }
            ++n2;
        }
    }

    private void stripComments() {
        int start;
        int from = 0;
        while ((start = this.shaderSource.indexOf("/*", from)) >= 0) {
            int end = this.shaderSource.indexOf("*/", start + 2);
            end = end < 0 ? this.shaderSource.length() : (end += 2);
            this.shaderSource = String.valueOf(this.shaderSource.substring(0, start)) + this.shaderSource.substring(end);
            from = start;
        }
        this.shaderSource = (String)NullUtils.neverNull((Object)this.shaderSource.replaceAll("[ \\n]*//[^\\n]*\\n", "\n"));
    }

    private void stripWhiteSpace() {
        this.shaderSource = (String)NullUtils.neverNull((Object)this.shaderSource.replaceAll("[\\n\\r]+", "\n").replaceAll("[ \\t\\u0006\\u0016]+", " "));
    }

    private static enum ESSLVersion {
        V100,
        V300,
        V310;

    }

    public static enum PrecisionModes {
        LOWP("lowp"),
        MEDIUMP("mediump"),
        HIGHP("highp");

        public final @NonNull String modeString;

        private PrecisionModes(String modeString) {
            this.modeString = modeString;
        }
    }
}

