/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.replay.shader;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.replay.shader.PrecisionModeModifier;
import com.arm.mgd.core.replay.shader.ProgramOverride;
import com.arm.mgd.core.target.data.AbstractOverrideAttachment;
import com.arm.mgd.core.target.data.ForcePrecisionModeOverrideAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import org.eclipse.jdt.annotation.NonNull;

public class ForcePrecisionModeOverride
extends ProgramOverride {
    public static final String ANALYTICS_ID = "forceprecision";
    private @NonNull PrecisionModeModifier.PrecisionModes precisionMode;

    private static @NonNull String replaceShaderSource(@NonNull PrecisionModeModifier.PrecisionModes precisionMode, @NonNull GlProgramAsset program, @NonNull AbstractConstantOrAliasSpecExtended shaderEnum) {
        GlShaderAsset shaderAsset = program.getLinkedShader(shaderEnum);
        if (shaderAsset == null) {
            throw new NullPointerException("Cannot replace shader source if shader is missing");
        }
        String source = shaderAsset.getSource();
        if (source == null) {
            throw new NullPointerException("Cannot replace shader source if source is missing");
        }
        PrecisionModeModifier modifier = new PrecisionModeModifier(source, precisionMode);
        return modifier.process();
    }

    public ForcePrecisionModeOverride(@NonNull GlProgramAsset program, @NonNull PrecisionModeModifier.PrecisionModes precisionMode) {
        super(program);
        this.precisionMode = precisionMode;
        this.setSources(precisionMode);
    }

    public ForcePrecisionModeOverride(long programId, @NonNull PrecisionModeModifier.PrecisionModes precisionMode, @NonNull TraceStateSnapshot currentSnapshot) {
        super(programId, currentSnapshot);
        this.precisionMode = precisionMode;
        this.setSources(precisionMode);
    }

    private void setSources(@NonNull PrecisionModeModifier.PrecisionModes precisionMode) {
        super.getNewVertexShader().setSource(ForcePrecisionModeOverride.replaceShaderSource(precisionMode, this.originalProgram, KapiSpec.GLES.constants.GL_VERTEX_SHADER));
        super.getNewFragmentShader().setSource(ForcePrecisionModeOverride.replaceShaderSource(precisionMode, this.originalProgram, KapiSpec.GLES.constants.GL_FRAGMENT_SHADER));
    }

    @Override
    public String getOverrideName() {
        return "Force precision mode (" + this.precisionMode.modeString + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ForcePrecisionModeOverride.class) {
            return false;
        }
        ForcePrecisionModeOverride that = (ForcePrecisionModeOverride)obj;
        if (that.getModifiedAsset().equals(this.getModifiedAsset())) {
            return this.getPrecisionMode().equals((Object)that.getPrecisionMode());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getModifiedAsset().hashCode();
    }

    public PrecisionModeModifier.PrecisionModes getPrecisionMode() {
        return this.precisionMode;
    }

    public void setPrecisionMode(@NonNull PrecisionModeModifier.PrecisionModes newPrecisionMode) {
        this.precisionMode = newPrecisionMode;
    }

    @Override
    public FrameOverrides.OverrideType getOverrideType() {
        return FrameOverrides.OverrideType.FORCE_PRECISION_OVERRIDE;
    }

    @Override
    public @NonNull AbstractOverrideAttachment asMarshallerObject() {
        return new ForcePrecisionModeOverrideAttachment(this.getProgram().getId(), this.precisionMode);
    }
}

