/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.replay;

import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class FreeAssetAllocator {
    private final @NonNull TraceDataModel model;
    private final @NonNull Map<AssetTableSpec, Long> allocatedIDMap = new HashMap<AssetTableSpec, Long>();

    public FreeAssetAllocator(@NonNull TraceDataModel model) {
        this.model = model;
    }

    public @NonNull List<@NonNull Long> find(AssetTableSpec assetType, int numberRequired) {
        assert (numberRequired > 0) : "numberRequired must be > 0";
        assert (assetType.isCacheMaxID()) : "AssetTableSpec.isCachedMaxID must be true";
        Long lastAllocatedID = this.allocatedIDMap.get(assetType);
        if (lastAllocatedID == null && (lastAllocatedID = this.model.getMaximumAssetID(assetType)) == null) {
            lastAllocatedID = 0L;
        }
        long newID = lastAllocatedID + 1L;
        ArrayList<@NonNull Long> result = new ArrayList<Long>();
        while (numberRequired > 0 && newID < Integer.MAX_VALUE) {
            Long longObj = NullUtils.longValueOf((long)newID);
            result.add(longObj);
            this.allocatedIDMap.put(assetType, longObj);
            ++newID;
            --numberRequired;
        }
        return result;
    }
}

