/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.replay;

import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.OverridesChangedListener;
import com.arm.mgd.core.replay.shader.ForcePrecisionModeOverride;
import com.arm.mgd.core.replay.shader.ProgramOverride;
import com.arm.mgd.core.replay.texture.TextureOverride;
import com.arm.mgd.core.util.CoreLogging;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FrameOverrides
implements Iterable<AbstractFrameOverride> {
    private final ArrayList<@NonNull AbstractFrameOverride> currentFrameOverrides = new ArrayList();
    private final ArrayList<@NonNull OverridesChangedListener> frameOverridesListeners = new ArrayList();

    public void add(@NonNull AbstractFrameOverride abstractFrameOverride) {
        if (!this.currentFrameOverrides.contains(abstractFrameOverride)) {
            this.currentFrameOverrides.add(abstractFrameOverride);
            this.fireChangedEvent();
        }
    }

    public void remove(@NonNull AbstractFrameOverride abstractFrameOverride) {
        if (this.currentFrameOverrides.remove(abstractFrameOverride)) {
            this.fireChangedEvent();
        }
    }

    public void remove(@NonNull OverrideType overrideType, @NonNull IAssetItem asset) {
        AbstractFrameOverride afo = this.get(overrideType, asset);
        if (afo != null) {
            this.remove(afo);
        }
    }

    private void fireChangedEvent() {
        for (OverridesChangedListener listener : this.frameOverridesListeners) {
            listener.onOverridesChanged();
        }
    }

    public boolean isEmpty() {
        return this.currentFrameOverrides.isEmpty();
    }

    public int size() {
        return this.currentFrameOverrides.size();
    }

    @Override
    public Iterator<@NonNull AbstractFrameOverride> iterator() {
        return this.currentFrameOverrides.iterator();
    }

    public Object[] toArray() {
        return this.currentFrameOverrides.toArray();
    }

    public void addOverridesChangedListener(@NonNull OverridesChangedListener overridesChangedListener) {
        this.frameOverridesListeners.add(overridesChangedListener);
    }

    public void removeOverridesChangedListener(@NonNull OverridesChangedListener overridesChangedListener) {
        this.frameOverridesListeners.remove(overridesChangedListener);
    }

    public void clear() {
        if (!this.currentFrameOverrides.isEmpty()) {
            this.currentFrameOverrides.clear();
            this.fireChangedEvent();
        }
    }

    public boolean contains(AbstractFrameOverride override) {
        return this.currentFrameOverrides.contains(override);
    }

    public boolean containsSimilar(AbstractFrameOverride override) {
        for (AbstractFrameOverride listItem : this.currentFrameOverrides) {
            if (!listItem.affectsSameAsset(override)) continue;
            return true;
        }
        return false;
    }

    public void refresh() {
        this.fireChangedEvent();
    }

    public boolean areOverridesDirty() {
        for (AbstractFrameOverride afo : this.currentFrameOverrides) {
            if (!afo.isDirty()) continue;
            return true;
        }
        return false;
    }

    public @Nullable AbstractFrameOverride get(@NonNull OverrideType overrideType, @NonNull IAssetItem asset) {
        block5: for (AbstractFrameOverride afo : this.currentFrameOverrides) {
            switch (overrideType) {
                case FORCE_PRECISION_OVERRIDE: {
                    ForcePrecisionModeOverride fpmo;
                    if (!(afo instanceof ForcePrecisionModeOverride) || !(fpmo = (ForcePrecisionModeOverride)afo).getProgram().equals(asset)) continue block5;
                    return fpmo;
                }
                case PROGRAM_OVERRIDE: {
                    ProgramOverride po;
                    if (!(afo instanceof ProgramOverride) || afo instanceof ForcePrecisionModeOverride || !(po = (ProgramOverride)afo).getProgram().equals(asset)) continue block5;
                    return po;
                }
                case TEXTURE_OVERRIDE: {
                    if (!(afo instanceof TextureOverride)) continue block5;
                    TextureOverride to = (TextureOverride)afo;
                    GlTextureAsset ta = (GlTextureAsset)asset;
                    if (!ta.getId().equals(to.getTextureToReplace())) continue block5;
                    return to;
                }
                default: {
                    CoreLogging.severe(null, "Tried to find unknown override type in frame overrides list");
                }
            }
        }
        return null;
    }

    public @NonNull List<@NonNull AbstractFrameOverride> get(@NonNull OverrideType overrideType) {
        ArrayList<@NonNull AbstractFrameOverride> matchingOverrides = new ArrayList<AbstractFrameOverride>();
        for (AbstractFrameOverride afo : this.currentFrameOverrides) {
            if (!afo.getOverrideType().equals((Object)overrideType)) continue;
            matchingOverrides.add(afo);
        }
        return matchingOverrides;
    }

    public boolean contains(@NonNull OverrideType overrideType, @NonNull IAssetItem asset) {
        return this.get(overrideType, asset) != null;
    }

    public static enum OverrideType {
        TEXTURE_OVERRIDE,
        PROGRAM_OVERRIDE,
        FORCE_PRECISION_OVERRIDE;

    }
}

