/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.renderpassdependencies;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentBinding;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramHelper;
import com.arm.mgd.core.asset.GlRenderbufferAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureUnitAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.IGlFramebufferAttachment;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.renderpassdependencies.RenderPassBlitDependency;
import com.arm.mgd.core.renderpassdependencies.RenderPassDependency;
import com.arm.mgd.core.renderpassdependencies.RenderPassDependencySet;
import com.arm.mgd.core.renderpassdependencies.RenderPassRenderbufferDependency;
import com.arm.mgd.core.renderpassdependencies.RenderPassTextureDependency;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.AttachmentClearStatus;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.CompletableProgressFuture;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;

public class DependencyAnalyserTask
implements Runnable {
    private static Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull AbstractConstantOrAliasSpecExtended> VALID_2D_SAMPLER_TYPES = new HashMap<AbstractConstantOrAliasSpecExtended, AbstractConstantOrAliasSpecExtended>(){
        {
            this.put(KapiSpec.GLES.constants.GL_SAMPLER_2D, KapiSpec.GLES.constants.GL_TEXTURE_2D);
            this.put(KapiSpec.GLES.constants.GL_SAMPLER_2D_MULTISAMPLE, KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_X, KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_X, KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_Y, KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_Z, KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP);
        }
    };
    private final @NonNull TraceDataModel model;
    private final @NonNull Frame frame;
    private final CompletableProgressFuture<List<RenderPassDependencySet>> future = new CompletableProgressFuture();

    public DependencyAnalyserTask(@NonNull TraceDataModel model, @NonNull Frame frame) {
        this.model = model;
        this.frame = frame;
    }

    private static @NonNull Set<Long> getTexturesUsedByProgram(@NonNull Collection<GlProgramAsset> programAssets, @NonNull TraceStateSnapshot snapshot, Long framebufferId) {
        ArrayList uniforms = new ArrayList();
        for (GlProgramAsset program : programAssets) {
            uniforms.addAll(program.getUniformsContainer().getAllVariables());
        }
        AssetTable textureUnitAssetTable = snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS.SPEC);
        TreeSet<Long> texturesRequired = new TreeSet<Long>();
        for (ShaderUniform shaderUniform : uniforms) {
            if (!VALID_2D_SAMPLER_TYPES.containsKey(shaderUniform.getType())) continue;
            int i = 0;
            while (i < shaderUniform.getArrayLength()) {
                AbstractConstantOrAliasSpecExtended targetConstant;
                GlTextureUnitAsset textureUnit;
                GlTextureAsset targetTexture;
                Long textureUnitId = shaderUniform.getValue(i)[0].longValue();
                IAssetItem unitAssetObject = textureUnitAssetTable.get(textureUnitId);
                if (unitAssetObject != null && unitAssetObject instanceof GlTextureUnitAsset && (targetTexture = (textureUnit = (GlTextureUnitAsset)unitAssetObject).getTextureTargets(targetConstant = VALID_2D_SAMPLER_TYPES.get(shaderUniform.getType()))) != null) {
                    texturesRequired.add(targetTexture.getId());
                }
                ++i;
            }
        }
        GlFramebufferAsset currentFramebuffer = (GlFramebufferAsset)snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS.SPEC).get(framebufferId);
        if (currentFramebuffer != null) {
            List<GlFramebufferAttachmentBinding> frameBindings = currentFramebuffer.getAttachmentBindings();
            for (GlFramebufferAttachmentBinding frameBinding : frameBindings) {
                IAssetItem potentialTextureAsset = frameBinding.getAsset().getAsset();
                if (!(potentialTextureAsset instanceof GlTextureAsset)) continue;
                texturesRequired.add(potentialTextureAsset.getId());
            }
        }
        return texturesRequired;
    }

    private RenderPassDependency findDependencies(FrameRenderPass currentRenderPass, IGlFramebufferAttachment dependencyToFind) {
        assert (this.model != null);
        assert (!this.model.isClosed());
        IGlFramebufferAttachment dependencyAttachment = dependencyToFind;
        SynchronousTraceStateSnapshot currentSnapshot = new SynchronousTraceStateSnapshot(this.model);
        int currentFrameIndex = currentRenderPass.getFrame().getId();
        while (currentFrameIndex >= 0) {
            if (this.future != null && this.future.isCancelled()) {
                return null;
            }
            Frame currentFrame = this.model.getFrames().getFrameAt(currentFrameIndex);
            List<FrameRenderPass> arrayOfRenderPass = currentFrame.getRenderPassList();
            int currentRenderPassIndex = arrayOfRenderPass.size() - 1;
            while (currentRenderPassIndex >= 0) {
                Set<AbstractConstantOrAliasSpecExtended> attachments;
                if (this.future != null && this.future.isCancelled()) {
                    return null;
                }
                FrameRenderPass frameRenderPass = arrayOfRenderPass.get(currentRenderPassIndex);
                FunctionCall previousModificationFunction = dependencyAttachment.getPreviousModificationFunction();
                if (previousModificationFunction == null) {
                    previousModificationFunction = dependencyAttachment.getCreatedByFunction();
                }
                if (frameRenderPass.getFirstInterestingCallFunctionIndex() < previousModificationFunction.getIndex()) {
                    currentSnapshot.setSelectedFunction(Math.max(0, previousModificationFunction.getIndex() - 1));
                    dependencyAttachment = (IGlFramebufferAttachment)currentSnapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC).get(dependencyAttachment.getId());
                }
                if (!(frameRenderPass.getFrame().equals(currentRenderPass.getFrame()) && frameRenderPass.compareTo(currentRenderPass) >= 0 || (attachments = dependencyAttachment.getFramebuffersAttachedTo().get(frameRenderPass.getFramebufferId())) == null)) {
                    for (AbstractConstantOrAliasSpecExtended attachment : attachments) {
                        List<DrawFunctionCall> drawCalls;
                        if (this.future != null && this.future.isCancelled()) {
                            return null;
                        }
                        if (attachment.equals(KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT)) {
                            drawCalls = frameRenderPass.getDrawCalls();
                            for (DrawFunctionCall drawCall : drawCalls) {
                                if (this.future != null && this.future.isCancelled()) {
                                    return null;
                                }
                                if (!drawCall.isDepthTestEnabled()) continue;
                                if (dependencyAttachment instanceof GlTextureAsset) {
                                    return new RenderPassTextureDependency(frameRenderPass, dependencyAttachment.getId(), currentFrameIndex);
                                }
                                if (!(dependencyAttachment instanceof GlRenderbufferAsset)) continue;
                                return new RenderPassRenderbufferDependency(frameRenderPass, dependencyAttachment.getId(), currentFrameIndex);
                            }
                            continue;
                        }
                        if (attachment.equals(KapiSpec.GLES.constants.GL_STENCIL_ATTACHMENT)) {
                            drawCalls = frameRenderPass.getDrawCalls();
                            for (DrawFunctionCall drawCall : drawCalls) {
                                if (this.future != null && this.future.isCancelled()) {
                                    return null;
                                }
                                if (!drawCall.isStencilTestEnabled()) continue;
                                if (dependencyAttachment instanceof GlTextureAsset) {
                                    return new RenderPassTextureDependency(frameRenderPass, dependencyAttachment.getId(), currentFrameIndex);
                                }
                                if (!(dependencyAttachment instanceof GlRenderbufferAsset)) continue;
                                return new RenderPassRenderbufferDependency(frameRenderPass, dependencyAttachment.getId(), currentFrameIndex);
                            }
                            continue;
                        }
                        if (frameRenderPass.getDrawCallCount() == 0) continue;
                        if (dependencyAttachment instanceof GlTextureAsset) {
                            return new RenderPassTextureDependency(frameRenderPass, dependencyAttachment.getId(), currentFrameIndex);
                        }
                        if (!(dependencyAttachment instanceof GlRenderbufferAsset)) continue;
                        return new RenderPassRenderbufferDependency(frameRenderPass, dependencyAttachment.getId(), currentFrameIndex);
                    }
                }
                --currentRenderPassIndex;
            }
            --currentFrameIndex;
        }
        return null;
    }

    private List<RenderPassDependencySet> analyse() {
        ArrayList<RenderPassDependencySet> renderDependencies = new ArrayList<RenderPassDependencySet>();
        SynchronousTraceStateSnapshot snapshot = new SynchronousTraceStateSnapshot(this.model);
        List<FrameRenderPass> renderPassList = this.frame.getRenderPassList();
        int workTotal = 0;
        for (FrameRenderPass frp : renderPassList) {
            workTotal += frp.getDrawCallCount();
        }
        this.future.setTask("Dependency Analysis for Frame " + this.frame.getId(), workTotal);
        for (FrameRenderPass renderPassToExamine : renderPassList) {
            if (this.future != null && this.future.isCancelled()) {
                return null;
            }
            AttachmentClearStatus clearStatus = new AttachmentClearStatus();
            if (renderPassToExamine == null) continue;
            HashSet<RenderPassDependency> foundRenderPassDependencies = new HashSet<RenderPassDependency>();
            Set<Object> texturesRequired = new TreeSet();
            for (DrawFunctionCall drawCallToExamine : renderPassToExamine.getDrawCalls()) {
                this.future.incProgress(1);
                if (this.future.isCancelled()) {
                    return null;
                }
                snapshot.setSelectedFunction(drawCallToExamine.getIndex());
                Long framebufferId = renderPassToExamine.getFramebufferId();
                GlFramebufferAsset currentFramebuffer = (GlFramebufferAsset)snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS.SPEC).get(framebufferId);
                if (currentFramebuffer == null) {
                    return null;
                }
                if (drawCallToExamine.getFunctionSpec().equals(KapiSpec.GLES.functions.GLCLEAR)) {
                    DependencyAnalyserTask.setClearStatus(clearStatus, drawCallToExamine, currentFramebuffer.getDrawBuffersCollection());
                    continue;
                }
                if (drawCallToExamine.getFunctionSpec().equals(KapiSpec.GLES.functions.GLCLEARBUFFERIV) || drawCallToExamine.getFunctionSpec().equals(KapiSpec.GLES.functions.GLCLEARBUFFERUIV) || drawCallToExamine.getFunctionSpec().equals(KapiSpec.GLES.functions.GLCLEARBUFFERFV) || drawCallToExamine.getFunctionSpec().equals(KapiSpec.GLES.functions.GLCLEARBUFFERFI)) {
                    DependencyAnalyserTask.setClearBufferStatus(clearStatus, drawCallToExamine, currentFramebuffer.getId());
                    continue;
                }
                if (drawCallToExamine.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBLITFRAMEBUFFER)) {
                    List<GlFramebufferAttachmentBinding> writeAttachments = currentFramebuffer.getAttachmentBindings();
                    ArrayList<IAssetItem> clearedBufferAttachments = new ArrayList<IAssetItem>();
                    for (GlFramebufferAttachmentBinding glFramebufferAttachmentBinding : writeAttachments) {
                        if (clearStatus.isCleared(glFramebufferAttachmentBinding.getAttachment())) continue;
                        clearedBufferAttachments.add(glFramebufferAttachmentBinding.getAsset().getAsset());
                    }
                    RenderPassBlitDependency renderPassBlitDependency = this.blitFramebufferDependencyAnalysis(snapshot, renderPassToExamine, drawCallToExamine, clearedBufferAttachments);
                    if (renderPassBlitDependency == null) continue;
                    foundRenderPassDependencies.add(renderPassBlitDependency);
                    continue;
                }
                @NonNull Collection<GlProgramAsset> programAssets = GlProgramHelper.getCurrentProgramAssets(snapshot);
                AssetTable textureAssetTable = snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC);
                texturesRequired = DependencyAnalyserTask.getTexturesUsedByProgram(programAssets, snapshot, framebufferId);
                for (Long l : texturesRequired) {
                    RenderPassDependency newDependency;
                    IAssetItem asset = textureAssetTable.get(l);
                    GlTextureAsset potentialReadTexture = (GlTextureAsset)asset;
                    if (potentialReadTexture == null || DependencyAnalyserTask.hasReadColourTextureBeenCleared(currentFramebuffer, potentialReadTexture, clearStatus) || DependencyAnalyserTask.hasReadDepthStencilTextureBeenCleared(KapiSpec.GLES.constants.GL_STENCIL_ATTACHMENT, currentFramebuffer, potentialReadTexture, clearStatus) || DependencyAnalyserTask.hasReadDepthStencilTextureBeenCleared(KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT, currentFramebuffer, potentialReadTexture, clearStatus) || !potentialReadTexture.isEverBoundToFramebuffer() || (newDependency = this.findDependencies(renderPassToExamine, potentialReadTexture)) == null) continue;
                    foundRenderPassDependencies.add(newDependency);
                }
                List<GlFramebufferAttachmentBinding> list = currentFramebuffer.getAttachmentBindings();
                for (GlFramebufferAttachmentBinding frameBinding : list) {
                    GlRenderbufferAsset currentRenderbuffer;
                    RenderPassDependency newDependency;
                    IAssetItem potentialRenderbuffer;
                    if (this.future != null && this.future.isCancelled()) {
                        return null;
                    }
                    if (clearStatus.isCleared(frameBinding.getAttachment()) || !((potentialRenderbuffer = frameBinding.getAsset().getAsset()) instanceof GlRenderbufferAsset) || (newDependency = this.findDependencies(renderPassToExamine, currentRenderbuffer = (GlRenderbufferAsset)potentialRenderbuffer)) == null) continue;
                    foundRenderPassDependencies.add(newDependency);
                }
            }
            if (foundRenderPassDependencies.isEmpty()) continue;
            renderDependencies.add(new RenderPassDependencySet(renderPassToExamine, foundRenderPassDependencies));
        }
        return renderDependencies;
    }

    private static void setClearStatus(@NonNull AttachmentClearStatus clearStatus, @NonNull DrawFunctionCall drawCallToExamine, @NonNull List<AbstractConstantOrAliasSpecExtended> drawBuffersActive) {
        Bitfield clearBits = GLES.GlClearDecorator.getArgumentMask(drawCallToExamine);
        if (clearBits.contains(KapiSpec.GLES.constants.GL_COLOR_BUFFER_BIT)) {
            clearStatus.addColourAttachmentsCleared(drawBuffersActive);
        }
        if (clearBits.contains(KapiSpec.GLES.constants.GL_DEPTH_BUFFER_BIT)) {
            clearStatus.setDepthCleared();
        }
        if (clearBits.contains(KapiSpec.GLES.constants.GL_STENCIL_BUFFER_BIT)) {
            clearStatus.setStencilCleared();
        }
    }

    private static void setClearBufferStatus(@NonNull AttachmentClearStatus clearStatus, @NonNull DrawFunctionCall drawCallToExamine, @NonNull Long attachmentId) {
        Integer drawBuffer;
        AbstractConstantOrAliasSpecExtended buffer;
        IFunctionOrAliasSpecExtended functionSpec = drawCallToExamine.getFunctionSpec();
        if (functionSpec.equals(KapiSpec.GLES.functions.GLCLEARBUFFERIV)) {
            buffer = GLES.GlClearBufferivDecorator.getArgumentBuffer(drawCallToExamine);
            drawBuffer = GLES.GlClearBufferivDecorator.getArgumentDrawbuffer(drawCallToExamine);
        } else if (functionSpec.equals(KapiSpec.GLES.functions.GLCLEARBUFFERUIV)) {
            buffer = GLES.GlClearBufferuivDecorator.getArgumentBuffer(drawCallToExamine);
            drawBuffer = GLES.GlClearBufferuivDecorator.getArgumentDrawbuffer(drawCallToExamine);
        } else if (functionSpec.equals(KapiSpec.GLES.functions.GLCLEARBUFFERFV)) {
            buffer = GLES.GlClearBufferfvDecorator.getArgumentBuffer(drawCallToExamine);
            drawBuffer = GLES.GlClearBufferfvDecorator.getArgumentDrawbuffer(drawCallToExamine);
        } else if (functionSpec.equals(KapiSpec.GLES.functions.GLCLEARBUFFERFI)) {
            buffer = GLES.GlClearBufferfiDecorator.getArgumentBuffer(drawCallToExamine);
            drawBuffer = GLES.GlClearBufferfiDecorator.getArgumentDrawbuffer(drawCallToExamine);
        } else {
            assert (false) : "Unknown glClearBuffer* function: " + functionSpec.getName();
            return;
        }
        if (buffer.equals(KapiSpec.GLES.constants.GL_COLOR)) {
            clearStatus.addDrawBufferCleared(drawBuffer, attachmentId);
        } else if (buffer.equals(KapiSpec.GLES.constants.GL_DEPTH)) {
            clearStatus.setDepthCleared();
        } else if (buffer.equals(KapiSpec.GLES.constants.GL_STENCIL)) {
            clearStatus.setStencilCleared();
        }
    }

    private RenderPassBlitDependency blitFramebufferDependencyAnalysis(@NonNull TraceStateSnapshot snapshot, @NonNull FrameRenderPass framePassToExamine, @NonNull DrawFunctionCall drawCallToExamine, @NonNull List<IAssetItem> clearedBufferAttachments) {
        StateItem currentReadFramebufferTexture = snapshot.getStateItemBySpec(KapiSpec.GLES.states.GL_READ_FRAMEBUFFER_BINDING);
        IAssetItem possibleFramebuffer = currentReadFramebufferTexture.getValueAsAsset();
        if (possibleFramebuffer != null && possibleFramebuffer instanceof GlFramebufferAsset) {
            GlFramebufferAsset framebufferToMatch = (GlFramebufferAsset)possibleFramebuffer;
            int currentFrameIndex = framePassToExamine.getFrame().getId();
            while (currentFrameIndex >= 0) {
                Frame currentFrame = this.model.getFrames().getFrameAt(currentFrameIndex);
                List<FrameRenderPass> arrayOfRenderPass = currentFrame.getRenderPassList();
                int currentRenderPassIndex = arrayOfRenderPass.size() - 1;
                while (currentRenderPassIndex >= 0) {
                    FrameRenderPass currentFrameRenderPass = arrayOfRenderPass.get(currentRenderPassIndex);
                    if ((!currentFrameRenderPass.getFrame().equals(framePassToExamine.getFrame()) || currentFrameRenderPass.compareTo(framePassToExamine) < 0) && currentFrameRenderPass.getFramebufferId().equals(framebufferToMatch.getId())) {
                        GlFramebufferAsset readFramebuffer = framebufferToMatch;
                        List<GlFramebufferAttachmentBinding> readAttachments = readFramebuffer.getAttachmentBindings();
                        for (GlFramebufferAttachmentBinding readAttachment : readAttachments) {
                            if (readAttachment.getAttachment().equals(KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT) && !GLES.GlBlitFramebufferDecorator.getArgumentMask(drawCallToExamine).contains(KapiSpec.GLES.constants.GL_DEPTH_BUFFER_BIT) || readAttachment.getAttachment().equals(KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT) && !GLES.GlBlitFramebufferDecorator.getArgumentMask(drawCallToExamine).contains(KapiSpec.GLES.constants.GL_DEPTH_BUFFER_BIT) || clearedBufferAttachments.contains(readAttachment.getAsset().getAsset())) continue;
                            return new RenderPassBlitDependency(currentFrameRenderPass, readFramebuffer.getId(), currentFrameRenderPass.getFrame().getId());
                        }
                    }
                    --currentRenderPassIndex;
                }
                --currentFrameIndex;
            }
        }
        return null;
    }

    public CompletableProgressFuture<List<RenderPassDependencySet>> getFuture() {
        return this.future;
    }

    @Override
    public void run() {
        List<RenderPassDependencySet> dependencies = this.analyse();
        this.future.complete(dependencies);
    }

    private static boolean hasReadDepthStencilTextureBeenCleared(@NonNull AbstractConstantOrAliasSpecExtended attachmentSpec, @NonNull GlFramebufferAsset currentFramebuffer, GlTextureAsset potentialReadTexture, @NonNull AttachmentClearStatus clearStatus) {
        GlTextureAsset oldTexture;
        IAssetItem possibleTexture;
        if (!clearStatus.isCleared(attachmentSpec)) {
            return false;
        }
        GlFramebufferAttachmentBinding attachmentBinding = currentFramebuffer.getAttachmentBinding(attachmentSpec);
        return attachmentBinding != null && (possibleTexture = attachmentBinding.getAsset().getAsset()) instanceof GlTextureAsset && (oldTexture = (GlTextureAsset)possibleTexture).getId() == potentialReadTexture.getId();
    }

    private static boolean hasReadColourTextureBeenCleared(@NonNull GlFramebufferAsset currentFramebuffer, @NonNull GlTextureAsset potentialReadTexture, @NonNull AttachmentClearStatus clearStatus) {
        for (GlFramebufferAttachmentBinding currentAttachment : currentFramebuffer.getAttachmentBindings()) {
            GlTextureAsset potentialWriteTexture;
            IAssetItem possibleTexture;
            if (!clearStatus.isCleared(currentAttachment.getAttachment()) || !((possibleTexture = currentAttachment.getAsset().getAsset()) instanceof GlTextureAsset) || (potentialWriteTexture = (GlTextureAsset)possibleTexture).getId() != potentialReadTexture.getId()) continue;
            return true;
        }
        return false;
    }
}

