/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.offlinecompiler;

import com.arm.compilermanager.Outputs;
import com.arm.mgd.core.offlinecompiler.GlShaderCompiler;
import com.arm.mgd.core.offlinecompiler.GlShaderStatType;
import com.arm.mgd.core.offlinecompiler.GlShaderStats;
import com.arm.mgd.core.offlinecompiler.IGlStatistic;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class UtgardShaderCompiler
extends GlShaderCompiler {
    @Override
    public IGlStatistic[] getStatistics() {
        return Statistics.values();
    }

    @Override
    protected @NonNull GlShaderStats analyzeStatistics(@NonNull Outputs compilerOutputs) {
        GlShaderStats glShaderStats = new GlShaderStats(){

            @Override
            public @Nullable Number getEstimatedExecutionCycles() {
                return (Integer)this.getStat(Statistics.ESTIMATED_EXECUTION_CYCLES);
            }
        };
        String[][] stringArray = compilerOutputs.getFlexibleOutputs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] flexible_outputs = stringArray[n2];
            int i = 0;
            while (i < flexible_outputs.length) {
                Integer cycles;
                if (flexible_outputs[i].equals("min_number_of_cycles")) {
                    cycles = Integer.valueOf(flexible_outputs[i + 1]);
                    if (!cycles.equals(-1)) {
                        glShaderStats.setStatValue(Statistics.SHORTEST_CODE_PATH, cycles);
                    }
                } else if (flexible_outputs[i].equals("max_number_of_cycles")) {
                    cycles = Integer.valueOf(flexible_outputs[i + 1]);
                    if (!cycles.equals(-1)) {
                        glShaderStats.setStatValue(Statistics.LONGEST_CODE_PATH, cycles);
                    }
                } else if (flexible_outputs[i].equals("n_instruction_words")) {
                    Integer words = Integer.valueOf(flexible_outputs[i + 1]);
                    glShaderStats.setStatValue(Statistics.NUM_INSTRUCTIONS, words);
                }
                i += 2;
            }
            ++n2;
        }
        Object shortestPath = glShaderStats.getStat(Statistics.SHORTEST_CODE_PATH);
        Object longestPath = glShaderStats.getStat(Statistics.LONGEST_CODE_PATH);
        Object numWords = glShaderStats.getStat(Statistics.NUM_INSTRUCTIONS);
        if (shortestPath instanceof Integer && longestPath instanceof Integer) {
            int averagePath = ((Integer)shortestPath + (Integer)longestPath + 1) / 2;
            glShaderStats.setStatValue(Statistics.ESTIMATED_EXECUTION_CYCLES, averagePath);
        } else if (shortestPath instanceof Integer && !(longestPath instanceof Integer)) {
            glShaderStats.setStatValue(Statistics.ESTIMATED_EXECUTION_CYCLES, shortestPath);
        } else if (longestPath instanceof Integer && !(shortestPath instanceof Integer)) {
            glShaderStats.setStatValue(Statistics.ESTIMATED_EXECUTION_CYCLES, longestPath);
        } else if (numWords instanceof Integer) {
            glShaderStats.setStatValue(Statistics.ESTIMATED_EXECUTION_CYCLES, numWords);
        }
        return glShaderStats;
    }

    @Override
    protected String getCoreName() {
        return "Mali-450";
    }

    @Override
    protected String getDriverName() {
        return "Mali-400_r6p1-00rel0";
    }

    @Override
    protected String getCoreRevision() {
        return "r0p0";
    }

    public static enum Statistics implements IGlStatistic
    {
        LONGEST_CODE_PATH(new GlShaderStatType("Longest Code Path", "The number of cycles taken for the longest code path.", true, GlShaderStatType.Type.INTEGER, 2)),
        SHORTEST_CODE_PATH(new GlShaderStatType("Shortest Code Path", "The number of cycles taken for the shortest code path.", true, GlShaderStatType.Type.INTEGER, 1)),
        ESTIMATED_EXECUTION_CYCLES(new GlShaderStatType("Cycles", "The estimated number of cycles this shader will take for one execution.", true, GlShaderStatType.Type.INTEGER, 0)),
        NUM_INSTRUCTIONS(new GlShaderStatType("Instructions", "The total number of instructions emitted.", true, GlShaderStatType.Type.INTEGER, 3));

        private final GlShaderStatType type;

        private Statistics(GlShaderStatType type) {
            this.type = type;
        }

        @Override
        public GlShaderStatType getGlShaderStatType() {
            return this.type;
        }
    }
}

