/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.offlinecompiler;

import com.arm.compilermanager.Compiler;
import com.arm.compilermanager.CompilerManager;
import com.arm.compilermanager.Compilers;
import com.arm.compilermanager.Outputs;
import com.arm.mgd.core.offlinecompiler.GlShaderCompiler;
import com.arm.mgd.core.offlinecompiler.GlShaderStatType;
import com.arm.mgd.core.offlinecompiler.GlShaderStats;
import com.arm.mgd.core.offlinecompiler.IGlStatistic;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MidgardShaderCompiler
extends GlShaderCompiler {
    private static final String PREFERRED_CORE = "Mali-T880";
    private static final String PREFERRED_DRIVER_VERSION = "Mali-T600_r13p0-00rel0";
    private static final String PREFERRED_CORE_REVISION = "r2p0";
    private static final String[] REQUIRED_EXTENSIONS = new String[]{"GL_ANDROID_extension_pack_es31a"};
    private final Compiler defaultCompiler;

    public MidgardShaderCompiler() {
        Compiler bestFitCompiler = MidgardShaderCompiler.findPreferredCompiler(REQUIRED_EXTENSIONS);
        if (bestFitCompiler == null) {
            bestFitCompiler = MidgardShaderCompiler.findPreferredCompiler(null);
        }
        this.defaultCompiler = bestFitCompiler;
        if (this.defaultCompiler != null) {
            CoreLogging.info(null, (String)NullUtils.neverNull((Object)String.format("Using %s %s (%s) for shader compilation.\nMaximum ESSL version: %s.\nSupported extensions: %s.", this.defaultCompiler.getCoreName(), this.defaultCompiler.getCoreRevision(), this.defaultCompiler.getDriverName(), String.valueOf(this.defaultCompiler.getHighestApiVersion()), this.defaultCompiler.getExtensions())));
        } else {
            CoreLogging.warning(null, "Could not find preferred shader compiler driver.");
        }
    }

    private static @Nullable Compiler findPreferredCompiler(String[] requiredExtensions) {
        Compilers compilers = CompilerManager.getCompilers(null, null, null, (String)"openglessl", null, (int)0);
        assert (compilers.size() > 0) : "No ESSL compilers found";
        TreeMap<String, Compiler> tm = new TreeMap<String, Compiler>();
        for (Compiler compiler : compilers) {
            if (requiredExtensions != null && !MidgardShaderCompiler.matchesExtensions(requiredExtensions, compiler)) continue;
            tm.put(String.valueOf(compiler.getCoreName()) + "/" + compiler.getDriverName() + "/" + compiler.getCoreRevision(), compiler);
        }
        if (tm.size() > 0) {
            Compiler result = (Compiler)tm.get("Mali-T880/Mali-T600_r13p0-00rel0/r2p0");
            if (result == null) {
                String preferedCore = "Mali-T880/";
                String preferedCoreDriver = "Mali-T880/Mali-T600_r13p0-00rel0/";
                Compiler firstCoreCompiler = null;
                for (Map.Entry entry : tm.entrySet()) {
                    if (((String)entry.getKey()).startsWith("Mali-T880/Mali-T600_r13p0-00rel0/")) {
                        result = (Compiler)entry.getValue();
                        break;
                    }
                    if (firstCoreCompiler != null || !((String)entry.getKey()).startsWith("Mali-T880/")) continue;
                    firstCoreCompiler = (Compiler)entry.getValue();
                }
                if (result == null) {
                    result = firstCoreCompiler;
                }
                if (result == null) {
                    result = (Compiler)tm.firstEntry().getValue();
                }
            }
            return result;
        }
        return null;
    }

    private static boolean matchesExtensions(String[] requiredExtensions, Compiler compiler) {
        HashSet<String> extensions = new HashSet<String>(Arrays.asList(compiler.getExtensions().split("[ \\t]+")));
        String[] stringArray = requiredExtensions;
        int n = requiredExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredExtension = stringArray[n2];
            if (!extensions.contains(requiredExtension)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public IGlStatistic[] getStatistics() {
        return Statistics.values();
    }

    @Override
    protected @NonNull GlShaderStats analyzeStatistics(@NonNull Outputs compilerOutputs) {
        float estimatedTextureCycles;
        float estimatedLoadStoreCycles;
        GlShaderStats glShaderStats = new GlShaderStats(){

            @Override
            public @Nullable Number getEstimatedExecutionCycles() {
                return (Float)this.getStat(Statistics.ESTIMATED_EXECUTION_CYCLES);
            }
        };
        String[][] stringArray = compilerOutputs.getFlexibleOutputs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] flexible_outputs = stringArray[n2];
            int i = 0;
            while (i < flexible_outputs.length) {
                Float cycles;
                Integer registers;
                if (flexible_outputs[i].equals("work_registers_used")) {
                    registers = Integer.valueOf(flexible_outputs[i + 1]);
                    glShaderStats.setStatValue(Statistics.WORK_REGISTERS, registers);
                } else if (flexible_outputs[i].equals("uniform_registers_used")) {
                    registers = Integer.valueOf(flexible_outputs[i + 1]);
                    glShaderStats.setStatValue(Statistics.UNIFORM_REGISTERS, registers);
                } else if (flexible_outputs[i].equals("arithmetic_cycles")) {
                    cycles = Float.valueOf(flexible_outputs[i + 1]);
                    glShaderStats.setStatValue(Statistics.ARITHMETIC_INSTRUCTIONS_EMITTED, cycles);
                } else if (flexible_outputs[i].equals("load_store_cycles")) {
                    cycles = Float.valueOf(flexible_outputs[i + 1]);
                    glShaderStats.setStatValue(Statistics.LOAD_STORE_INSTRUCTIONS_EMITTED, cycles);
                } else if (flexible_outputs[i].equals("texture_cycles")) {
                    cycles = Float.valueOf(flexible_outputs[i + 1]);
                    glShaderStats.setStatValue(Statistics.TEXTURE_INSTRUCTIONS_EMITTED, cycles);
                } else if (flexible_outputs[i].equals("arithmetic_shortest_path")) {
                    cycles = Float.valueOf(flexible_outputs[i + 1]);
                    if (!cycles.equals(Float.valueOf(-1.0f))) {
                        glShaderStats.setStatValue(Statistics.ARITHMETIC_SHORTEST_PATH, cycles);
                    }
                } else if (flexible_outputs[i].equals("load_store_shortest_path")) {
                    cycles = Float.valueOf(flexible_outputs[i + 1]);
                    if (!cycles.equals(Float.valueOf(-1.0f))) {
                        glShaderStats.setStatValue(Statistics.LOAD_STORE_SHORTEST_PATH, cycles);
                    }
                } else if (flexible_outputs[i].equals("texture_shortest_path")) {
                    cycles = Float.valueOf(flexible_outputs[i + 1]);
                    if (!cycles.equals(Float.valueOf(-1.0f))) {
                        glShaderStats.setStatValue(Statistics.TEXTURE_SHORTEST_PATH, cycles);
                    }
                } else if (flexible_outputs[i].equals("arithmetic_longest_path")) {
                    cycles = Float.valueOf(flexible_outputs[i + 1]);
                    if (!cycles.equals(Float.valueOf(-1.0f))) {
                        glShaderStats.setStatValue(Statistics.ARITHMETIC_LONGEST_PATH, cycles);
                    }
                } else if (flexible_outputs[i].equals("load_store_longest_path")) {
                    cycles = Float.valueOf(flexible_outputs[i + 1]);
                    if (!cycles.equals(Float.valueOf(-1.0f))) {
                        glShaderStats.setStatValue(Statistics.LOAD_STORE_LONGEST_PATH, cycles);
                    }
                } else if (flexible_outputs[i].equals("texture_longest_path")) {
                    cycles = Float.valueOf(flexible_outputs[i + 1]);
                    if (!cycles.equals(Float.valueOf(-1.0f))) {
                        glShaderStats.setStatValue(Statistics.TEXTURE_LONGEST_PATH, cycles);
                    }
                } else if (flexible_outputs[i].equals("spilling_used")) {
                    Boolean spilling = Boolean.valueOf(flexible_outputs[i + 1]);
                    glShaderStats.setStatValue(Statistics.SPILLING_USED, spilling);
                }
                i += 2;
            }
            ++n2;
        }
        Object arithmeticEmitted = glShaderStats.getStat(Statistics.ARITHMETIC_INSTRUCTIONS_EMITTED);
        Object loadStoreEmitted = glShaderStats.getStat(Statistics.LOAD_STORE_INSTRUCTIONS_EMITTED);
        Object textureEmitted = glShaderStats.getStat(Statistics.TEXTURE_INSTRUCTIONS_EMITTED);
        if (arithmeticEmitted instanceof Float && loadStoreEmitted instanceof Float && textureEmitted instanceof Float) {
            Float total = Float.valueOf(((Float)arithmeticEmitted).floatValue() + ((Float)loadStoreEmitted).floatValue() + ((Float)textureEmitted).floatValue());
            glShaderStats.setStatValue(Statistics.TOTAL_INSTRUCTIONS_EMITTED, total);
        }
        Object arithmeticShortest = glShaderStats.getStat(Statistics.ARITHMETIC_SHORTEST_PATH);
        Object loadStoreShortest = glShaderStats.getStat(Statistics.LOAD_STORE_SHORTEST_PATH);
        Object textureShortest = glShaderStats.getStat(Statistics.TEXTURE_SHORTEST_PATH);
        Object arithmeticLongest = glShaderStats.getStat(Statistics.ARITHMETIC_LONGEST_PATH);
        Object loadStoreLongest = glShaderStats.getStat(Statistics.LOAD_STORE_LONGEST_PATH);
        Object textureLongest = glShaderStats.getStat(Statistics.TEXTURE_LONGEST_PATH);
        float estimatedArithCycles = MidgardShaderCompiler.getEstimatedPipeCycles(arithmeticEmitted, arithmeticShortest, arithmeticLongest);
        float longestEstimate = Math.max(estimatedArithCycles, Math.max(estimatedLoadStoreCycles = MidgardShaderCompiler.getEstimatedPipeCycles(loadStoreEmitted, loadStoreShortest, loadStoreLongest), estimatedTextureCycles = MidgardShaderCompiler.getEstimatedPipeCycles(textureEmitted, textureShortest, textureLongest)));
        if (longestEstimate > 0.0f) {
            glShaderStats.setStatValue(Statistics.ESTIMATED_EXECUTION_CYCLES, Float.valueOf(longestEstimate));
        }
        return glShaderStats;
    }

    private static float getEstimatedPipeCycles(@Nullable Object cyclesEmitted, @Nullable Object cyclesShortestPath, @Nullable Object cyclesLongestPath) {
        if (cyclesShortestPath instanceof Float && cyclesLongestPath instanceof Float) {
            return (((Float)cyclesLongestPath).floatValue() + ((Float)cyclesShortestPath).floatValue()) / 2.0f;
        }
        if (cyclesShortestPath instanceof Float && !(cyclesLongestPath instanceof Float)) {
            return ((Float)cyclesShortestPath).floatValue();
        }
        if (cyclesLongestPath instanceof Float && !(cyclesShortestPath instanceof Float)) {
            return ((Float)cyclesLongestPath).floatValue();
        }
        if (cyclesEmitted instanceof Float) {
            return ((Float)cyclesEmitted).floatValue();
        }
        return -1.0f;
    }

    @Override
    protected String getCoreName() {
        return this.defaultCompiler != null ? this.defaultCompiler.getCoreName() : null;
    }

    @Override
    protected String getDriverName() {
        return this.defaultCompiler != null ? this.defaultCompiler.getDriverName() : null;
    }

    @Override
    protected String getCoreRevision() {
        return this.defaultCompiler != null ? this.defaultCompiler.getCoreRevision() : null;
    }

    public static enum Statistics implements IGlStatistic
    {
        ARITHMETIC_INSTRUCTIONS_EMITTED(new GlShaderStatType("A", "The number of Arithmetic instructions emitted.", true, GlShaderStatType.Type.FLOAT, 1)),
        ARITHMETIC_LONGEST_PATH(new GlShaderStatType("A - Longest Path", "The number of cycles spent in the Arithmetic pipeline for the longest code path.", false, GlShaderStatType.Type.FLOAT, 7)),
        ARITHMETIC_SHORTEST_PATH(new GlShaderStatType("A - Shortest Path", "The number of cycles spent in the Arithmetic pipeline for the shortest code path.", false, GlShaderStatType.Type.FLOAT, 6)),
        ESTIMATED_EXECUTION_CYCLES(new GlShaderStatType("Cycles", "The estimated number of cycles this shader will take for one execution.\nThis estimate may be inaccurate for shaders that contain loops.", true, GlShaderStatType.Type.FLOAT, 0)),
        LOAD_STORE_INSTRUCTIONS_EMITTED(new GlShaderStatType("L/S", "The number of Load/Store instructions emitted.", true, GlShaderStatType.Type.FLOAT, 2)),
        LOAD_STORE_LONGEST_PATH(new GlShaderStatType("L/S - Longest Path", "The number of cycles spent in the Load/Store pipeline for the longest code path.", false, GlShaderStatType.Type.FLOAT, 9)),
        LOAD_STORE_SHORTEST_PATH(new GlShaderStatType("L/S - Shortest Path", "The number of cycles spent in the Load/Store pipeline for the shortest code path.", false, GlShaderStatType.Type.FLOAT, 8)),
        TEXTURE_INSTRUCTIONS_EMITTED(new GlShaderStatType("T", "The number of Texture instructions emitted.", true, GlShaderStatType.Type.FLOAT, 3)),
        TEXTURE_LONGEST_PATH(new GlShaderStatType("T - Longest Path", "The number of cycles spent in the Texture pipeline for the longest code path.", false, GlShaderStatType.Type.FLOAT, 11)),
        TEXTURE_SHORTEST_PATH(new GlShaderStatType("T - Shortest Path", "The number of cycles spent in the Texture pipeline for the shortest code path.", false, GlShaderStatType.Type.FLOAT, 10)),
        TOTAL_INSTRUCTIONS_EMITTED(new GlShaderStatType("Total", "The total number of instructions emitted.", false, GlShaderStatType.Type.FLOAT, 12)),
        UNIFORM_REGISTERS(new GlShaderStatType("Uniform Registers", "The number of uniform registers used.", true, GlShaderStatType.Type.INTEGER, 4)),
        WORK_REGISTERS(new GlShaderStatType("Work Registers", "The number of work registers used.", true, GlShaderStatType.Type.INTEGER, 5)),
        SPILLING_USED(new GlShaderStatType("Spilling Used", "Register spilling is used if the number of work registers required is too great. This will cause an increase in Load/Store activity since the additional values will be stored in memory.", true, GlShaderStatType.Type.BOOLEAN, 13));

        private final GlShaderStatType type;

        private Statistics(GlShaderStatType type) {
            this.type = type;
        }

        @Override
        public GlShaderStatType getGlShaderStatType() {
            return this.type;
        }
    }
}

