/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.offlinecompiler;

import com.arm.mgd.core.offlinecompiler.GlShaderCompilerError;
import com.arm.mgd.core.offlinecompiler.IGlStatistic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class GlShaderStats {
    public static final @NonNull GlShaderStats FAILED_TO_RUN_COMPILER_SHADER_STATS = new GlShaderStats(){
        {
            this.setStatus(CompileStatus.FAILED_TO_RUN_COMPILER);
        }

        @Override
        protected @Nullable Number getEstimatedExecutionCycles() {
            return null;
        }
    };
    private final List<GlShaderCompilerError> errorMessages = new ArrayList<GlShaderCompilerError>();
    private final List<GlShaderCompilerError> warningMessages = new ArrayList<GlShaderCompilerError>();
    private final HashMap<IGlStatistic, Object> statistics = new HashMap();
    private @NonNull CompileStatus status = CompileStatus.COMPILED_SUCCESSFULLY;

    GlShaderStats() {
    }

    void setStatus(@NonNull CompileStatus status) {
        this.status = status;
    }

    public @NonNull CompileStatus getStatus() {
        return this.status;
    }

    public List<GlShaderCompilerError> getErrorMessages() {
        return this.errorMessages;
    }

    public List<GlShaderCompilerError> getWarningMessages() {
        return this.warningMessages;
    }

    void addError(GlShaderCompilerError error) {
        this.errorMessages.add(error);
        this.setStatus(CompileStatus.COMPILED_WITH_ERRORS);
    }

    void addWarning(GlShaderCompilerError warning) {
        this.warningMessages.add(warning);
    }

    void setStatValue(IGlStatistic type, Object value) {
        assert (value != null);
        assert (type != null);
        if (value instanceof Number && ((Number)value).intValue() == -1) {
            value = null;
        }
        switch (type.getGlShaderStatType().getType()) {
            case BOOLEAN: {
                assert (value instanceof Boolean);
                break;
            }
            case FLOAT: {
                assert (value instanceof Float);
                break;
            }
            case INTEGER: {
                assert (value instanceof Integer);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.statistics.put(type, value);
    }

    public @Nullable Object getStat(IGlStatistic statType) {
        return this.statistics.get(statType);
    }

    public int compare(GlShaderStats otherShaderStats, IGlStatistic statistic) {
        if (otherShaderStats == null) {
            throw new NullPointerException();
        }
        assert (this.statistics.get(statistic) != null);
        assert (otherShaderStats.statistics.get(statistic) != null);
        switch (statistic.getGlShaderStatType().getType()) {
            case BOOLEAN: {
                Boolean thisBooleanStat = (Boolean)this.statistics.get(statistic);
                Boolean otherBooleanStat = (Boolean)otherShaderStats.statistics.get(statistic);
                return Objects.compare(thisBooleanStat, otherBooleanStat, Boolean::compareTo);
            }
            case FLOAT: {
                Float thisFloatStat = (Float)this.statistics.get(statistic);
                Float otherFloatStat = (Float)otherShaderStats.statistics.get(statistic);
                return Objects.compare(thisFloatStat, otherFloatStat, Float::compareTo);
            }
            case INTEGER: {
                Integer thisIntegerStat = (Integer)this.statistics.get(statistic);
                Integer otherIntegerStat = (Integer)otherShaderStats.statistics.get(statistic);
                return Objects.compare(thisIntegerStat, otherIntegerStat, Integer::compareTo);
            }
        }
        assert (false);
        return 0;
    }

    protected abstract @Nullable Number getEstimatedExecutionCycles();

    public @Nullable Float getTotalCycles(long executionCount) {
        Number estimatedCycles = this.getEstimatedExecutionCycles();
        if (estimatedCycles == null) {
            return null;
        }
        return Float.valueOf((float)Math.ceil((double)executionCount * estimatedCycles.doubleValue()));
    }

    public static enum CompileStatus {
        COMPILED_SUCCESSFULLY,
        COMPILED_WITH_ERRORS,
        FAILED_TO_RUN_COMPILER;

    }
}

