/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.offlinecompiler;

import com.arm.compilermanager.Outputs;
import com.arm.mgd.core.offlinecompiler.GlShaderCompilerError;
import com.arm.mgd.core.offlinecompiler.GlShaderStats;
import com.arm.mgd.core.offlinecompiler.IGlStatistic;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class GlShaderCompiler {
    private static final @NonNull ExecutorService SHADER_COMPILER_WORKERS = NamedExecutors.cachedNumCoresThreadPool(60L, TimeUnit.SECONDS, new NamedThreadFactory("GlShaderCompiler Worker Pool", 1));

    public @NonNull CompletableFuture<@NonNull GlShaderStats> compile(@Nullable String shaderSource, @NonNull AbstractConstantOrAliasSpecExtended shaderType) {
        @NonNull String source = shaderSource != null ? shaderSource : "";
        CompletableFuture<@NonNull GlShaderStats> future = new CompletableFuture<GlShaderStats>();
        SHADER_COMPILER_WORKERS.submit(() -> {
            @NonNull GlShaderStats shaderStats = GlShaderStats.FAILED_TO_RUN_COMPILER_SHADER_STATS;
            try {
                Outputs compilerOutput = this.runCompiler(source, shaderType);
                shaderStats = this.processShaderOutput(compilerOutput);
            }
            catch (Throwable t) {
                CoreLogging.warning(null, t, "Error compiling shader in GlShaderCompiler");
            }
            future.complete(shaderStats);
        });
        return future;
    }

    public abstract IGlStatistic[] getStatistics();

    protected abstract @NonNull GlShaderStats analyzeStatistics(@NonNull Outputs var1);

    protected abstract String getCoreName();

    private @NonNull GlShaderStats processShaderOutput(@Nullable Outputs compilerOutput) {
        if (compilerOutput == null) {
            return GlShaderStats.FAILED_TO_RUN_COMPILER_SHADER_STATS;
        }
        GlShaderStats shaderStats = this.analyzeStatistics(compilerOutput);
        String[] stringArray = compilerOutput.getErrors();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String error = stringArray[n2];
            shaderStats.setStatus(GlShaderStats.CompileStatus.COMPILED_WITH_ERRORS);
            if (error == null) {
                error = "Unknown error";
            }
            shaderStats.addError(new GlShaderCompilerError(error, 0, GlShaderCompilerError.Severity.ERROR));
            ++n2;
        }
        stringArray = compilerOutput.getWarnings();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String warning = stringArray[n2];
            if (warning == null) {
                warning = "Unknown warning";
            }
            shaderStats.addWarning(new GlShaderCompilerError(warning, 0, GlShaderCompilerError.Severity.WARNING));
            ++n2;
        }
        return shaderStats;
    }

    /*
     * Exception decompiling
     */
    private @Nullable Outputs runCompiler(@NonNull String shaderSource, @NonNull AbstractConstantOrAliasSpecExtended shaderType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract String getDriverName();

    protected abstract String getCoreRevision();
}

