/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.navigation;

import com.arm.mgd.core.navigation.INavigationChangedListener;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import com.arm.mgd.utils.NullUtils;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TogglableNavigationChangedListener {
    private final @NonNull NamedSingleThreadExecutor executor;
    private final @NonNull INavigationChangedListener navigationChangedListener;
    private final @NonNull INavigationChangedListener togglableListener;
    private boolean enabled = false;
    private @Nullable NavigationUriChangeEvent mostRecentEvent = null;

    TogglableNavigationChangedListener(@NonNull NamedSingleThreadExecutor executor, @NonNull INavigationChangedListener navigationChangedListener) {
        this.executor = executor;
        this.navigationChangedListener = navigationChangedListener;
        this.togglableListener = event -> this.onNavigationChanged(event);
    }

    public void setEnabled(boolean isEnabled) {
        this.executor.runLater(() -> {
            this.enabled = isEnabled;
            if (this.enabled && this.mostRecentEvent != null) {
                this.navigationChangedListener.onNavigationChanged(this.mostRecentEvent);
                this.mostRecentEvent = null;
            }
        });
    }

    @NonNull INavigationChangedListener getTogglableListener() {
        return this.togglableListener;
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent newEvent) {
        NavigationUriChangeEvent event;
        assert (this.executor.isCurrentThread());
        NavigationUriChangeEvent oldEvent = this.mostRecentEvent;
        if (oldEvent == null) {
            event = newEvent;
        } else {
            assert (!this.enabled);
            event = new NavigationUriChangeEvent(oldEvent.getOldNavigationUri(), newEvent.getNewNavigationUri(), newEvent.getNewSnapshotProxy(), newEvent.getOrigin());
            boolean areOldAndNewUrisIdentical = Objects.equals(event.getOldNavigationUri(), event.getNewNavigationUri());
            if (areOldAndNewUrisIdentical) {
                this.mostRecentEvent = null;
                return;
            }
        }
        boolean hasTargetChanged = event.getOldAndNewModels((oldModel, newModel) -> {
            AbstractTarget oldTarget = oldModel != null ? oldModel.getParentProcessTarget().getParentTarget() : null;
            AbstractTarget newTarget = newModel != null ? newModel.getParentProcessTarget().getParentTarget() : null;
            return NullUtils.booleanValueOf((oldTarget != newTarget ? 1 : 0) != 0);
        });
        if (this.enabled || hasTargetChanged) {
            this.navigationChangedListener.onNavigationChanged(event);
            this.mostRecentEvent = null;
        } else {
            this.mostRecentEvent = event;
        }
    }
}

