/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.navigation;

import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.INavigationSnapshotProxy;
import com.arm.mgd.core.navigation.INavigationUriVisitor;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NavigationUriChangeEvent {
    private final @NonNull Object origin;
    private final @Nullable NavigationUri newNavigationUri;
    private final @NonNull INavigationSnapshotProxy newSnapshotProxy;
    private final @Nullable NavigationUri oldNavigationUri;

    public NavigationUriChangeEvent(@Nullable NavigationUri oldNavigationUri, @Nullable NavigationUri newNavigationUri, @NonNull INavigationSnapshotProxy newSnapshotProxy, @NonNull Object origin) {
        this.newNavigationUri = newNavigationUri;
        this.newSnapshotProxy = newSnapshotProxy;
        this.oldNavigationUri = oldNavigationUri;
        this.origin = origin;
    }

    public boolean didNotOriginateHere(@NonNull Object here) {
        return here != this.origin;
    }

    public @Nullable NavigationUri getNewNavigationUri() {
        return this.newNavigationUri;
    }

    public @Nullable NavigationUri getOldNavigationUri() {
        return this.oldNavigationUri;
    }

    public @NonNull INavigationSnapshotProxy getNewSnapshotProxy() {
        return this.newSnapshotProxy;
    }

    public @NonNull Object getOrigin() {
        return this.origin;
    }

    public <ReturnType> ReturnType getNewTarget(@NonNull Function<@Nullable AbstractTarget, ReturnType> functor) {
        return this.newNavigationUri != null ? this.newNavigationUri.getTarget(functor) : functor.apply(null);
    }

    public <ReturnType> ReturnType getNewModel(@NonNull Function<@Nullable TraceDataModel, ReturnType> functor) {
        return this.newNavigationUri != null ? this.newNavigationUri.getModel(functor) : functor.apply(null);
    }

    public <ReturnType> ReturnType getNewResolvedFunctionCall(@NonNull Function<@Nullable FunctionCall, ReturnType> functor) {
        return this.newNavigationUri != null ? this.newNavigationUri.getResolvedFunctionCall(functor) : functor.apply(null);
    }

    public <ReturnType> ReturnType getNewMostSpecificItem(@NonNull Function<@Nullable INavigationElement<?>, ReturnType> functor) {
        return this.newNavigationUri != null ? this.newNavigationUri.getMostSpecificItem(functor) : functor.apply(null);
    }

    public <ReturnType> ReturnType getNewParentItem(@NonNull Function<@Nullable INavigationElement<?>, ReturnType> functor) {
        return this.newNavigationUri != null ? this.newNavigationUri.getParentItem(functor) : functor.apply(null);
    }

    public <ReturnType> ReturnType getNewMostSpecificAndParentItems(@NonNull BiFunction<@Nullable INavigationElement<?>, @Nullable INavigationElement<?>, ReturnType> biFunctor) {
        return this.newNavigationUri != null ? this.newNavigationUri.getMostSpecificAndParentItems(biFunctor) : biFunctor.apply(null, null);
    }

    public <ReturnType> ReturnType getOldAndNewModels(@NonNull BiFunction<@Nullable TraceDataModel, @Nullable TraceDataModel, ReturnType> biFunctor) {
        return NavigationUri.compareModels(this.oldNavigationUri, this.newNavigationUri, biFunctor);
    }

    public <ReturnType> ReturnType newUriAccept(@NonNull INavigationUriVisitor<ReturnType> visitor) {
        return this.newNavigationUri != null ? this.newNavigationUri.accept(visitor) : visitor.invalid();
    }
}

