/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.navigation;

import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.INavigationUriVisitor;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NavigationUri {
    private final @NonNull WeakReference<@Nullable AbstractTarget> weakTarget;
    private final @NonNull List<@NonNull Long> currentUri = new ArrayList<Long>();

    public NavigationUri(@NonNull INavigationElement<?> item) {
        AbstractTarget target;
        if (item instanceof AbstractTarget) {
            target = (AbstractTarget)item;
            this.currentUri.add(NullUtils.longValueOf((long)0L));
        } else if (item instanceof TraceDataModel) {
            TraceDataModel selectedModel = (TraceDataModel)item;
            target = selectedModel.getParentProcessTarget().getParentTarget();
            this.currentUri.add(NullUtils.longValueOf((long)selectedModel.getLabelIndex()));
        } else if (item instanceof Frame) {
            Frame selectedFrame = (Frame)item;
            target = selectedFrame.getParentModel().getParentProcessTarget().getParentTarget();
            this.currentUri.add(NullUtils.longValueOf((long)selectedFrame.getParentModel().getLabelIndex()));
            this.currentUri.add(NullUtils.longValueOf((long)selectedFrame.getLabelIndex()));
        } else if (item instanceof FrameRenderPass) {
            FrameRenderPass renderPass = (FrameRenderPass)item;
            Frame selectedFrame = renderPass.getFrame();
            target = selectedFrame.getParentModel().getParentProcessTarget().getParentTarget();
            this.currentUri.add(NullUtils.longValueOf((long)selectedFrame.getParentModel().getLabelIndex()));
            this.currentUri.add(NullUtils.longValueOf((long)selectedFrame.getLabelIndex()));
            this.currentUri.add(NullUtils.longValueOf((long)renderPass.getLabelIndex()));
        } else if (item instanceof FunctionCall) {
            FunctionCall fc = (FunctionCall)item;
            Frame selectedFrame = (Frame)NullUtils.neverNull((Object)fc.getParentFrame());
            target = selectedFrame.getParentModel().getParentProcessTarget().getParentTarget();
            FrameRenderPass renderPass = fc instanceof TraceDataModel.DummyFunctionCall ? selectedFrame.getFirstRenderPass() : NavigationUri.findRenderpassForFunctionCall(fc, selectedFrame.getRenderPassList());
            if (renderPass == null) {
                throw new InvalidNavigationURIException("Unable to find render pass for function call");
            }
            this.currentUri.add(NullUtils.longValueOf((long)selectedFrame.getParentModel().getLabelIndex()));
            this.currentUri.add(NullUtils.longValueOf((long)selectedFrame.getLabelIndex()));
            this.currentUri.add(NullUtils.longValueOf((long)renderPass.getLabelIndex()));
            this.currentUri.add(NullUtils.longValueOf((long)fc.getLabelIndex()));
        } else {
            throw new InvalidNavigationURIException("Unknown type of INavigationElement: " + item);
        }
        this.weakTarget = new WeakReference<AbstractTarget>(target);
    }

    private @NonNull FunctionCall resolveAsFunctionCall(@NonNull AbstractTarget target) {
        int functionCallIndex;
        assert (!target.isClosed());
        @NonNull TraceDataModel model = target.getModels().get(this.currentUri.get(0).intValue());
        switch (this.currentUri.size()) {
            case 4: {
                functionCallIndex = this.currentUri.get(3).intValue();
                break;
            }
            case 3: {
                Frame frame = model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
                FrameRenderPass renderPass = frame.getRenderPassList().get(this.currentUri.get(2).intValue());
                functionCallIndex = renderPass.getLastInterestingCallFunctionIndex();
                break;
            }
            case 2: {
                Frame frame = model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
                int lastFunctionIndex = frame.getLastFunctionIndex();
                if (frame.isTheChildrenListFinal() && lastFunctionIndex > 0) {
                    functionCallIndex = lastFunctionIndex - 1;
                    break;
                }
                functionCallIndex = lastFunctionIndex;
                break;
            }
            case 1: {
                functionCallIndex = model.count() == 0 ? -1 : 0;
                break;
            }
            default: {
                throw new AssertionError((Object)"NavigationURI is invalid.");
            }
        }
        return model.getCallItem(functionCallIndex);
    }

    private @NonNull INavigationElement<?> getMostSpecificItem(@NonNull AbstractTarget target) {
        assert (!target.isClosed());
        @NonNull TraceDataModel model = target.getModels().get(this.currentUri.get(0).intValue());
        switch (this.currentUri.size()) {
            case 4: {
                return model.getCallItem(this.currentUri.get(3).intValue());
            }
            case 3: {
                Frame frame = model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
                return frame.getRenderPassList().get(this.currentUri.get(2).intValue());
            }
            case 2: {
                return model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
            }
            case 1: {
                return model;
            }
        }
        throw new AssertionError((Object)"NavigationURI is invalid.");
    }

    private @NonNull INavigationElement<?> getParentItem(@NonNull AbstractTarget target) {
        assert (!target.isClosed());
        @NonNull TraceDataModel model = target.getModels().get(this.currentUri.get(0).intValue());
        switch (this.currentUri.size()) {
            case 4: {
                Frame frame = model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
                return frame.getRenderPassList().get(this.currentUri.get(2).intValue());
            }
            case 3: {
                return model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
            }
            case 2: {
                return model;
            }
            case 1: {
                return target;
            }
        }
        throw new AssertionError((Object)"NavigationURI is invalid.");
    }

    private <ReturnType, InternalType> ReturnType applyToValidTargetElseToNull(@NonNull Function<@Nullable InternalType, ReturnType> functor, @NonNull Function<@NonNull AbstractTarget, InternalType> internalFunctor) {
        @Nullable AbstractTarget target = (AbstractTarget)this.weakTarget.get();
        if (target == null) {
            return functor.apply(null);
        }
        return (ReturnType)target.readLock(() -> {
            if (target.isClosed()) {
                return functor.apply(null);
            }
            return functor.apply(internalFunctor.apply(target));
        });
    }

    public <ReturnType> ReturnType getTarget(@NonNull Function<@Nullable AbstractTarget, ReturnType> functor) {
        return this.applyToValidTargetElseToNull(functor, target -> target);
    }

    public <ReturnType> ReturnType getModel(@NonNull Function<@Nullable TraceDataModel, ReturnType> functor) {
        return this.applyToValidTargetElseToNull(functor, target -> target.getModels().get(this.currentUri.get(0).intValue()));
    }

    public <ReturnType> ReturnType getResolvedFunctionCall(@NonNull Function<@Nullable FunctionCall, ReturnType> functor) {
        return this.applyToValidTargetElseToNull(functor, target -> this.resolveAsFunctionCall((AbstractTarget)target));
    }

    public <ReturnType> ReturnType getMostSpecificItem(@NonNull Function<@Nullable INavigationElement<?>, ReturnType> functor) {
        return this.applyToValidTargetElseToNull(functor, target -> this.getMostSpecificItem((AbstractTarget)target));
    }

    public <ReturnType> ReturnType getParentItem(@NonNull Function<@Nullable INavigationElement<?>, ReturnType> functor) {
        return this.applyToValidTargetElseToNull(functor, target -> this.getParentItem((AbstractTarget)target));
    }

    public <ReturnType> ReturnType getMostSpecificAndParentItems(@NonNull BiFunction<@Nullable INavigationElement<?>, @Nullable INavigationElement<?>, ReturnType> biFunctor) {
        @Nullable AbstractTarget target = (AbstractTarget)this.weakTarget.get();
        if (target == null) {
            return biFunctor.apply(null, null);
        }
        return (ReturnType)target.readLock(() -> {
            if (target.isClosed()) {
                return biFunctor.apply(null, null);
            }
            return biFunctor.apply(this.getMostSpecificItem(target), this.getParentItem(target));
        });
    }

    private <ReturnType> ReturnType visitTarget(@NonNull AbstractTarget target, @NonNull INavigationUriVisitor<ReturnType> visitor) {
        @NonNull TraceDataModel model = target.getModels().get(this.currentUri.get(0).intValue());
        switch (this.currentUri.size()) {
            case 4: {
                Frame frame = model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
                FrameRenderPass renderPass = frame.getRenderPassList().get(this.currentUri.get(2).intValue());
                FunctionCall functionCall = model.getCallItem(this.currentUri.get(3).intValue());
                return visitor.visit(target, model, frame, renderPass, functionCall);
            }
            case 3: {
                Frame frame = model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
                FrameRenderPass renderPass = frame.getRenderPassList().get(this.currentUri.get(2).intValue());
                return visitor.visit(target, model, frame, renderPass);
            }
            case 2: {
                Frame frame = model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
                assert (frame != null);
                return visitor.visit(target, model, frame);
            }
            case 1: {
                return visitor.visit(target, model);
            }
        }
        throw new AssertionError((Object)"NavigationURI is invalid.");
    }

    public <ReturnType> ReturnType accept(@NonNull INavigationUriVisitor<ReturnType> visitor) {
        @Nullable AbstractTarget target = (AbstractTarget)this.weakTarget.get();
        if (target == null) {
            return visitor.invalid();
        }
        return (ReturnType)target.readLock(() -> {
            Object retVal = target.isClosed() ? visitor.invalid() : this.visitTarget(target, visitor);
            return retVal;
        });
    }

    private static @Nullable FrameRenderPass findRenderpassForFunctionCall(@NonNull FunctionCall functionCall, @NonNull List<@NonNull FrameRenderPass> allRenderPasses) {
        for (FrameRenderPass renderPass : allRenderPasses) {
            if (!renderPass.contains(functionCall)) continue;
            return renderPass;
        }
        return null;
    }

    public @Nullable NavigationUri selectFirstInNextLevel() {
        @Nullable AbstractTarget target = (AbstractTarget)this.weakTarget.get();
        if (target == null || this.currentUri.size() == 4) {
            return null;
        }
        return target.readLock(() -> {
            if (target.isClosed()) {
                return null;
            }
            @NonNull TraceDataModel model = target.getModels().get(this.currentUri.get(0).intValue());
            switch (this.currentUri.size()) {
                case 3: {
                    Frame frame = model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
                    FrameRenderPass renderPass = frame.getRenderPassList().get(this.currentUri.get(2).intValue());
                    return new NavigationUri(model.getCallItem(renderPass.getFirstInterestingCallFunctionIndex()));
                }
                case 2: {
                    Frame frame = model.getFrames().getFrameAt(this.currentUri.get(1).intValue());
                    return new NavigationUri(frame.getRenderPassList().get(0));
                }
                case 1: {
                    return new NavigationUri(model.getFrames().getFrameAt(0));
                }
            }
            throw new AssertionError((Object)"NavigationURI is invalid.");
        });
    }

    public static <ReturnType> ReturnType accept(@Nullable NavigationUri uri, @NonNull INavigationUriVisitor<ReturnType> visitor) {
        return uri != null ? uri.accept(visitor) : visitor.invalid();
    }

    public static <ReturnType> ReturnType compareModels(@Nullable NavigationUri uri1, @Nullable NavigationUri uri2, @NonNull BiFunction<@Nullable TraceDataModel, @Nullable TraceDataModel, ReturnType> biFunctor) {
        if (uri1 == null && uri2 == null) {
            return biFunctor.apply(null, null);
        }
        if (uri1 == null && uri2 != null) {
            return (ReturnType)uri2.getModel(model2 -> biFunctor.apply((TraceDataModel)null, (TraceDataModel)model2));
        }
        if (uri1 != null && uri2 == null) {
            return (ReturnType)uri1.getModel(model1 -> biFunctor.apply((TraceDataModel)model1, (TraceDataModel)null));
        }
        assert (uri1 != null && uri2 != null);
        return (ReturnType)uri1.getModel(model1 -> uri2.getModel(model2 -> biFunctor.apply((TraceDataModel)model1, (TraceDataModel)model2)));
    }

    public String toString() {
        return this.currentUri.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NavigationUri)) {
            return false;
        }
        NavigationUri otherNavigationUri = (NavigationUri)other;
        return Objects.equals(this.weakTarget.get(), otherNavigationUri.weakTarget.get()) && this.currentUri.equals(otherNavigationUri.currentUri);
    }

    public int hashCode() {
        return this.currentUri.hashCode();
    }

    public static class InvalidNavigationURIException
    extends RuntimeException {
        protected InvalidNavigationURIException(String message) {
            super(message);
        }
    }
}

