/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.navigation;

import com.arm.mgd.core.navigation.AsynchronousTraceStateSnapshot;
import com.arm.mgd.core.navigation.INavigationChangedListener;
import com.arm.mgd.core.navigation.INavigationSnapshotProxy;
import com.arm.mgd.core.navigation.INavigationStackChangedListener;
import com.arm.mgd.core.navigation.ISnapshotProxy;
import com.arm.mgd.core.navigation.ITargetRemovedListener;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.navigation.NonNullLimitedDepthArrayDeque;
import com.arm.mgd.core.navigation.SnapshotProxyTask;
import com.arm.mgd.core.navigation.TogglableNavigationChangedListener;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.ITargetEventListener;
import com.arm.mgd.core.util.WeakListenerSet;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NavigationManager {
    private static final int MAX_SNAPSHOT_TASKS = Runtime.getRuntime().availableProcessors();
    private final @NonNull WeakListenerSet<INavigationChangedListener> navigationChangedListeners = new WeakListenerSet();
    private final @NonNull WeakListenerSet<INavigationStackChangedListener> navigationStackChangedListeners = new WeakListenerSet();
    private final @NonNull WeakListenerSet<ITargetRemovedListener> targetRemovedListeners = new WeakListenerSet();
    private @NonNull AtomicReference<@Nullable AbstractTarget> activeTarget = new AtomicReference<Object>(null);
    private final @NonNull AtomicReference<@Nullable NavigationUri> activeNavigationUri = new AtomicReference<Object>(null);
    private final @NonNull Map<@NonNull AbstractTarget, TargetUri> targetToUriMap = new HashMap<AbstractTarget, TargetUri>();
    private final @NonNull ITargetEventListener targetEventListener = new ITargetEventListener(){

        @Override
        public void onTargetClose(@NonNull AbstractTarget closedTarget) {
            NavigationManager.this.executor.runLater(() -> {
                if (NavigationManager.this.activeTarget.get() == closedTarget) {
                    NavigationManager.this.activeTarget.set(null);
                    NavigationUri oldUri = NavigationManager.this.activeNavigationUri.getAndSet(null);
                    NavigationManager.this.notifyStackChange(true);
                    NavigationManager.this.notifyNavigationListeners(new NavigationUriChangeEvent(oldUri, null, NavigationManager.this.createSnapshotProxy(null), this));
                }
                NavigationManager.this.targetRemovedListeners.notifyWeakListeners(listener -> listener.onTargetRemoved(closedTarget));
                TargetUri targetUri = NavigationManager.this.targetToUriMap.remove(closedTarget);
                if (!$assertionsDisabled && targetUri == null) {
                    throw new AssertionError();
                }
            });
        }

        @Override
        public void onNewTargetModelEvent(@NonNull AbstractTarget target, @NonNull TraceDataModel model) {
            NavigationManager.this.executor.runLater(() -> {
                TargetUri targetUri = NavigationManager.this.targetToUriMap.get(target);
                if (!$assertionsDisabled && targetUri == null) {
                    throw new AssertionError();
                }
                targetUri.modelSnapshots.put(model, new AsynchronousTraceStateSnapshot(model, NavigationManager.this.executor, NavigationManager.this.snapshotTaskPool, MAX_SNAPSHOT_TASKS));
                if (targetUri.currentUri == null) {
                    NavigationManager.this.setNavigationURIImpl(new NavigationUri(model), target);
                }
            });
        }
    };
    private final @NonNull NamedSingleThreadExecutor executor = new NamedSingleThreadExecutor("NavigationManager runLater", false);
    private final @NonNull ExecutorService snapshotTaskPool = NamedExecutors.cachedFiniteThreadPool(MAX_SNAPSHOT_TASKS, 60L, TimeUnit.SECONDS, new NamedThreadFactory("NavigationManager Snapshot Task Pool"));
    private final @NonNull ISnapshotProxy nullSnapshotProxy = consumer -> {
        Future<?> future = this.snapshotTaskPool.submit(() -> consumer.run(null));
    };

    public void setActiveTarget(@Nullable AbstractTarget newActiveTarget) {
        this.executor.runLater(() -> {
            if (this.activeTarget.get() == newActiveTarget) {
                return;
            }
            TargetUri targetUri = this.targetToUriMap.get(newActiveTarget);
            @Nullable NavigationUri newUri = targetUri != null ? targetUri.currentUri : null;
            boolean stackEmpty = targetUri != null ? targetUri.stack.isEmpty() : false;
            this.activeTarget.set(newActiveTarget);
            @Nullable NavigationUri oldUri = this.activeNavigationUri.getAndSet(newUri);
            this.notifyStackChange(stackEmpty);
            this.notifyNavigationListeners(new NavigationUriChangeEvent(oldUri, newUri, this.createSnapshotProxy(newUri), this));
        });
    }

    private @NonNull INavigationSnapshotProxy createSnapshotProxy(final @Nullable NavigationUri newUri) {
        assert (this.executor.isCurrentThread());
        final @NonNull ISnapshotProxy snapshotProxy = newUri == null ? this.nullSnapshotProxy : newUri.getResolvedFunctionCall(functionCall -> {
            if (functionCall == null) {
                return this.nullSnapshotProxy;
            }
            TraceDataModel model = functionCall.getModel();
            TargetUri targetUri = this.targetToUriMap.get(model.getParentProcessTarget().getParentTarget());
            assert (targetUri != null);
            AsynchronousTraceStateSnapshot snapshot = targetUri.modelSnapshots.get(model);
            assert (snapshot != null);
            return snapshot.setSelectedFunction(functionCall.getIndex());
        });
        return new INavigationSnapshotProxy(){

            @Override
            public void submitTask(@NonNull SnapshotProxyTask snapshotTask) {
                snapshotProxy.submitTask(snapshot -> {
                    try {
                        if (Objects.equals(newUri, NavigationManager.this.activeNavigationUri.get())) {
                            snapshotTask.run(snapshot);
                        } else {
                            snapshotTask.ignored();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                });
            }
        };
    }

    public void addTarget(@NonNull AbstractTarget targetToAdd) {
        this.executor.runLater(() -> {
            this.targetToUriMap.put(targetToAdd, new TargetUri());
            targetToAdd.addTargetEventListener(this.targetEventListener);
        });
    }

    public void setNavigationURI(@NonNull NavigationUri newURI, @NonNull Object origin) {
        this.executor.runLater(() -> this.setNavigationURIImpl(newURI, origin));
    }

    private void setNavigationURIImpl(@NonNull NavigationUri newURI, @NonNull Object origin) {
        assert (this.executor.isCurrentThread());
        newURI.getTarget(target -> {
            if (target == null) {
                return null;
            }
            TargetUri targetUri = this.targetToUriMap.get(target);
            assert (targetUri != null);
            @Nullable NavigationUri oldURI = targetUri.currentUri;
            if (newURI.equals(oldURI)) {
                return null;
            }
            targetUri.currentUri = newURI;
            if (oldURI != null) {
                targetUri.stack.add(oldURI);
            }
            NavigationUri.compareModels(oldURI, newURI, (oldModel, newModel) -> {
                assert (newModel != null);
                if (!newModel.equals(oldModel)) {
                    this.executor.runLater(() -> target.setActiveModel((TraceDataModel)newModel));
                }
                return null;
            });
            if (target.equals(this.activeTarget.get())) {
                this.activeNavigationUri.set(newURI);
                this.notifyStackChange(false);
                this.notifyNavigationListeners(new NavigationUriChangeEvent(oldURI, newURI, this.createSnapshotProxy(newURI), origin));
            }
            return null;
        });
    }

    public void addTargetRemovedListener(@NonNull ITargetRemovedListener listenerToAdd) {
        this.targetRemovedListeners.addListenerAsWeakReference(listenerToAdd);
    }

    public void removeTargetRemovedListener(@NonNull ITargetRemovedListener listenerToRemove) {
        this.targetRemovedListeners.removeWeakReference(listenerToRemove);
    }

    public void addNavigationChangedListener(@NonNull INavigationChangedListener listenerToAdd) {
        this.navigationChangedListeners.addListenerAsWeakReference(listenerToAdd);
        this.executor.runLater(() -> {
            NavigationUri newUri = this.getActiveNavigationUri();
            listenerToAdd.onNavigationChanged(new NavigationUriChangeEvent(null, newUri, this.createSnapshotProxy(newUri), this));
        });
    }

    public void removeNavigationChangedListener(@NonNull INavigationChangedListener listenerToRemove) {
        this.navigationChangedListeners.removeWeakReference(listenerToRemove);
    }

    public @NonNull TogglableNavigationChangedListener createAndAddTogglableNavigationChangedListener(@NonNull INavigationChangedListener listenerToAdd) {
        TogglableNavigationChangedListener togglableListener = new TogglableNavigationChangedListener(this.executor, listenerToAdd);
        this.addNavigationChangedListener(togglableListener.getTogglableListener());
        return togglableListener;
    }

    public void removeTogglableNavigationChangedListener(@NonNull TogglableNavigationChangedListener listenerToRemove) {
        this.navigationChangedListeners.removeWeakReference(listenerToRemove.getTogglableListener());
    }

    public void addNavigationStackChangedListener(@NonNull INavigationStackChangedListener listenerToAdd) {
        this.navigationStackChangedListeners.addListenerAsWeakReference(listenerToAdd);
        this.executor.runLater(() -> {
            TargetUri targetUri = this.targetToUriMap.get(this.activeTarget.get());
            if (targetUri != null) {
                listenerToAdd.onNavigationStackChanged(targetUri.stack.isEmpty());
            } else {
                listenerToAdd.onNavigationStackChanged(true);
            }
        });
    }

    public void removeNavigationStackChangedListener(@NonNull INavigationStackChangedListener listenerToRemove) {
        this.navigationStackChangedListeners.removeWeakReference(listenerToRemove);
    }

    public void goBack() {
        this.executor.runLater(() -> {
            TargetUri targetUri = this.targetToUriMap.get(this.activeTarget.get());
            if (targetUri != null && !targetUri.stack.isEmpty()) {
                @NonNull NavigationUri newURI = (NavigationUri)targetUri.stack.pop();
                @Nullable NavigationUri oldURI = this.activeNavigationUri.getAndSet(newURI);
                this.notifyStackChange(targetUri.stack.isEmpty());
                this.notifyNavigationListeners(new NavigationUriChangeEvent(oldURI, newURI, this.createSnapshotProxy(newURI), this));
            }
        });
    }

    private void notifyNavigationListeners(@NonNull NavigationUriChangeEvent newURIEvent) {
        assert (this.executor.isCurrentThread());
        this.navigationChangedListeners.notifyWeakListeners(listener -> listener.onNavigationChanged(newURIEvent));
    }

    private void notifyStackChange(boolean empty) {
        assert (this.executor.isCurrentThread());
        this.navigationStackChangedListeners.notifyWeakListeners(listener -> listener.onNavigationStackChanged(empty));
    }

    public @Nullable NavigationUri getActiveNavigationUri() {
        return this.activeNavigationUri.get();
    }

    public @Nullable FunctionCall getActiveFunctionCall() {
        @Nullable NavigationUri activeUri = this.activeNavigationUri.get();
        return activeUri != null ? activeUri.getResolvedFunctionCall(fc -> fc) : null;
    }

    public @Nullable AbstractTarget getActiveTarget() {
        return this.activeTarget.get();
    }

    public void shutdown() {
        this.executor.shutdownNow();
        this.snapshotTaskPool.shutdownNow();
        this.navigationChangedListeners.clear();
        this.navigationStackChangedListeners.clear();
        this.targetRemovedListeners.clear();
        this.activeTarget.set(null);
        this.activeNavigationUri.set(null);
    }

    private static class TargetUri {
        private @Nullable NavigationUri currentUri;
        private final @NonNull NonNullLimitedDepthArrayDeque<@NonNull NavigationUri> stack = new NonNullLimitedDepthArrayDeque();
        private final @NonNull Map<@NonNull TraceDataModel, AsynchronousTraceStateSnapshot> modelSnapshots = new HashMap<TraceDataModel, AsynchronousTraceStateSnapshot>();

        private TargetUri() {
        }
    }
}

