/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.navigation;

import com.arm.mgd.core.navigation.ISnapshotProxy;
import com.arm.mgd.core.navigation.SnapshotProxyTask;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNull;

class AsynchronousTraceStateSnapshot {
    private final @NonNull TraceDataModel model;
    private @NonNull SynchronousTraceStateSnapshot snapshot;
    private boolean isSnapshotMoveInProgress;
    private @NonNull SnapshotProxy currentSnapshotProxy;
    private final @NonNull Queue<@NonNull SnapshotTask> pendingConsumers;
    private int numRunningConsumers;
    private boolean haveConsumersRunOnCurrentSnapshot;
    private final @NonNull NamedSingleThreadExecutor controllerThread;
    private final @NonNull ExecutorService workerPool;
    private final int maxConcurrentWorkers;

    AsynchronousTraceStateSnapshot(@NonNull TraceDataModel model, @NonNull NamedSingleThreadExecutor controllerThread, @NonNull ExecutorService workerPool, int maxConcurrentWorkers) {
        assert (maxConcurrentWorkers > 0);
        this.model = model;
        this.snapshot = new SynchronousTraceStateSnapshot(model);
        this.currentSnapshotProxy = new SnapshotProxy(this.snapshot.getCurrentSelection());
        this.isSnapshotMoveInProgress = false;
        this.pendingConsumers = new ArrayDeque<SnapshotTask>();
        this.numRunningConsumers = 0;
        this.haveConsumersRunOnCurrentSnapshot = false;
        this.controllerThread = controllerThread;
        this.workerPool = workerPool;
        this.maxConcurrentWorkers = maxConcurrentWorkers;
    }

    public @NonNull ISnapshotProxy setSelectedFunction(int newSelectionIndex) {
        assert (this.controllerThread.isCurrentThread());
        if (newSelectionIndex != this.currentSnapshotProxy.selection) {
            this.currentSnapshotProxy = new SnapshotProxy(newSelectionIndex);
            this.controllerThread.runLater(() -> this.scheduleTasks());
        }
        return this.currentSnapshotProxy;
    }

    /*
     * Unable to fully structure code
     */
    private void scheduleTasks() {
        if (!AsynchronousTraceStateSnapshot.$assertionsDisabled && !this.controllerThread.isCurrentThread()) {
            throw new AssertionError();
        }
        if (this.isSnapshotMoveInProgress) {
            return;
        }
        currentProxy = this.currentSnapshotProxy;
        currentSnapshot = this.snapshot;
        if (currentSnapshot.getCurrentSelection() == currentProxy.selection) ** GOTO lbl20
        makeNewSnapshot = this.haveConsumersRunOnCurrentSnapshot;
        this.isSnapshotMoveInProgress = true;
        this.workerPool.submit((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$1(com.arm.mgd.core.navigation.AsynchronousTraceStateSnapshot$SnapshotProxy boolean com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot ), ()V)((AsynchronousTraceStateSnapshot)this, (SnapshotProxy)currentProxy, (boolean)makeNewSnapshot, (SynchronousTraceStateSnapshot)currentSnapshot));
        return;
lbl-1000:
        // 1 sources

        {
            task = this.pendingConsumers.remove();
            v0 = wasSameProxy = task.snapshotProxy == currentProxy;
            if (wasSameProxy) {
                this.haveConsumersRunOnCurrentSnapshot = true;
            }
            ++this.numRunningConsumers;
            this.workerPool.submit((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$3(com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot com.arm.mgd.core.navigation.AsynchronousTraceStateSnapshot$SnapshotProxy boolean com.arm.mgd.core.navigation.AsynchronousTraceStateSnapshot$SnapshotTask ), ()V)((AsynchronousTraceStateSnapshot)this, (SynchronousTraceStateSnapshot)currentSnapshot, (SnapshotProxy)currentProxy, (boolean)wasSameProxy, (SnapshotTask)task));
lbl20:
            // 2 sources

            ** while (this.numRunningConsumers < this.maxConcurrentWorkers && !this.pendingConsumers.isEmpty())
        }
lbl21:
        // 1 sources

    }

    private /* synthetic */ void lambda$1(SnapshotProxy snapshotProxy, boolean bl, SynchronousTraceStateSnapshot synchronousTraceStateSnapshot) {
        block7: {
            SynchronousTraceStateSnapshot newSnapshot = null;
            try {
                try {
                    if (bl) {
                        newSnapshot = new SynchronousTraceStateSnapshot(this.model, snapshotProxy.selection);
                    } else {
                        newSnapshot = synchronousTraceStateSnapshot;
                        synchronousTraceStateSnapshot.setSelectedFunction(snapshotProxy.selection);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    SynchronousTraceStateSnapshot finalNewSnapshot = newSnapshot;
                    this.controllerThread.runLater(() -> {
                        assert (this.isSnapshotMoveInProgress);
                        if (finalNewSnapshot != null) {
                            assert (finalNewSnapshot.getCurrentSelection() == snapshotProxy.selection);
                            this.snapshot = finalNewSnapshot;
                        }
                        this.isSnapshotMoveInProgress = false;
                        this.haveConsumersRunOnCurrentSnapshot = false;
                        this.scheduleTasks();
                    });
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SynchronousTraceStateSnapshot finalNewSnapshot = newSnapshot;
                this.controllerThread.runLater(() -> {
                    assert (this.isSnapshotMoveInProgress);
                    if (finalNewSnapshot != null) {
                        assert (finalNewSnapshot.getCurrentSelection() == snapshotProxy.selection);
                        this.snapshot = finalNewSnapshot;
                    }
                    this.isSnapshotMoveInProgress = false;
                    this.haveConsumersRunOnCurrentSnapshot = false;
                    this.scheduleTasks();
                });
                throw throwable;
            }
            SynchronousTraceStateSnapshot finalNewSnapshot = newSnapshot;
            this.controllerThread.runLater(() -> {
                assert (this.isSnapshotMoveInProgress);
                if (finalNewSnapshot != null) {
                    assert (finalNewSnapshot.getCurrentSelection() == snapshotProxy.selection);
                    this.snapshot = finalNewSnapshot;
                }
                this.isSnapshotMoveInProgress = false;
                this.haveConsumersRunOnCurrentSnapshot = false;
                this.scheduleTasks();
            });
        }
    }

    private /* synthetic */ void lambda$3(SynchronousTraceStateSnapshot synchronousTraceStateSnapshot, SnapshotProxy snapshotProxy, boolean bl, SnapshotTask snapshotTask) {
        block7: {
            try {
                try {
                    if (bl) {
                        snapshotTask.snapshotTask.run(synchronousTraceStateSnapshot);
                    } else {
                        snapshotTask.snapshotTask.ignored();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.controllerThread.runLater(() -> {
                        assert (this.numRunningConsumers > 0);
                        assert (synchronousTraceStateSnapshot.getCurrentSelection() == snapshotProxy.selection);
                        --this.numRunningConsumers;
                        this.scheduleTasks();
                    });
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.controllerThread.runLater(() -> {
                    assert (this.numRunningConsumers > 0);
                    assert (synchronousTraceStateSnapshot.getCurrentSelection() == snapshotProxy.selection);
                    --this.numRunningConsumers;
                    this.scheduleTasks();
                });
                throw throwable;
            }
            this.controllerThread.runLater(() -> {
                assert (this.numRunningConsumers > 0);
                assert (synchronousTraceStateSnapshot.getCurrentSelection() == snapshotProxy.selection);
                --this.numRunningConsumers;
                this.scheduleTasks();
            });
        }
    }

    private class SnapshotProxy
    implements ISnapshotProxy {
        private final int selection;

        private SnapshotProxy(int selection) {
            this.selection = selection;
        }

        @Override
        public void submitTask(@NonNull SnapshotProxyTask snapshotTask) {
            AsynchronousTraceStateSnapshot.this.controllerThread.runLater(() -> {
                AsynchronousTraceStateSnapshot.this.pendingConsumers.add(new SnapshotTask(this, snapshotTask));
                AsynchronousTraceStateSnapshot.this.scheduleTasks();
            });
        }
    }

    private static class SnapshotTask {
        private final @NonNull SnapshotProxy snapshotProxy;
        private final @NonNull SnapshotProxyTask snapshotTask;

        private SnapshotTask(@NonNull SnapshotProxy snapshotProxy, @NonNull SnapshotProxyTask snapshotTask) {
            this.snapshotProxy = snapshotProxy;
            this.snapshotTask = snapshotTask;
        }
    }
}

