/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.midstream;

import com.arm.mgd.core.kapi.ISerializationProxy;
import com.arm.mgd.core.kapi.SerializableDependency;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class UniqueInstanceId
implements SerializableDependency {
    public static final UniqueInstanceId NO_UNIQUE_INSTANCE_ID = new UniqueInstanceId();
    private static final long serialVersionUID = -1383895668179576437L;
    public final long instanceCounter;

    public static UniqueInstanceId createFor(MidstreamAssetItem assetAttachment) {
        return new UniqueInstanceId(assetAttachment.getInstanceCounter());
    }

    private UniqueInstanceId() {
        this.instanceCounter = -1L;
    }

    private UniqueInstanceId(long instanceCounter) {
        this.instanceCounter = instanceCounter;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UniqueInstanceId) {
            return this.instanceCounter == ((UniqueInstanceId)obj).instanceCounter;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.instanceCounter);
    }

    public boolean isReplacedBy(MidstreamAssetItem assetObject) {
        return this.instanceCounter != assetObject.getInstanceCounter();
    }

    public String toString() {
        if (this.equals(NO_UNIQUE_INSTANCE_ID)) {
            return "<NO_INSTANCE_ID>";
        }
        return Long.toString(this.instanceCounter);
    }

    @Override
    public Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy
    implements ISerializationProxy {
        private static final long serialVersionUID = 1262526539207101341L;
        private final long instanceCounter;

        public SerializationProxy(UniqueInstanceId a) {
            this.instanceCounter = a.instanceCounter;
        }

        @Override
        public Object readResolve() {
            if (this.instanceCounter == UniqueInstanceId.NO_UNIQUE_INSTANCE_ID.instanceCounter) {
                return NO_UNIQUE_INSTANCE_ID;
            }
            return new UniqueInstanceId(this.instanceCounter);
        }
    }
}

