/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.midstream;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.lightweight.state.IIndexedStateItem;
import com.arm.mgd.lightweight.state.IIndexedStateItemChild;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.internal.AbstractStateItemContainer;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MidstreamStateItem
implements Serializable {
    private static final long serialVersionUID = -3648960034542548515L;
    private final @Nullable Integer index;
    private final @NonNull String stateId;
    private final @Nullable FunctionCallArgumentDescriptor value;

    public static void applyMidstreamStateUpdatesToStateItems(@NonNull FunctionCall currentFunctionCall, @NonNull Map<String, List<MidstreamStateItem>> stateUpdates, AbstractStateItemContainer stateItemContainer) {
        @Nullable IStateItem<?> elgDisplayItem = stateItemContainer.lookupStateItem(KapiSpec.EGL.states.EGL_CURRENT_DISPLAY);
        if (elgDisplayItem != null) {
            MidstreamStateItem.updateNonIndexedStateItem(currentFunctionCall, elgDisplayItem, stateUpdates);
        }
        for (IStateItem<?> iStateItem : stateItemContainer.getAllStateItems()) {
            if (iStateItem == elgDisplayItem) continue;
            MidstreamStateItem.updateNonIndexedStateItem(currentFunctionCall, iStateItem, stateUpdates);
        }
        for (IIndexedStateItem iIndexedStateItem : stateItemContainer.getAllIndexedStateItems()) {
            List<MidstreamStateItem> updates = stateUpdates.get(iIndexedStateItem.getStateSpec().getId());
            if (updates == null || updates.isEmpty()) continue;
            for (MidstreamStateItem update : updates) {
                assert (update != null);
                Integer index = update.getIndex();
                FunctionCallArgumentDescriptor value = update.getValue();
                assert (index != null && value != null || index == null && value == null) : "Index must be supplied or value must be null indicating to use default";
                if (index != null) {
                    IIndexedStateItemChild childItem = iIndexedStateItem.getItemForIndex(index);
                    if (childItem != null) {
                        childItem.addMidstreamUpdate(currentFunctionCall, update);
                        continue;
                    }
                    assert (false) : "Missing child state item " + iIndexedStateItem.getStateSpec().getId() + " @ " + index;
                    continue;
                }
                iIndexedStateItem.addMidstreamUpdate(currentFunctionCall, update);
            }
        }
    }

    private static void updateNonIndexedStateItem(@NonNull FunctionCall currentFunctionCall, @NonNull IStateItem<?> stateItem, @NonNull Map<String, List<MidstreamStateItem>> stateUpdates) {
        List<MidstreamStateItem> updates = stateUpdates.get(stateItem.getStateSpec().getId());
        if (updates != null && !updates.isEmpty()) {
            assert (updates.size() == 1);
            MidstreamStateItem update = updates.get(0);
            assert (update != null);
            assert (update.getIndex() == null);
            stateItem.addMidstreamUpdate(currentFunctionCall, update);
        }
    }

    public MidstreamStateItem(@NonNull String stateId, @Nullable Integer index, @Nullable FunctionCallArgumentDescriptor value) {
        this.stateId = stateId;
        this.index = index;
        this.value = value;
    }

    public void dump(String indent, PrintWriter out) {
        out.println(String.valueOf(indent) + this.stateId + (this.index != null ? "[" + this.index + "]" : "") + ": " + this.value);
    }

    public @Nullable Integer getIndex() {
        return this.index;
    }

    public @NonNull String getStateId() {
        return this.stateId;
    }

    public @Nullable FunctionCallArgumentDescriptor getValue() {
        return this.value;
    }

    public String toString() {
        FunctionCallArgumentDescriptor localValue = this.value;
        return "MidstreamStateItem(" + this.stateId + ", " + this.index + ", " + (localValue != null ? (localValue.getRawObjectValue() != null ? localValue.getRawObjectValue() : localValue.getRawAttachmentValue()) : "null") + ")";
    }
}

