/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.midstream;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.LightweightAssetBuilder;
import com.arm.mgd.core.midstream.LightweightFindExistingAssetHelper;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.MidstreamStateItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.TraceStateSnapshotFindExistingAssetHelper;
import com.arm.mgd.core.state.GLESApiVersion;
import com.arm.mgd.core.state.GraphicsContext;
import com.arm.mgd.core.state.GraphicsContextGroup;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.IAssetItemWithParent;
import com.arm.mgd.lightweight.asset.MidstreamAssetFactory;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.attachments.MidstreamDataAttachmentLightweightProcessor;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.model.api.EGLApi;
import com.arm.mgd.lightweight.model.api.GLESApi;
import com.arm.mgd.lightweight.state.IStateItem;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MidstreamDataAttachment
extends AbstractFreeAttachment {
    private static final long serialVersionUID = 7614963398202618946L;
    private final @NonNull List<@NonNull MidstreamAssetItem> assetObjects;
    private final @NonNull Flags flags;
    private final @Nullable Integer sequenceNumber;
    private final @NonNull List<@NonNull MidstreamStateItem> stateItems;

    public static @NonNull List<@NonNull MidstreamAssetItem> sortAssetItems(@NonNull List<@NonNull MidstreamAssetItem> children) {
        children.sort((a, b) -> {
            int byClassResult = a.getAssetClass().compareTo(b.getAssetClass());
            if (byClassResult != 0) {
                return byClassResult;
            }
            int byIdResult = Long.compare(a.getId(), b.getId());
            if (byIdResult != 0) {
                return byIdResult;
            }
            int byInstCounterResult = Long.compare(a.getInstanceCounter(), b.getInstanceCounter());
            assert (byInstCounterResult != 0);
            return byInstCounterResult;
        });
        return children;
    }

    public MidstreamDataAttachment(@NonNull Flags flags, @NonNull List<@NonNull MidstreamStateItem> stateItems, @NonNull List<@NonNull MidstreamAssetItem> assetObjects, @Nullable Integer sequenceNumber) {
        this.flags = flags;
        this.stateItems = stateItems;
        this.assetObjects = MidstreamDataAttachment.sortAssetItems(assetObjects);
        this.sequenceNumber = sequenceNumber;
        assert (flags != Flags.INCOMPLETE || sequenceNumber != null) : "Incomplete midstream packets must contain a sequence number";
    }

    public void dump(@NonNull String indent, @NonNull PrintWriter out) {
        out.println(String.valueOf(indent) + "MidstreamDataAttachment {");
        out.println(String.valueOf(indent) + "    flags: " + (Object)((Object)this.flags));
        out.println(String.valueOf(indent) + "    state: [");
        for (MidstreamStateItem stateItem : this.stateItems) {
            stateItem.dump(String.valueOf(indent) + "        ", out);
            out.flush();
        }
        out.println(String.valueOf(indent) + "    ]");
        out.println(String.valueOf(indent) + "    assets: [");
        for (MidstreamAssetItem asset : this.assetObjects) {
            asset.dump(String.valueOf(indent) + "        ", out);
            out.flush();
        }
        out.println(String.valueOf(indent) + "    ]");
        out.println(String.valueOf(indent) + "}");
        out.flush();
    }

    @Override
    public void earlyPreProcess(@NonNull TraceStateSnapshot currentState) {
        TraceStateSnapshotAssetBuilder eglBuilder = new TraceStateSnapshotAssetBuilder(true, new SnapshotCallbacks(currentState), this, new TraceStateSnapshotFindExistingAssetHelper());
        eglBuilder.updateState();
        if (this.flags.updatesEglState) {
            Pointer currentContextAsset = this.findCurrentContextAssetId();
            FunctionCall functionCall = this.getParentFunctionCall();
            currentState.makeCurrentContext(functionCall.getTid(), currentContextAsset != null ? currentContextAsset : Pointer.NULL, functionCall);
        }
        TraceStateSnapshotAssetBuilder glesBuilder = new TraceStateSnapshotAssetBuilder(false, new SnapshotCallbacks(currentState), this, new TraceStateSnapshotFindExistingAssetHelper());
        glesBuilder.updateState();
    }

    public <M, P extends IAssetItem<M, ?>> @Nullable MidstreamAssetItem findAssetAttachmentFor(@NonNull P assetObject) {
        if (assetObject instanceof IAssetItemWithParent) {
            MidstreamAssetItem parentAttachment = this.findAssetAttachmentFor((P)((IAssetItemWithParent)assetObject).getParentAsset());
            if (parentAttachment == null) {
                return null;
            }
            return this.findAssetAttachmentFor(assetObject, parentAttachment.getChildren());
        }
        return this.findAssetAttachmentFor(assetObject, this.assetObjects);
    }

    public @NonNull List<@NonNull MidstreamAssetItem> getAssetObjects() {
        return Collections.unmodifiableList(this.assetObjects);
    }

    public @NonNull Flags getFlags() {
        return this.flags;
    }

    public @Nullable Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public @NonNull List<@NonNull MidstreamStateItem> getStateItems() {
        return Collections.unmodifiableList(this.stateItems);
    }

    public @NonNull Map<String, List<MidstreamStateItem>> getStateItemsAsMap() {
        return this.stateItems.stream().collect(Collectors.groupingBy(entry -> entry.getStateId()));
    }

    public @NonNull MidstreamDataAttachment mergeIncomplete(@NonNull MidstreamDataAttachment streamSoFar) throws IllegalArgumentException {
        if (streamSoFar.flags != Flags.INCOMPLETE) {
            throw new IllegalArgumentException("Invalid flags");
        }
        Integer ourSequenceNumber = this.sequenceNumber;
        Integer thereSequenceNumber = streamSoFar.sequenceNumber;
        if (ourSequenceNumber == null || thereSequenceNumber == null || ourSequenceNumber != thereSequenceNumber + 1) {
            throw new IllegalArgumentException("Invalid sequence number");
        }
        if (streamSoFar.getStateItems().size() != 0) {
            throw new IllegalArgumentException("Invalid state item list");
        }
        this.assetObjects.addAll(streamSoFar.assetObjects);
        if (this.flags != Flags.INCOMPLETE) {
            MidstreamDataAttachment.sortAssetItems(this.assetObjects);
        }
        return this;
    }

    @Override
    public void process(@NonNull TraceStateSnapshot currentState) {
    }

    @Override
    public <M> void processLightweightPreCallProcessor(@NonNull Class<M> clazz, @NonNull ILightweightAssetProcessorCallbacks<M> callbacks) throws Exception {
        if (clazz == EGLApi.class) {
            EGLLightweightAssetBuilderCallbacks callbacksAdapter = new EGLLightweightAssetBuilderCallbacks(callbacks);
            MidstreamDataAttachmentLightweightProcessor.CallProcessor<EGLApi> processor = new MidstreamDataAttachmentLightweightProcessor.CallProcessor<EGLApi>(this, new LightweightAssetBuilder.EglLightweightAssetBuilder(this, callbacksAdapter, KapiSpec.EGL.getAssetClassLookup(), (MidstreamAssetFactory.FindExistingAssetHelper)new LightweightFindExistingAssetHelper()));
            processor.execute(callbacks, this.getParentFunctionCall());
        } else if (clazz == GLESApi.class) {
            GLESLightweightAssetBuilderCallbacks callbacksAdapter = new GLESLightweightAssetBuilderCallbacks(callbacks);
            MidstreamDataAttachmentLightweightProcessor.CallProcessor<GLESApi> processor = new MidstreamDataAttachmentLightweightProcessor.CallProcessor<GLESApi>(this, new LightweightAssetBuilder.GlesLightweightAssetBuilder(this, callbacksAdapter, KapiSpec.GLES.getAssetClassLookup(), (MidstreamAssetFactory.FindExistingAssetHelper)new LightweightFindExistingAssetHelper()));
            processor.execute(callbacks, this.getParentFunctionCall());
        }
    }

    @Override
    public <M, P extends IAssetItem<M, V>, V extends IAssetItem.Value<P>> @NonNull V processLightweightValue(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject, @NonNull V value) throws Exception {
        MidstreamDataAttachmentLightweightProcessor.ValueProcessor processor = new MidstreamDataAttachmentLightweightProcessor.ValueProcessor(this);
        return processor.execute(callbacks, assetObject, value);
    }

    private <M, P extends IAssetItem<M, ?>> boolean assetUniqueInstanceNosMatch(@NonNull P assetObject, long instanceCounter) {
        return assetObject.getUniqueInstanceId().instanceCounter == instanceCounter || LightweightAssetBuilder.shouldAlwaysReuseExistingAsset(assetObject, !assetObject.getLifecycleManager().isAssetRetained(this.getParentFunctionCall().getID()));
    }

    private <M, P extends IAssetItem<M, ?>> @Nullable MidstreamAssetItem findAssetAttachmentFor(@NonNull P assetObject, @NonNull List<@NonNull MidstreamAssetItem> attachmentItems) {
        for (MidstreamAssetItem attachmentItem : attachmentItems) {
            if (!attachmentItem.getAssetClass().equals(assetObject.getClass().getSimpleName()) || attachmentItem.getId() != assetObject.getId().asLong() || !this.assetUniqueInstanceNosMatch(assetObject, attachmentItem.getInstanceCounter())) continue;
            return attachmentItem;
        }
        return null;
    }

    private @Nullable Pointer findCurrentContextAssetId() {
        for (MidstreamStateItem stateItem : this.stateItems) {
            if (!stateItem.getStateId().equals(KapiSpec.EGL.states.EGL_CURRENT_CONTEXT.getId())) continue;
            FunctionCallArgumentDescriptor value = stateItem.getValue();
            return value != null ? value.getObjectValue(KapiSpec.EGL, Pointer.class) : null;
        }
        return null;
    }

    private class EGLLightweightAssetBuilderCallbacks
    implements LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<EGLApi> {
        private final @NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks;

        public EGLLightweightAssetBuilderCallbacks(ILightweightAssetProcessorCallbacks<EGLApi> callbacks) {
            this.callbacks = callbacks;
        }

        @Override
        public void addMidstreamTraceStateUpdates(@NonNull FunctionCall functionCall, @NonNull Map<String, List<MidstreamStateItem>> items) {
            this.callbacks.addMidstreamTraceStateUpdates(functionCall, items);
        }

        @Override
        public void deleteAllAssets(@Nullable EglContextAsset currentContext, @NonNull FunctionCall functionCall, @NonNull Predicate<@NonNull IAssetItem<EGLApi, ?>> isRetained) {
            TracedProcess tracedProcess = this.callbacks.getTracedProcess();
            tracedProcess.getEglModel().deleteAllAssetsForMidstreamTrace(functionCall, isRetained);
        }

        @Override
        public void deleteAllGlesContextAssets(@NonNull EglContextAsset currentContext, @NonNull FunctionCall functionCall, @NonNull Predicate<@NonNull IAssetItem<EGLApi, ?>> isRetained) {
        }

        @Override
        public void deleteAllGlesContextGroupAssets(@NonNull EglContextAsset currentContext, @NonNull FunctionCall functionCall, @NonNull Predicate<@NonNull IAssetItem<EGLApi, ?>> isRetained) {
        }

        @Override
        public <T extends IAssetItem<EGLApi, ?>> void doMidstreamProcessingForLightweightAsset(@NonNull AbstractFreeAttachment attachment, @NonNull T asset) throws Exception {
            attachment.setParentMidstreamDataAttachment(MidstreamDataAttachment.this);
            attachment.doMidstreamProcessingForLightweightAsset(this.callbacks, asset);
        }

        @Override
        public <T extends IAssetItem<EGLApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, @NonNull FunctionCallID currentFunctionCallID, @NonNull AssetItemID id, boolean live) {
            return this.callbacks.getAssetObject(traits, currentFunctionCallID, id, live);
        }

        @Override
        public <T extends IAssetItem<EGLApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, FunctionCallID currentFunctionCallID, AssetItemID id, @Nullable Long specificInstanceId) {
            return this.callbacks.getAssetObject(traits, currentFunctionCallID, id, specificInstanceId);
        }

        @Override
        public String getCoreLoggingSourceKey() {
            return this.callbacks.getCoreLoggingSourceKey();
        }

        @Override
        public @Nullable EglContextAsset getCurrentEglContextAsset() {
            return this.callbacks.getTracedProcess().getEglModel().getEglContextForFunctionCall(MidstreamDataAttachment.this.getParentFunctionCall());
        }

        @Override
        public @Nullable EglContextAsset getEglContextAsset(Pointer displayId, Pointer contextId) {
            EglDisplayAsset displayAsset = this.callbacks.getAssetObject(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, MidstreamDataAttachment.this.getParentFunctionCall().getID(), AssetItemID.valueOf(displayId), true);
            if (displayAsset == null) {
                return null;
            }
            return displayAsset.getEglContextAssetAt(MidstreamDataAttachment.this.getParentFunctionCall().getID(), AssetItemID.valueOf(contextId), true);
        }

        @Override
        public @Nullable FunctionCall getLastProcessedCall() {
            return this.callbacks.getLastProcessedCall();
        }

        @Override
        public IStateItem<?> getStateItem(FunctionCall currentFunctionCall, StateSpec stateSpec) throws IllegalArgumentException {
            return this.callbacks.getStateItem(currentFunctionCall, stateSpec);
        }

        @Override
        public TracedProcess getTracedProcess() {
            return this.callbacks.getTracedProcess();
        }

        @Override
        public <T extends IAssetItem<EGLApi, ?>> void insertNewAsset(T newAsset) {
            this.callbacks.insertNewAsset(newAsset);
        }

        @Override
        public boolean isIgnoredCall(@NonNull FunctionCall functionCall, boolean isLocalScope) {
            return this.callbacks.isIgnoredCall(functionCall, isLocalScope);
        }

        @Override
        public <T extends IAssetItem<EGLApi, ?>> void onAssetCreated(T newAsset) {
            this.callbacks.onAssetCreated(newAsset);
        }
    }

    public static enum Flags {
        CONTEXT(false, false),
        CONTEXT_AND_GROUP(false, true),
        GLOBAL(true, true),
        INCOMPLETE(false, false),
        THREAD_AND_CONTEXT(true, false),
        THREAD_CONTEXT_AND_GROUP(true, true);

        public final boolean updatesEglState;
        public final boolean updatesSharedGlesAssets;

        private Flags(boolean updatesEglState, boolean updatesSharedGlesAssets) {
            this.updatesEglState = updatesEglState;
            this.updatesSharedGlesAssets = updatesSharedGlesAssets;
        }
    }

    private class GLESLightweightAssetBuilderCallbacks
    implements LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> {
        private final @NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks;

        public GLESLightweightAssetBuilderCallbacks(ILightweightAssetProcessorCallbacks<GLESApi> callbacks) {
            this.callbacks = callbacks;
        }

        @Override
        public void addMidstreamTraceStateUpdates(@NonNull FunctionCall functionCall, @NonNull Map<String, List<MidstreamStateItem>> items) {
            this.callbacks.addMidstreamTraceStateUpdates(functionCall, items);
        }

        @Override
        public void deleteAllAssets(@Nullable EglContextAsset currentContext, @NonNull FunctionCall functionCall, @NonNull Predicate<@NonNull IAssetItem<GLESApi, ?>> isRetained) {
            if (currentContext != null) {
                this.deleteAllGlesContextGroupAssets(currentContext, functionCall, isRetained);
            }
        }

        @Override
        public void deleteAllGlesContextAssets(@NonNull EglContextAsset currentContext, @NonNull FunctionCall functionCall, @NonNull Predicate<@NonNull IAssetItem<GLESApi, ?>> isRetained) {
            TracedProcess tracedProcess = this.callbacks.getTracedProcess();
            GlesContext context = tracedProcess.getGlesModel().getContextForEGLContext(currentContext);
            assert (context != null);
            tracedProcess.getGlesModel().deleteAllAssetsForContextForMidstreamTrace(context, this.callbacks, functionCall, isRetained);
        }

        @Override
        public void deleteAllGlesContextGroupAssets(@NonNull EglContextAsset currentContext, @NonNull FunctionCall functionCall, @NonNull Predicate<@NonNull IAssetItem<GLESApi, ?>> isRetained) {
            TracedProcess tracedProcess = this.callbacks.getTracedProcess();
            GlesContext context = tracedProcess.getGlesModel().getContextForEGLContext(currentContext);
            assert (context != null);
            tracedProcess.getGlesModel().deleteAllAssetsForContextGroupForMidstreamTrace(context, this.callbacks, functionCall, isRetained);
        }

        @Override
        public <T extends IAssetItem<GLESApi, ?>> void doMidstreamProcessingForLightweightAsset(@NonNull AbstractFreeAttachment attachment, @NonNull T asset) throws Exception {
            attachment.setParentMidstreamDataAttachment(MidstreamDataAttachment.this);
            attachment.doMidstreamProcessingForLightweightAsset(this.callbacks, asset);
        }

        @Override
        public <T extends IAssetItem<GLESApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, @NonNull FunctionCallID currentFunctionCallID, @NonNull AssetItemID id, boolean live) {
            return this.callbacks.getAssetObject(traits, currentFunctionCallID, id, live);
        }

        @Override
        public <T extends IAssetItem<GLESApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, @NonNull FunctionCallID currentFunctionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
            return this.callbacks.getAssetObject(traits, currentFunctionCallID, id, specificInstanceId);
        }

        @Override
        public @NonNull String getCoreLoggingSourceKey() {
            return this.callbacks.getCoreLoggingSourceKey();
        }

        @Override
        public @Nullable EglContextAsset getCurrentEglContextAsset() {
            return this.callbacks.getTracedProcess().getEglModel().getEglContextForFunctionCall(MidstreamDataAttachment.this.getParentFunctionCall());
        }

        @Override
        public @Nullable EglContextAsset getEglContextAsset(@NonNull Pointer displayId, @NonNull Pointer contextId) {
            FunctionCallID targetCallID = MidstreamDataAttachment.this.getParentFunctionCall().getID();
            ILightweightAssetProcessorCallbacks<EGLApi> eglCallbacks = this.callbacks.getTracedProcess().getEglModel().getAssetProcessorCallbacks();
            EglDisplayAsset displayAsset = eglCallbacks.getAssetObject(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, targetCallID, AssetItemID.valueOf(displayId), true);
            if (displayAsset == null) {
                return null;
            }
            return displayAsset.getEglContextAssetAt(targetCallID, AssetItemID.valueOf(contextId), true);
        }

        @Override
        public @Nullable FunctionCall getLastProcessedCall() {
            return this.callbacks.getLastProcessedCall();
        }

        @Override
        public @NonNull IStateItem<?> getStateItem(@NonNull FunctionCall currentFunctionCall, @NonNull StateSpec stateSpec) throws IllegalArgumentException {
            return this.callbacks.getStateItem(currentFunctionCall, stateSpec);
        }

        @Override
        public @NonNull TracedProcess getTracedProcess() {
            return this.callbacks.getTracedProcess();
        }

        @Override
        public <T extends IAssetItem<GLESApi, ?>> void insertNewAsset(T newAsset) {
            this.callbacks.insertNewAsset(newAsset);
        }

        @Override
        public boolean isIgnoredCall(@NonNull FunctionCall functionCall, boolean isLocalScope) {
            return this.callbacks.isIgnoredCall(functionCall, isLocalScope);
        }

        @Override
        public <T extends IAssetItem<GLESApi, ?>> void onAssetCreated(T newAsset) {
            this.callbacks.onAssetCreated(newAsset);
        }
    }

    private class SnapshotCallbacks
    implements TraceStateSnapshotAssetBuilder.ISnapshotCallbacks {
        private final @NonNull TraceStateSnapshot currentState;

        public SnapshotCallbacks(TraceStateSnapshot currentState) {
            this.currentState = currentState;
        }

        @Override
        public void addAsset(@NonNull com.arm.mgd.core.asset.IAssetItem asset) {
            assert (!(asset instanceof com.arm.mgd.core.asset.objects.IAssetItemWithParent));
            this.currentState.addAsset(asset);
        }

        @Override
        public void clearCurrentContext() {
            GraphicsContext context = this.currentState.getCurrentContext();
            if (!context.isGlobalContext()) {
                context.clearGlobalAssetState(MidstreamDataAttachment.this.getParentFunctionCall());
            }
        }

        @Override
        public void clearCurrentContextGroup() {
            GraphicsContextGroup contextGroup = this.currentState.getCurrentContext().contextGroup;
            if (!contextGroup.isGlobalGroup()) {
                contextGroup.clearGlobalAssetState(MidstreamDataAttachment.this.getParentFunctionCall());
            }
        }

        @Override
        public void clearGlobalState() {
            this.currentState.clearGlobalAssetState(MidstreamDataAttachment.this.getParentFunctionCall());
        }

        @Override
        public void createContext(@NonNull Pointer contextId, @Nullable Pointer sharedContextId, @NonNull GLESApiVersion apiVersion, @NonNull FunctionCall functionCall) {
            this.currentState.createContext(contextId, sharedContextId, apiVersion, functionCall);
        }

        @Override
        public void doMidstreamProcessingForAsset(@NonNull AbstractFreeAttachment freeAttachment, @NonNull com.arm.mgd.core.asset.IAssetItem result) throws Exception {
            freeAttachment.setParentMidstreamDataAttachment(MidstreamDataAttachment.this);
            freeAttachment.doMidstreamProcessingForAsset(this.currentState, result);
        }

        @Override
        public <TYPE extends com.arm.mgd.core.asset.IAssetItem> @Nullable TYPE getAssetById(KapiSpec.AssetTraits<TYPE, ?, ?> traits, long id) {
            AssetTable assetTable = this.currentState.getAssetTableBySpec(traits.SPEC);
            return (TYPE)assetTable.get((Long)id);
        }

        @Override
        public @NonNull String getCoreLoggingSourceKey() {
            return this.currentState.getModel().getCoreLoggingSourceKey();
        }

        @Override
        public @NonNull TraceDataModel getModel() {
            return this.currentState.getModel();
        }

        @Override
        public @NonNull ISnapshotAssetParent getSnapshotAssetParent() {
            return this.currentState.asSnapshotAssetParent();
        }
    }
}

