/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.midstream;

import com.arm.mgd.core.midstream.MidstreamAssetItemProperty;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MidstreamAssetItem
implements Serializable {
    private static final long serialVersionUID = -3648960034542548515L;
    private final @NonNull String assetClass;
    private final @NonNull List<@NonNull MidstreamAssetItem> children;
    private final @NonNull List<@NonNull AbstractFreeAttachment> freeAttachments;
    private final long id;
    private final long instanceCounter;
    private final @NonNull Map<@NonNull String, @NonNull MidstreamAssetItemProperty> properties;

    public MidstreamAssetItem(@NonNull String assetClass, long id, long instanceCounter, @NonNull List<@NonNull MidstreamAssetItemProperty> properties, @NonNull List<@NonNull MidstreamAssetItem> children, @NonNull List<@NonNull AbstractFreeAttachment> freeAttachments) {
        this.assetClass = assetClass;
        this.id = id;
        this.instanceCounter = instanceCounter;
        this.properties = new HashMap<String, MidstreamAssetItemProperty>();
        this.properties.putAll(properties.stream().collect(Collectors.toMap(p -> p.getName(), p -> p)));
        this.children = MidstreamDataAttachment.sortAssetItems(children);
        this.freeAttachments = freeAttachments;
    }

    public void dump(String indent, PrintWriter out) {
        out.println(String.valueOf(indent) + this.assetClass + " {");
        out.println(String.valueOf(indent) + "    id: " + this.id);
        out.println(String.valueOf(indent) + "    instanceCounter: " + this.instanceCounter);
        for (MidstreamAssetItemProperty property : this.properties.values()) {
            out.println(String.valueOf(indent) + "    " + property.getName() + ": " + property.getValue());
        }
        if (this.children.size() > 0) {
            out.println(String.valueOf(indent) + "    children: [");
            for (MidstreamAssetItem child : this.children) {
                child.dump(String.valueOf(indent) + "        ", out);
            }
            out.println(String.valueOf(indent) + "    ]");
        }
        out.println(String.valueOf(indent) + "}");
        out.flush();
    }

    public @NonNull String getAssetClass() {
        return this.assetClass;
    }

    public @NonNull List<@NonNull MidstreamAssetItem> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public @NonNull List<@NonNull AbstractFreeAttachment> getFreeAttachments() {
        return Collections.unmodifiableList(this.freeAttachments);
    }

    public long getId() {
        return this.id;
    }

    public long getInstanceCounter() {
        return this.instanceCounter;
    }

    public @NonNull List<@NonNull MidstreamAssetItemProperty> getProperties() {
        return new ArrayList<MidstreamAssetItemProperty>(this.properties.values());
    }

    public @Nullable MidstreamAssetItemProperty getProperty(@NonNull String propertyName) {
        return this.properties.get(propertyName);
    }
}

