/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.midstream;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.AbstractAssetBuilder;
import com.arm.mgd.core.midstream.AbstractMidstreamAssetItemPropertyValue;
import com.arm.mgd.core.midstream.LightweightAssetBuilder;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.MidstreamAssetItemProperty;
import com.arm.mgd.core.midstream.MidstreamAssetItemPropertySingleValue;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.IAssetItemWithChildren;
import com.arm.mgd.lightweight.asset.IAssetItemWithParent;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class LightweightAssetValueBuilder<API_MODEL>
extends AbstractAssetBuilder<IAssetItem<API_MODEL, ?>, LightweightAssetBuilder.LightweightAssetReference<API_MODEL>> {
    private final MidstreamDataAttachment attachment;
    private final ILightweightAssetProcessorCallbacks<API_MODEL> callbacks;

    public LightweightAssetValueBuilder(ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, MidstreamDataAttachment attachment) {
        super(LightweightAssetBuilder.LightweightAssetReference.class);
        this.callbacks = callbacks;
        this.attachment = attachment;
    }

    public ILightweightAssetProcessorCallbacks<API_MODEL> getAssetProcessorCallbacks() {
        return this.callbacks;
    }

    public final <T extends IAssetItem<API_MODEL, ?>> @Nullable T resolveAssetProperty(MidstreamAssetItem assetAttachment, String propertyName, Class<T> expectedType, boolean optional, @Nullable T defaultValue) {
        return (T)((IAssetItem)this.resolveProperty(assetAttachment, propertyName, expectedType, optional, defaultValue));
    }

    public final <P extends IAssetItemWithChildren<API_MODEL, ?, C>, C extends IAssetItemWithParent<API_MODEL, ?, P>, T extends C> @Nullable T resolveAssetProperty(MidstreamAssetItem assetAttachment, String propertyName, Class<T> expectedType, @NonNull P parentAsset, boolean optional, @Nullable T defaultValue) {
        MidstreamAssetItemProperty property = LightweightAssetValueBuilder.getPropertyByName(assetAttachment, propertyName);
        if (property != null) {
            AbstractMidstreamAssetItemPropertyValue container = property.getValue();
            if (container == null) {
                this.logMissingAssetProperty(assetAttachment, propertyName, optional);
                return defaultValue;
            }
            assert (container instanceof MidstreamAssetItemPropertySingleValue);
            KapiSpec.AssetTraits<?, ?, ?> traits = this.lookupAssetClass(assetAttachment.getAssetClass());
            assert (traits != null);
            MidstreamAssetItemPropertySingleValue singleContainer = (MidstreamAssetItemPropertySingleValue)container;
            FunctionCallArgumentDescriptor value = singleContainer.getValue();
            LightweightAssetBuilder.LightweightAssetReference idPropertyValue = this.getPropertyValue(LightweightAssetBuilder.LightweightAssetReference.class, value, traits.getKapiSpec());
            if (idPropertyValue == null) {
                return null;
            }
            return (T)((IAssetItemWithParent)this.findAssetObjectForPropertyValue(expectedType, (IAssetItem<API_MODEL, ?>)parentAsset, idPropertyValue));
        }
        this.logMissingAssetProperty(assetAttachment, propertyName, optional);
        return defaultValue;
    }

    @Override
    protected <T extends IAssetItem<API_MODEL, ?>> @Nullable T findAssetObjectForPropertyValue(Class<T> expectedType, @Nullable IAssetItem<API_MODEL, ?> parentAsset, LightweightAssetBuilder.LightweightAssetReference<API_MODEL> assetId) {
        KapiSpec.AssetTraits<?, ?, ?> traits = this.lookupAssetClass(expectedType.getSimpleName());
        assert (traits != null);
        if (parentAsset == null) {
            return (T)this.callbacks.getAssetObject(traits, this.attachment.getParentFunctionCall().getID(), AssetItemID.valueOf(assetId.getAssetId()), assetId.instanceNo);
        }
        return (T)((IAssetItemWithChildren)parentAsset).getLastAssetBefore(traits, AssetItemID.valueOf(assetId.getAssetId()), this.attachment.getParentFunctionCall().getID(), assetId.instanceNo);
    }

    @Override
    protected boolean isAssetObjectClassType(Class<?> clazz) {
        return IAssetItem.class.isAssignableFrom(clazz);
    }

    @Override
    protected @Nullable KapiSpec.AssetTraits<?, ?, ?> lookupAssetClass(String classname) {
        for (KapiSpec kapiSpec : KapiSpec.getAvailableKapiSpecs()) {
            KapiSpec.AssetTraits<?, IAssetItem<?, ?>, ?> result = kapiSpec.getAssetClassLookup().getAssetTraitsByName(classname);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

