/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.midstream;

import com.arm.mgd.core.target.data.ArgumentContainerAttachment;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AssetReference<ATYPE, PTYPE extends ATYPE, CTYPE extends ATYPE, RTYPE extends AssetReference<ATYPE, PTYPE, CTYPE, RTYPE>> {
    protected final @Nullable String assetClass;
    protected final long assetId;
    protected final @Nullable Long instanceNo;
    protected final @Nullable RTYPE parentAssetReference;

    public AssetReference(ArgumentContainerAttachment attachment) {
        List<@NonNull FunctionCallArgumentDescriptor> members = attachment.getMembers();
        assert (members.size() == 4);
        this.assetClass = members.get(0).getObjectValue(null, String.class);
        this.assetId = ((Number)NullUtils.neverNull((Object)members.get(1).getObjectValue(null, Number.class))).longValue();
        this.instanceNo = ((Number)NullUtils.neverNull((Object)members.get(2).getObjectValue(null, Number.class))).longValue();
        ArgumentContainerAttachment parentContainerDescriptor = members.get(3).getObjectValue(null, ArgumentContainerAttachment.class);
        this.parentAssetReference = parentContainerDescriptor == null || parentContainerDescriptor.getMembers().isEmpty() ? null : this.createParentAssetReference(parentContainerDescriptor);
    }

    public AssetReference(Long assetId) {
        this.assetClass = null;
        this.assetId = assetId;
        this.instanceNo = null;
        this.parentAssetReference = null;
    }

    public @Nullable String getAssetClass() {
        return this.assetClass;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public @Nullable Long getInstanceNo() {
        return this.instanceNo;
    }

    public @Nullable RTYPE getParentAssetReference() {
        return this.parentAssetReference;
    }

    public final boolean isBestMatch(@NonNull ATYPE assetToMatch, @Nullable PTYPE parentAsset, @Nullable ATYPE currentBest) {
        boolean bestParentIsExactMatch;
        ATYPE bestParent;
        Long localInstanceNo = this.instanceNo;
        @Nullable RTYPE localParentAssetReference = this.parentAssetReference;
        long instanceNumber = localInstanceNo != null ? localInstanceNo : Long.MIN_VALUE;
        long assetToMatchId = this.getAssetId(assetToMatch);
        long assetInstanceNo = this.getAssetInstanceNo(assetToMatch);
        long currentBestInstanceNo = currentBest != null ? this.getAssetInstanceNo(assetToMatch) : Long.MIN_VALUE;
        @Nullable PTYPE assetParent = this.getAssetParent(assetToMatch);
        ATYPE ATYPE = bestParent = currentBest != null ? (ATYPE)this.getAssetParent(currentBest) : null;
        if (assetToMatchId != this.assetId) {
            return false;
        }
        if (parentAsset != null) {
            if (!this.isSameParent(parentAsset, assetToMatch)) {
                return false;
            }
            assert (currentBest == null || this.isSameParent(parentAsset, currentBest));
        }
        boolean assetNoIsLessThanInstanceNoButCloserThanCurrentBest = assetInstanceNo <= instanceNumber && (currentBestInstanceNo < assetInstanceNo || instanceNumber < currentBestInstanceNo);
        boolean assetNoIsGreaterThanInstanceNoButCloserThanCurrentBest = assetInstanceNo > instanceNumber && assetInstanceNo < currentBestInstanceNo;
        boolean assetNoIsBestMatchAndHasNoInstNoVal = localInstanceNo != null && assetInstanceNo > currentBestInstanceNo;
        boolean assetParentIsExactMatch = localParentAssetReference != null && assetParent != null && ((AssetReference)localParentAssetReference).isExactMatch(assetParent, this.getAssetParent(assetParent));
        boolean bl = bestParentIsExactMatch = localParentAssetReference != null && bestParent != null && ((AssetReference)localParentAssetReference).isExactMatch(bestParent, this.getAssetParent(bestParent));
        if (assetToMatch != currentBest && !(assetParentIsExactMatch ^ bestParentIsExactMatch) && (assetParentIsExactMatch || bestParentIsExactMatch)) assert (assetToMatch == currentBest || assetParentIsExactMatch ^ bestParentIsExactMatch || !assetParentIsExactMatch && !bestParentIsExactMatch) : "Both assetToMatch and currentBest have the same parent which is an exact match to " + localParentAssetReference;
        boolean assetParentIsBestMatch = assetParentIsExactMatch && !bestParentIsExactMatch;
        boolean isBestMatch = currentBest == null || assetNoIsLessThanInstanceNoButCloserThanCurrentBest || assetNoIsGreaterThanInstanceNoButCloserThanCurrentBest || assetNoIsBestMatchAndHasNoInstNoVal || assetParentIsBestMatch;
        return isBestMatch;
    }

    public final boolean isExactMatch(@NonNull ATYPE assetToMatch, @Nullable PTYPE parentAsset) {
        Long localInstanceNo = this.instanceNo;
        @Nullable RTYPE localParentAssetReference = this.parentAssetReference;
        long assetToMatchId = this.getAssetId(assetToMatch);
        long assetInstanceNo = this.getAssetInstanceNo(assetToMatch);
        @Nullable PTYPE assetParent = this.getAssetParent(assetToMatch);
        if (assetToMatchId != this.assetId) {
            return false;
        }
        if (localInstanceNo == null) {
            return false;
        }
        if (assetInstanceNo != localInstanceNo) {
            return false;
        }
        if (parentAsset == null) {
            return true;
        }
        if (assetParent != null && assetParent == parentAsset) {
            assert (localParentAssetReference != null);
            @Nullable PTYPE parentsParent = this.getAssetParent(assetParent);
            return ((AssetReference)localParentAssetReference).isExactMatch(assetParent, parentsParent);
        }
        return false;
    }

    public String toString() {
        return "AssetReference {" + this.assetClass + ", " + this.assetId + ", " + this.instanceNo + ", " + this.parentAssetReference + "}";
    }

    protected abstract RTYPE createParentAssetReference(ArgumentContainerAttachment var1);

    protected abstract long getAssetId(@NonNull ATYPE var1);

    protected abstract long getAssetInstanceNo(@NonNull ATYPE var1);

    protected abstract @Nullable PTYPE getAssetParent(@NonNull ATYPE var1);

    protected final boolean isSameParent(@NonNull PTYPE parentAsset, @NonNull CTYPE childAsset) {
        long childsParentId;
        @Nullable RTYPE localParentAssetReference = this.parentAssetReference;
        @Nullable PTYPE childsParent = this.getAssetParent(childAsset);
        long parentId = this.getAssetId(parentAsset);
        long l = childsParentId = childsParent != null ? this.getAssetId(parentAsset) : -1L;
        if (childsParent == parentAsset) {
            return localParentAssetReference == null || ((AssetReference)localParentAssetReference).assetId == parentId;
        }
        if (childsParent != null && childsParentId == parentId) {
            @Nullable PTYPE parentsParent = this.getAssetParent(parentAsset);
            if (localParentAssetReference != null) {
                if (((AssetReference)localParentAssetReference).assetId != parentId) {
                    return false;
                }
                if (parentsParent != null) {
                    return ((AssetReference)localParentAssetReference).isSameParent(parentsParent, childsParent);
                }
                return true;
            }
            if (parentsParent != null) {
                return this.isSameParent(parentsParent, childsParent);
            }
            return true;
        }
        assert (childsParent != null);
        return false;
    }
}

