/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.midstream;

import com.arm.mgd.core.kapi.IConstantOrAliasSpecContainer;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.AbstractMidstreamAssetItemPropertyValue;
import com.arm.mgd.core.midstream.AssetReference;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.MidstreamAssetItemProperty;
import com.arm.mgd.core.midstream.MidstreamAssetItemPropertyMapEntryValue;
import com.arm.mgd.core.midstream.MidstreamAssetItemPropertyMapValue;
import com.arm.mgd.core.midstream.MidstreamAssetItemPropertySingleValue;
import com.arm.mgd.core.target.data.ArrayArgumentAttachment;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.utils.NullUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractAssetBuilder<ASSET_TYPE, REF_TYPE extends AssetReference<ASSET_TYPE, ?, ?, REF_TYPE>> {
    private final @NonNull Class<REF_TYPE> referenceClass;

    protected static @Nullable MidstreamAssetItemProperty getPropertyByName(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName) {
        return assetAttachment.getProperty(propertyName);
    }

    private static float @Nullable [] transformToFloatArray(Number @Nullable [] array) {
        if (array == null) {
            return null;
        }
        float[] result = new float[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i] != null ? array[i].floatValue() : 0.0f;
            ++i;
        }
        return result;
    }

    protected AbstractAssetBuilder(@NonNull Class<REF_TYPE> referenceClass) {
        this.referenceClass = referenceClass;
    }

    public final <T> @Nullable T getPropertyValue(@NonNull Class<T> expectedType, @NonNull FunctionCallArgumentDescriptor valueDescriptor, @Nullable IConstantOrAliasSpecContainer constantSource) {
        if (this.isAssetObjectClassType(expectedType)) {
            AssetReference idPropertyValue = (AssetReference)this.getPropertyValue(this.referenceClass, valueDescriptor, constantSource);
            if (idPropertyValue == null) {
                return null;
            }
            return this.findAssetObjectForPropertyValue(expectedType, null, idPropertyValue);
        }
        return valueDescriptor.getObjectValue(constantSource, expectedType);
    }

    public final <T> T @NonNull [] resolveArrayProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, @NonNull Class<T> elementClass, boolean optional) {
        if (elementClass.equals(Float.TYPE)) {
            return AbstractAssetBuilder.transformToFloatArray(this.resolveArrayProperty(assetAttachment, propertyName, Float.class, optional));
        }
        List<Object> listValue = this.resolveListProperty(assetAttachment, propertyName, elementClass, optional, optional ? null : new ArrayList());
        return listValue.toArray((Object[])Array.newInstance(elementClass, listValue.size()));
    }

    public final boolean resolveBooleanProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, boolean defaultValue) {
        return this.resolveLongProperty(assetAttachment, propertyName, defaultValue ? -1L : 0L) != 0L;
    }

    public final byte @NonNull [] resolveByteDataProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, boolean optional) {
        return ((IByteDataProvider)NullUtils.neverNull((Object)this.resolveProperty(assetAttachment, propertyName, IByteDataProvider.class, optional, IByteDataProvider.EMPTY))).cloneData();
    }

    public final @Nullable AbstractConstantOrAliasSpecExtended resolveConstantProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> validConstants, boolean optional, @Nullable AbstractConstantOrAliasSpecExtended defaultValue) {
        Object propertyValue = this.resolveProperty(assetAttachment, propertyName, Number.class, true, null);
        if (propertyValue == null) {
            this.logMissingAssetProperty(assetAttachment, propertyName, optional);
            assert (defaultValue != null || optional);
            return defaultValue;
        }
        assert (propertyValue instanceof Number);
        long value = ((Number)propertyValue).longValue();
        for (AbstractConstantOrAliasSpecExtended constant : validConstants) {
            if (constant.getResolvedValue() != value) continue;
            return constant;
        }
        KapiSpec.AssetTraits<?, ?, ?> traits = this.lookupAssetClass(assetAttachment.getAssetClass());
        assert (traits != null);
        return traits.getKapiSpec().getConstantSpecByValue(NullUtils.longValueOf((long)value));
    }

    public final float @Nullable [] resolveFloatArrayProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, boolean optional) {
        return AbstractAssetBuilder.transformToFloatArray(this.resolveArrayProperty(assetAttachment, propertyName, Float.class, optional));
    }

    public float resolveFloatProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, float defaultValue) {
        Float propertyValue = this.resolveProperty(assetAttachment, propertyName, Number.class, false, Float.valueOf(defaultValue));
        assert (propertyValue != null);
        assert (propertyValue instanceof Number);
        return ((Number)propertyValue).floatValue();
    }

    public final int resolveIntProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, int defaultValue) {
        Integer propertyValue = this.resolveProperty(assetAttachment, propertyName, Number.class, false, defaultValue);
        assert (propertyValue != null);
        assert (propertyValue instanceof Number);
        return ((Number)propertyValue).intValue();
    }

    public final <T> @NonNull List<T> resolveListProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, @NonNull Class<T> elementClass, boolean optional, @Nullable List<T> defaultValue) {
        Class expectedClass = elementClass.equals(Float.class) ? FloatsArgAttachment.class : (elementClass.equals(Integer.class) || elementClass.equals(Long.class) || elementClass.equals(AbstractConstantOrAliasSpecExtended.class) ? LongsArgAttachment.class : (elementClass.equals(String.class) ? StringsArgAttachment.class : ArrayArgumentAttachment.class));
        ArrayArgumentAttachment values = this.resolveProperty(assetAttachment, propertyName, expectedClass, true, null);
        if (values == null) {
            return optional ? defaultValue : new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Object value : values) {
            result.add(this.transformListItem(assetAttachment, elementClass, optional, value));
        }
        return result;
    }

    public final long resolveLongProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, long defaultValue) {
        Long propertyValue = this.resolveProperty(assetAttachment, propertyName, Number.class, false, defaultValue);
        assert (propertyValue != null);
        assert (propertyValue instanceof Number);
        return ((Number)propertyValue).longValue();
    }

    public final <K, V> @NonNull Map<K, V> resolveMapProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, @NonNull Class<K> keyClass, @NonNull Class<V> valueClass) {
        MidstreamAssetItemProperty property = AbstractAssetBuilder.getPropertyByName(assetAttachment, propertyName);
        if (property != null) {
            AbstractMidstreamAssetItemPropertyValue container = property.getValue();
            assert (container == null || container instanceof MidstreamAssetItemPropertyMapValue);
            MidstreamAssetItemPropertyMapValue mapContainer = (MidstreamAssetItemPropertyMapValue)container;
            if (mapContainer != null) {
                KapiSpec.AssetTraits<?, ?, ?> traits = this.lookupAssetClass(assetAttachment.getAssetClass());
                assert (traits != null);
                return this.getMapPropertyValue(mapContainer, keyClass, valueClass, traits.getKapiSpec());
            }
            return new HashMap();
        }
        this.logMissingAssetProperty(assetAttachment, propertyName, false);
        return new HashMap();
    }

    public final <T> @Nullable T resolveProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, @NonNull Class<T> expectedType, boolean optional, @Nullable T defaultValue) {
        MidstreamAssetItemProperty property = AbstractAssetBuilder.getPropertyByName(assetAttachment, propertyName);
        if (property != null) {
            AbstractMidstreamAssetItemPropertyValue container = property.getValue();
            if (container == null) {
                this.logMissingAssetProperty(assetAttachment, propertyName, optional);
                return defaultValue;
            }
            assert (container instanceof MidstreamAssetItemPropertySingleValue);
            KapiSpec.AssetTraits<?, ?, ?> traits = this.lookupAssetClass(assetAttachment.getAssetClass());
            assert (traits != null);
            MidstreamAssetItemPropertySingleValue singleContainer = (MidstreamAssetItemPropertySingleValue)container;
            FunctionCallArgumentDescriptor value = singleContainer.getValue();
            return this.getPropertyValue(expectedType, value, traits.getKapiSpec());
        }
        this.logMissingAssetProperty(assetAttachment, propertyName, optional);
        return defaultValue;
    }

    protected abstract <T extends ASSET_TYPE> @Nullable T findAssetObjectForPropertyValue(@NonNull Class<T> var1, @Nullable ASSET_TYPE var2, @NonNull REF_TYPE var3);

    protected abstract boolean isAssetObjectClassType(@NonNull Class<?> var1);

    protected void logMissingAssetProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, boolean optional) {
    }

    protected abstract @Nullable KapiSpec.AssetTraits<?, ?, ?> lookupAssetClass(@NonNull String var1);

    private <K, V> @NonNull Map<K, V> getMapPropertyValue(@NonNull MidstreamAssetItemPropertyMapValue mapContainer, @NonNull Class<K> keyClass, @NonNull Class<V> valueClass, @Nullable IConstantOrAliasSpecContainer constantSource) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (MidstreamAssetItemPropertyMapEntryValue entry : mapContainer.getEntries()) {
            K key = this.getPropertyValue(keyClass, entry.getKey(), constantSource);
            V value = this.getPropertyValue(valueClass, entry.getValue(), constantSource);
            result.put(key, value);
        }
        return result;
    }

    private <T> @Nullable T transformListItem(@NonNull MidstreamAssetItem assetAttachment, @NonNull Class<T> elementClass, boolean optional, @Nullable Object o) {
        if (o == null) {
            assert (optional) : "Null value received";
            return null;
        }
        if (elementClass.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        if (elementClass.equals(AbstractConstantOrAliasSpecExtended.class) && o instanceof Long) {
            KapiSpec.AssetTraits<?, ?, ?> traits = this.lookupAssetClass(assetAttachment.getAssetClass());
            assert (traits != null);
            return (T)traits.getKapiSpec().getConstantSpecByValue((Long)o);
        }
        assert (false) : "Unexpected type " + o.getClass() + ": " + o + ", expected " + elementClass;
        return null;
    }

    public @Nullable Bitfield resolveBitfieldProperty(@NonNull MidstreamAssetItem assetAttachment, @NonNull String propertyName, @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> validConstants, boolean optional, @Nullable Bitfield defaultValue) {
        Object propertyValue = this.resolveProperty(assetAttachment, propertyName, Number.class, true, null);
        if (propertyValue == null) {
            this.logMissingAssetProperty(assetAttachment, propertyName, optional);
            assert (defaultValue != null || optional);
            return defaultValue;
        }
        assert (propertyValue instanceof Number);
        long value = ((Number)propertyValue).longValue();
        Bitfield result = new Bitfield();
        for (AbstractConstantOrAliasSpecExtended constant : validConstants) {
            long resolvedValue = constant.getResolvedValue();
            if ((value & resolvedValue) != resolvedValue) continue;
            result.add(constant);
        }
        return result;
    }

    protected static class AssetProviderMap<ACTION_TYPE> {
        private final @NonNull Map<AssetTableSpec, @Nullable Map<Long, List<@NonNull ACTION_TYPE>>> map = new HashMap<AssetTableSpec, Map<Long, List<ACTION_TYPE>>>();

        public @NonNull Map<Long, List<@NonNull ACTION_TYPE>> get(AssetTableSpec assetTable) {
            Map<Long, List<@NonNull ACTION_TYPE>> mapBySpec = this.map.get(assetTable);
            if (mapBySpec != null) {
                return mapBySpec;
            }
            return NullUtils.emptyMap();
        }

        public @NonNull List<@NonNull ACTION_TYPE> get(@NonNull AssetTableSpec assetTable, long assetId) {
            List<ACTION_TYPE> actions;
            Map<Long, List<@NonNull ACTION_TYPE>> mapBySpec = this.map.get(assetTable);
            if (mapBySpec != null && (actions = mapBySpec.get(assetId)) != null) {
                return actions;
            }
            return NullUtils.emptyList();
        }

        public void put(@NonNull AssetTableSpec assetTable, long assetId, @NonNull ACTION_TYPE action) {
            Long idObject;
            List<ACTION_TYPE> actions;
            Map<Long, List<@NonNull ACTION_TYPE>> mapBySpec = this.map.get(assetTable);
            if (mapBySpec == null) {
                mapBySpec = new HashMap<Long, List<ACTION_TYPE>>();
                this.map.put(assetTable, mapBySpec);
            }
            if ((actions = mapBySpec.get(idObject = Long.valueOf(assetId))) == null) {
                actions = new ArrayList<ACTION_TYPE>();
                mapBySpec.put(idObject, actions);
            }
            actions.add(action);
        }
    }
}

