/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.lang.handle;

import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.lang.handle.IHandleType;
import com.arm.mgd.core.target.data.AbstractLongsArgAttachment;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class HandleArrayAttachment
extends AbstractLongsArgAttachment<Handle>
implements IHandleType {
    private static final long serialVersionUID = -6124869614020356718L;
    private final @NonNull Handle.HandleType type;

    public static @NonNull HandleArrayAttachment create(@NonNull Handle.HandleType type, @NonNull LongsArgAttachment longsArgAttachment) {
        HandleArrayAttachment handleArrayAttachment = new HandleArrayAttachment(type, longsArgAttachment.asList());
        Pointer originalPointerValue = longsArgAttachment.getOriginalValue();
        handleArrayAttachment.setOriginalPointerValue(originalPointerValue);
        return handleArrayAttachment;
    }

    private HandleArrayAttachment(@NonNull Handle.HandleType type, @NonNull List<@NonNull Long> longsList) {
        super(longsList);
        this.type = type;
    }

    public @NonNull Handle.HandleType getType() {
        return this.type;
    }

    @Override
    public @NonNull String getDescriptiveText() {
        if (this.isNull()) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        this.forEach(value -> {
            StringBuilder stringBuilder2 = sb.append(value).append(", ");
        });
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    @Override
    public @NonNull ArgumentHierarchyNode getArgumentHierarchy() {
        if (this.isNull()) {
            return ArgumentHierarchyLeaf.nullPointer(this.getArgumentName());
        }
        ArrayList<@NonNull ArgumentHierarchyNode> elementList = new ArrayList<ArgumentHierarchyNode>(this.size());
        for (Handle handleValue : this) {
            elementList.add(new ArgumentHierarchyLeaf((String)NullUtils.neverNull((Object)handleValue.toString()), ArgumentHierarchyLeaf.LeafType.POINTER));
        }
        return ArgumentHierarchyBranch.arrayHierarchy(this.getArgumentName(), elementList);
    }

    @Override
    public @NonNull List<@NonNull Long> asLongsList() {
        return super.asLongsList();
    }

    @Override
    public @NonNull FunctionCallArgumentDescriptor getOriginalObjectFunctionCallArgumentDescriptor() {
        LongsArgAttachment longsValue = LongsArgAttachment.create(this.asLongsList());
        Pointer originalPointerValue = this.getOriginalValue();
        return FunctionCallArgumentDescriptor.create(null, null, null, null, null, null, longsValue, null, originalPointerValue, null, null);
    }

    @Override
    public Iterator<@NonNull Handle> iterator() {
        return this.asList().iterator();
    }

    @Override
    public @NonNull List<@NonNull Handle> asList() {
        ArrayList<@NonNull Handle> list = new ArrayList<Handle>(this.size());
        int i = 0;
        while (i < this.size()) {
            list.add(this.get(i));
            ++i;
        }
        return list;
    }

    @Override
    public @NonNull Handle get(int index) {
        return Handle.valueOf(this.type, this.getLong(index));
    }
}

