/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.lang.handle;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.handle.IHandleType;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public abstract class Handle
implements Comparable<Handle>,
IHandleType,
Serializable {
    private static final long serialVersionUID = -3543908202291651590L;
    private final long handleValue;

    public static @NonNull Handle valueOf(@NonNull HandleType type, long handleValue) {
        if (handleValue == type.emptyHandle.getHandleValue()) {
            return type.emptyHandle;
        }
        return type.handleFactory.create(handleValue);
    }

    private Handle(long handleValue) {
        this.handleValue = handleValue;
    }

    public long getHandleValue() {
        return this.handleValue;
    }

    public abstract @NonNull HandleType getType();

    public boolean isEmptyHandle() {
        return this.equals(this.getType().getEmptyHandle());
    }

    public @NonNull String toString() {
        return (String)NullUtils.neverNull((Object)String.format("0x%x", this.handleValue));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.handleValue ^ this.handleValue >>> 32);
        result = 31 * result + this.getType().hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Handle) {
            Handle otherHandle = (Handle)other;
            return this.handleValue == otherHandle.handleValue && this.getType() == otherHandle.getType();
        }
        return false;
    }

    @Override
    public int compareTo(Handle o) {
        return Long.compare(this.getHandleValue(), o.getHandleValue());
    }

    public static enum HandleType {
        VULKAN_NON_DISPATCHABLE_HANDLE(KapiSpec.VULKAN.constants.VK_NULL_HANDLE.getResolvedValue(), l -> new VulkanNonDispatchableHandle(l));

        private final @NonNull Handle emptyHandle;
        private final @NonNull IHandleFactory handleFactory;

        private HandleType(long nullHandleValue, IHandleFactory handleFactory) {
            this.emptyHandle = handleFactory.create(nullHandleValue);
            this.handleFactory = handleFactory;
        }

        public @NonNull Handle getEmptyHandle() {
            return this.emptyHandle;
        }
    }

    private static interface IHandleFactory {
        public @NonNull Handle create(long var1);
    }

    private static class VulkanNonDispatchableHandle
    extends Handle {
        private static final long serialVersionUID = -596316298383270358L;

        private VulkanNonDispatchableHandle(long handleValue) {
            super(handleValue);
        }

        @Override
        public @NonNull HandleType getType() {
            return HandleType.VULKAN_NON_DISPATCHABLE_HANDLE;
        }

        @Override
        public @NonNull FunctionCallArgumentDescriptor getOriginalObjectFunctionCallArgumentDescriptor() {
            Long value = NullUtils.longValueOf((long)this.getHandleValue());
            return FunctionCallArgumentDescriptor.create(null, value, null, null, null, null, null, null, null, null, null);
        }
    }
}

