/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.lang;

import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class Pointer
implements Serializable,
Comparable<Pointer> {
    public static final @NonNull Pointer NULL = new Pointer(0L);
    private static final long serialVersionUID = 6343943715609794534L;
    private static final int CACHE_LIMIT_SIZE = 900;
    private static final int CACHE_MAX_SIZE = 1024;
    private static final Map<@NonNull Long, SoftReference<Pointer>> valueCache = new LinkedHashMap<Long, SoftReference<Pointer>>();
    private final long address;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull Pointer valueOf(long address) {
        Long addressObj = NullUtils.longValueOf((long)address);
        Map<Long, SoftReference<Pointer>> map = valueCache;
        synchronized (map) {
            Pointer result;
            SoftReference<Pointer> weakRef = valueCache.get(addressObj);
            Pointer pointer = result = weakRef != null ? weakRef.get() : null;
            if (result != null) {
                return result;
            }
            if (valueCache.size() > 1024) {
                Iterator<Map.Entry<@NonNull Long, SoftReference<Pointer>>> iterator = valueCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<@NonNull Long, SoftReference<Pointer>> entry = iterator.next();
                    if (entry.getValue().get() != null) continue;
                    iterator.remove();
                }
                iterator = valueCache.entrySet().iterator();
                while (iterator.hasNext() && valueCache.size() > 900) {
                    iterator.next();
                    iterator.remove();
                }
            }
            Pointer newResult = new Pointer(address);
            valueCache.put(addressObj, new SoftReference<Pointer>(newResult));
            return newResult;
        }
    }

    private Pointer(long address) {
        this.address = address;
    }

    public long address() {
        return this.address;
    }

    public int addressAsInt() {
        assert (this.address >= 0L) : "Address overflows signed long (" + this.toString() + ")";
        assert (this.address <= Integer.MAX_VALUE) : "Address overflows integer (" + this.toString() + ")";
        return (int)this.address;
    }

    @Override
    public int compareTo(Pointer o) {
        return Long.compare(this.address, o.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pointer other = (Pointer)obj;
        return this.address == other.address;
    }

    public boolean fitsInInt() {
        return this.address >= 0L && this.address <= Integer.MAX_VALUE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.address ^ this.address >>> 32);
        return result;
    }

    public @NonNull String toString() {
        return (String)NullUtils.neverNull((Object)String.format("0x%s", Long.toHexString(this.address)));
    }
}

